package one.lfa.opdsget.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Configuration for EPUB squashing.
 */
@Generated(from = "OPDSSquashConfigurationType", generator = "Immutables")
@SuppressWarnings({"all"})
public final class OPDSSquashConfiguration implements OPDSSquashConfigurationType {
  private final double scaleFactor;
  private final double maximumImageWidth;
  private final double maximumImageHeight;

  private OPDSSquashConfiguration(OPDSSquashConfiguration.Builder builder) {
    this.maximumImageWidth = builder.maximumImageWidth;
    this.maximumImageHeight = builder.maximumImageHeight;
    this.scaleFactor = builder.scaleFactorIsSet()
        ? builder.scaleFactor
        : OPDSSquashConfigurationType.super.scaleFactor();
  }

  /**
   * @return The scale factor.
   */
  @Override
  public double scaleFactor() {
    return scaleFactor;
  }

  /**
   * @return The maximum image width, in pixels.
   */
  @Override
  public double maximumImageWidth() {
    return maximumImageWidth;
  }

  /**
   * @return The maximum image height, in pixels.
   */
  @Override
  public double maximumImageHeight() {
    return maximumImageHeight;
  }

  /**
   * This instance is equal to all instances of {@code OPDSSquashConfiguration} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof OPDSSquashConfiguration
        && equalTo((OPDSSquashConfiguration) another);
  }

  private boolean equalTo(OPDSSquashConfiguration another) {
    return Double.doubleToLongBits(scaleFactor) == Double.doubleToLongBits(another.scaleFactor)
        && Double.doubleToLongBits(maximumImageWidth) == Double.doubleToLongBits(another.maximumImageWidth)
        && Double.doubleToLongBits(maximumImageHeight) == Double.doubleToLongBits(another.maximumImageHeight);
  }

  /**
   * Computes a hash code from attributes: {@code scaleFactor}, {@code maximumImageWidth}, {@code maximumImageHeight}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Double.hashCode(scaleFactor);
    h += (h << 5) + Double.hashCode(maximumImageWidth);
    h += (h << 5) + Double.hashCode(maximumImageHeight);
    return h;
  }

  /**
   * Prints the immutable value {@code OPDSSquashConfiguration} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OPDSSquashConfiguration{"
        + "scaleFactor=" + scaleFactor
        + ", maximumImageWidth=" + maximumImageWidth
        + ", maximumImageHeight=" + maximumImageHeight
        + "}";
  }

  /**
   * Creates a builder for {@link OPDSSquashConfiguration OPDSSquashConfiguration}.
   * <pre>
   * OPDSSquashConfiguration.builder()
   *    .setScaleFactor(double) // optional {@link OPDSSquashConfigurationType#scaleFactor() scaleFactor}
   *    .setMaximumImageWidth(double) // required {@link OPDSSquashConfigurationType#maximumImageWidth() maximumImageWidth}
   *    .setMaximumImageHeight(double) // required {@link OPDSSquashConfigurationType#maximumImageHeight() maximumImageHeight}
   *    .build();
   * </pre>
   * @return A new OPDSSquashConfiguration builder
   */
  public static OPDSSquashConfiguration.Builder builder() {
    return new OPDSSquashConfiguration.Builder();
  }

  /**
   * Builds instances of type {@link OPDSSquashConfiguration OPDSSquashConfiguration}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OPDSSquashConfigurationType", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_MAXIMUM_IMAGE_WIDTH = 0x1L;
    private static final long INIT_BIT_MAXIMUM_IMAGE_HEIGHT = 0x2L;
    private static final long OPT_BIT_SCALE_FACTOR = 0x1L;
    private long initBits = 0x3L;
    private long optBits;

    private double scaleFactor;
    private double maximumImageWidth;
    private double maximumImageHeight;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OPDSSquashConfigurationType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OPDSSquashConfigurationType instance) {
      Objects.requireNonNull(instance, "instance");
      setScaleFactor(instance.scaleFactor());
      setMaximumImageWidth(instance.maximumImageWidth());
      setMaximumImageHeight(instance.maximumImageHeight());
      return this;
    }

    /**
     * Initializes the value for the {@link OPDSSquashConfigurationType#scaleFactor() scaleFactor} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link OPDSSquashConfigurationType#scaleFactor() scaleFactor}.</em>
     * @param scaleFactor The value for scaleFactor 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setScaleFactor(double scaleFactor) {
      this.scaleFactor = scaleFactor;
      optBits |= OPT_BIT_SCALE_FACTOR;
      return this;
    }

    /**
     * Initializes the value for the {@link OPDSSquashConfigurationType#maximumImageWidth() maximumImageWidth} attribute.
     * @param maximumImageWidth The value for maximumImageWidth 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMaximumImageWidth(double maximumImageWidth) {
      this.maximumImageWidth = maximumImageWidth;
      initBits &= ~INIT_BIT_MAXIMUM_IMAGE_WIDTH;
      return this;
    }

    /**
     * Initializes the value for the {@link OPDSSquashConfigurationType#maximumImageHeight() maximumImageHeight} attribute.
     * @param maximumImageHeight The value for maximumImageHeight 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMaximumImageHeight(double maximumImageHeight) {
      this.maximumImageHeight = maximumImageHeight;
      initBits &= ~INIT_BIT_MAXIMUM_IMAGE_HEIGHT;
      return this;
    }

    /**
     * Builds a new {@link OPDSSquashConfiguration OPDSSquashConfiguration}.
     * @return An immutable instance of OPDSSquashConfiguration
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public OPDSSquashConfiguration build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new OPDSSquashConfiguration(this);
    }

    private boolean scaleFactorIsSet() {
      return (optBits & OPT_BIT_SCALE_FACTOR) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_MAXIMUM_IMAGE_WIDTH) != 0) attributes.add("maximumImageWidth");
      if ((initBits & INIT_BIT_MAXIMUM_IMAGE_HEIGHT) != 0) attributes.add("maximumImageHeight");
      return "Cannot build OPDSSquashConfiguration, some of required attributes are not set " + attributes;
    }
  }
}
