/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.opdsget.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import one.lfa.opdsget.api.OPDSManifestDescriptionType;
import org.immutables.value.Generated;

@Generated(from="OPDSManifestDescriptionType.FileEntryType", generator="Immutables")
public final class FileEntry
implements OPDSManifestDescriptionType.FileEntryType {
    private final String path;
    private final String hashAlgorithm;
    private final byte[] hash;

    private FileEntry(Builder builder) {
        this.path = builder.path;
        this.hashAlgorithm = builder.hashAlgorithm;
        this.hash = builder.hash;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public String hashAlgorithm() {
        return this.hashAlgorithm;
    }

    @Override
    public byte[] hash() {
        return (byte[])this.hash.clone();
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof FileEntry && this.equalTo((FileEntry)another);
    }

    private boolean equalTo(FileEntry another) {
        return this.path.equals(another.path) && this.hashAlgorithm.equals(another.hashAlgorithm) && Arrays.equals(this.hash, another.hash);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.path.hashCode();
        h += (h << 5) + this.hashAlgorithm.hashCode();
        h += (h << 5) + Arrays.hashCode(this.hash);
        return h;
    }

    public String toString() {
        return "FileEntry{path=" + this.path + ", hashAlgorithm=" + this.hashAlgorithm + ", hash=" + Arrays.toString(this.hash) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OPDSManifestDescriptionType.FileEntryType", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_PATH = 1L;
        private static final long INIT_BIT_HASH_ALGORITHM = 2L;
        private static final long INIT_BIT_HASH = 4L;
        private long initBits = 7L;
        private String path;
        private String hashAlgorithm;
        private byte[] hash;

        private Builder() {
        }

        public final Builder from(OPDSManifestDescriptionType.FileEntryType instance) {
            Objects.requireNonNull(instance, "instance");
            this.setPath(instance.path());
            this.setHashAlgorithm(instance.hashAlgorithm());
            this.setHash(instance.hash());
            return this;
        }

        public final Builder setPath(String path) {
            this.path = Objects.requireNonNull(path, "path");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setHashAlgorithm(String hashAlgorithm) {
            this.hashAlgorithm = Objects.requireNonNull(hashAlgorithm, "hashAlgorithm");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setHash(byte ... hash) {
            this.hash = (byte[])hash.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public FileEntry build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new FileEntry(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("path");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("hashAlgorithm");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build FileEntry, some of required attributes are not set " + attributes;
        }
    }
}

