/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.opdsget.api;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import one.lfa.opdsget.api.OPDSDocumentProcessedType;
import one.lfa.opdsget.api.OPDSLocalFile;
import org.immutables.value.Generated;

@Generated(from="OPDSDocumentProcessedType", generator="Immutables")
public final class OPDSDocumentProcessed
implements OPDSDocumentProcessedType {
    private final Map<URI, OPDSLocalFile> feeds;
    private final Map<URI, OPDSLocalFile> images;
    private final Map<URI, OPDSLocalFile> books;
    private final OPDSLocalFile file;
    private final boolean entry;
    private final String title;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private OPDSDocumentProcessed(Map<? extends URI, ? extends OPDSLocalFile> feeds, Map<? extends URI, ? extends OPDSLocalFile> images, Map<? extends URI, ? extends OPDSLocalFile> books, OPDSLocalFile file, boolean entry, String title) {
        this.feeds = OPDSDocumentProcessed.createUnmodifiableMap(true, false, feeds);
        this.images = OPDSDocumentProcessed.createUnmodifiableMap(true, false, images);
        this.books = OPDSDocumentProcessed.createUnmodifiableMap(true, false, books);
        this.file = Objects.requireNonNull(file, "file");
        this.entry = entry;
        this.title = Objects.requireNonNull(title, "title");
        this.initShim = null;
    }

    private OPDSDocumentProcessed(Builder builder) {
        this.file = builder.file;
        this.entry = builder.entry;
        this.title = builder.title;
        if (builder.feedsIsSet()) {
            this.initShim.setFeeds(OPDSDocumentProcessed.createUnmodifiableMap(false, false, builder.feeds));
        }
        if (builder.imagesIsSet()) {
            this.initShim.setImages(OPDSDocumentProcessed.createUnmodifiableMap(false, false, builder.images));
        }
        if (builder.booksIsSet()) {
            this.initShim.setBooks(OPDSDocumentProcessed.createUnmodifiableMap(false, false, builder.books));
        }
        this.feeds = this.initShim.feeds();
        this.images = this.initShim.images();
        this.books = this.initShim.books();
        this.initShim = null;
    }

    private Map<URI, OPDSLocalFile> feedsInitialize() {
        return OPDSDocumentProcessedType.super.feeds();
    }

    private Map<URI, OPDSLocalFile> imagesInitialize() {
        return OPDSDocumentProcessedType.super.images();
    }

    private Map<URI, OPDSLocalFile> booksInitialize() {
        return OPDSDocumentProcessedType.super.books();
    }

    @Override
    public Map<URI, OPDSLocalFile> feeds() {
        InitShim shim = this.initShim;
        return shim != null ? shim.feeds() : this.feeds;
    }

    @Override
    public Map<URI, OPDSLocalFile> images() {
        InitShim shim = this.initShim;
        return shim != null ? shim.images() : this.images;
    }

    @Override
    public Map<URI, OPDSLocalFile> books() {
        InitShim shim = this.initShim;
        return shim != null ? shim.books() : this.books;
    }

    @Override
    public OPDSLocalFile file() {
        return this.file;
    }

    @Override
    public boolean isEntry() {
        return this.entry;
    }

    @Override
    public String title() {
        return this.title;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof OPDSDocumentProcessed && this.equalTo((OPDSDocumentProcessed)another);
    }

    private boolean equalTo(OPDSDocumentProcessed another) {
        return this.feeds.equals(another.feeds) && this.images.equals(another.images) && this.books.equals(another.books) && this.file.equals(another.file) && this.entry == another.entry && this.title.equals(another.title);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.feeds.hashCode();
        h += (h << 5) + this.images.hashCode();
        h += (h << 5) + this.books.hashCode();
        h += (h << 5) + this.file.hashCode();
        h += (h << 5) + Boolean.hashCode(this.entry);
        h += (h << 5) + this.title.hashCode();
        return h;
    }

    public String toString() {
        return "OPDSDocumentProcessed{feeds=" + this.feeds + ", images=" + this.images + ", books=" + this.books + ", file=" + this.file + ", entry=" + this.entry + ", title=" + this.title + "}";
    }

    public static OPDSDocumentProcessed of(Map<? extends URI, ? extends OPDSLocalFile> feeds, Map<? extends URI, ? extends OPDSLocalFile> images, Map<? extends URI, ? extends OPDSLocalFile> books, OPDSLocalFile file, boolean entry, String title) {
        return OPDSDocumentProcessed.validate(new OPDSDocumentProcessed(feeds, images, books, file, entry, title));
    }

    private static OPDSDocumentProcessed validate(OPDSDocumentProcessed instance) {
        instance.checkPreconditions();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="OPDSDocumentProcessedType", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_FILE = 1L;
        private static final long INIT_BIT_ENTRY = 2L;
        private static final long INIT_BIT_TITLE = 4L;
        private static final long OPT_BIT_FEEDS = 1L;
        private static final long OPT_BIT_IMAGES = 2L;
        private static final long OPT_BIT_BOOKS = 4L;
        private long initBits = 7L;
        private long optBits;
        private Map<URI, OPDSLocalFile> feeds = new LinkedHashMap<URI, OPDSLocalFile>();
        private Map<URI, OPDSLocalFile> images = new LinkedHashMap<URI, OPDSLocalFile>();
        private Map<URI, OPDSLocalFile> books = new LinkedHashMap<URI, OPDSLocalFile>();
        private OPDSLocalFile file;
        private boolean entry;
        private String title;

        private Builder() {
        }

        public final Builder from(OPDSDocumentProcessedType instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllFeeds(instance.feeds());
            this.putAllImages(instance.images());
            this.putAllBooks(instance.books());
            this.setFile(instance.file());
            this.setEntry(instance.isEntry());
            this.setTitle(instance.title());
            return this;
        }

        public final Builder putFeeds(URI key, OPDSLocalFile value) {
            this.feeds.put(Objects.requireNonNull(key, "feeds key"), Objects.requireNonNull(value, "feeds value"));
            this.optBits |= 1L;
            return this;
        }

        public final Builder putFeeds(Map.Entry<? extends URI, ? extends OPDSLocalFile> entry) {
            URI k = entry.getKey();
            OPDSLocalFile v = entry.getValue();
            this.feeds.put(Objects.requireNonNull(k, "feeds key"), Objects.requireNonNull(v, "feeds value"));
            this.optBits |= 1L;
            return this;
        }

        public final Builder setFeeds(Map<? extends URI, ? extends OPDSLocalFile> entries) {
            this.feeds.clear();
            this.optBits |= 1L;
            return this.putAllFeeds(entries);
        }

        public final Builder putAllFeeds(Map<? extends URI, ? extends OPDSLocalFile> entries) {
            for (Map.Entry<? extends URI, ? extends OPDSLocalFile> e : entries.entrySet()) {
                URI k = e.getKey();
                OPDSLocalFile v = e.getValue();
                this.feeds.put(Objects.requireNonNull(k, "feeds key"), Objects.requireNonNull(v, "feeds value"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder putImages(URI key, OPDSLocalFile value) {
            this.images.put(Objects.requireNonNull(key, "images key"), Objects.requireNonNull(value, "images value"));
            this.optBits |= 2L;
            return this;
        }

        public final Builder putImages(Map.Entry<? extends URI, ? extends OPDSLocalFile> entry) {
            URI k = entry.getKey();
            OPDSLocalFile v = entry.getValue();
            this.images.put(Objects.requireNonNull(k, "images key"), Objects.requireNonNull(v, "images value"));
            this.optBits |= 2L;
            return this;
        }

        public final Builder setImages(Map<? extends URI, ? extends OPDSLocalFile> entries) {
            this.images.clear();
            this.optBits |= 2L;
            return this.putAllImages(entries);
        }

        public final Builder putAllImages(Map<? extends URI, ? extends OPDSLocalFile> entries) {
            for (Map.Entry<? extends URI, ? extends OPDSLocalFile> e : entries.entrySet()) {
                URI k = e.getKey();
                OPDSLocalFile v = e.getValue();
                this.images.put(Objects.requireNonNull(k, "images key"), Objects.requireNonNull(v, "images value"));
            }
            this.optBits |= 2L;
            return this;
        }

        public final Builder putBooks(URI key, OPDSLocalFile value) {
            this.books.put(Objects.requireNonNull(key, "books key"), Objects.requireNonNull(value, "books value"));
            this.optBits |= 4L;
            return this;
        }

        public final Builder putBooks(Map.Entry<? extends URI, ? extends OPDSLocalFile> entry) {
            URI k = entry.getKey();
            OPDSLocalFile v = entry.getValue();
            this.books.put(Objects.requireNonNull(k, "books key"), Objects.requireNonNull(v, "books value"));
            this.optBits |= 4L;
            return this;
        }

        public final Builder setBooks(Map<? extends URI, ? extends OPDSLocalFile> entries) {
            this.books.clear();
            this.optBits |= 4L;
            return this.putAllBooks(entries);
        }

        public final Builder putAllBooks(Map<? extends URI, ? extends OPDSLocalFile> entries) {
            for (Map.Entry<? extends URI, ? extends OPDSLocalFile> e : entries.entrySet()) {
                URI k = e.getKey();
                OPDSLocalFile v = e.getValue();
                this.books.put(Objects.requireNonNull(k, "books key"), Objects.requireNonNull(v, "books value"));
            }
            this.optBits |= 4L;
            return this;
        }

        public final Builder setFile(OPDSLocalFile file) {
            this.file = Objects.requireNonNull(file, "file");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setEntry(boolean entry) {
            this.entry = entry;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setTitle(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public OPDSDocumentProcessed build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return OPDSDocumentProcessed.validate(new OPDSDocumentProcessed(this));
        }

        private boolean feedsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean imagesIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean booksIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("file");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("entry");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("title");
            }
            return "Cannot build OPDSDocumentProcessed, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="OPDSDocumentProcessedType", generator="Immutables")
    private final class InitShim {
        private byte feedsBuildStage = 0;
        private Map<URI, OPDSLocalFile> feeds;
        private byte imagesBuildStage = 0;
        private Map<URI, OPDSLocalFile> images;
        private byte booksBuildStage = 0;
        private Map<URI, OPDSLocalFile> books;

        private InitShim() {
        }

        Map<URI, OPDSLocalFile> feeds() {
            if (this.feedsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.feedsBuildStage == 0) {
                this.feedsBuildStage = (byte)-1;
                this.feeds = OPDSDocumentProcessed.createUnmodifiableMap(true, false, OPDSDocumentProcessed.this.feedsInitialize());
                this.feedsBuildStage = 1;
            }
            return this.feeds;
        }

        void setFeeds(Map<URI, OPDSLocalFile> feeds) {
            this.feeds = feeds;
            this.feedsBuildStage = 1;
        }

        Map<URI, OPDSLocalFile> images() {
            if (this.imagesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.imagesBuildStage == 0) {
                this.imagesBuildStage = (byte)-1;
                this.images = OPDSDocumentProcessed.createUnmodifiableMap(true, false, OPDSDocumentProcessed.this.imagesInitialize());
                this.imagesBuildStage = 1;
            }
            return this.images;
        }

        void setImages(Map<URI, OPDSLocalFile> images) {
            this.images = images;
            this.imagesBuildStage = 1;
        }

        Map<URI, OPDSLocalFile> books() {
            if (this.booksBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.booksBuildStage == 0) {
                this.booksBuildStage = (byte)-1;
                this.books = OPDSDocumentProcessed.createUnmodifiableMap(true, false, OPDSDocumentProcessed.this.booksInitialize());
                this.booksBuildStage = 1;
            }
            return this.books;
        }

        void setBooks(Map<URI, OPDSLocalFile> books) {
            this.books = books;
            this.booksBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.feedsBuildStage == -1) {
                attributes.add("feeds");
            }
            if (this.imagesBuildStage == -1) {
                attributes.add("images");
            }
            if (this.booksBuildStage == -1) {
                attributes.add("books");
            }
            return "Cannot build OPDSDocumentProcessed, attribute initializers form cycle " + attributes;
        }
    }
}

