/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.opdsget.api;

import java.net.URI;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import one.lfa.opdsget.api.ImmutableStyleType;
import one.lfa.opdsget.api.OPDSAuthenticationType;
import one.lfa.opdsget.api.OPDSGetKind;
import one.lfa.opdsget.api.OPDSSquashConfiguration;
import one.lfa.opdsget.api.OPDSURIHashing;
import one.lfa.opdsget.api.OPDSURIRewriterType;
import one.lfa.opdsget.api.OPDSURIRewriters;
import org.immutables.value.Value;

@ImmutableStyleType
@Value.Immutable
public interface OPDSGetConfigurationType {
    @Value.Parameter
    public Path output();

    @Value.Parameter
    public Optional<Path> outputArchive();

    @Value.Parameter
    public URI remoteURI();

    @Value.Default
    @Value.Parameter
    default public OPDSURIRewriterType uriRewriter() {
        return OPDSURIRewriters.plainFileRewriter(this.output());
    }

    @Value.Default
    @Value.Parameter
    default public Function<URI, Optional<OPDSAuthenticationType>> authenticationSupplier() {
        return uri -> Optional.empty();
    }

    default public Path typedDirectory(String type) {
        return this.output().resolve(Objects.requireNonNull(type, "type"));
    }

    default public Path feedFile(String name) {
        Objects.requireNonNull(name, "name");
        return this.feedDirectory().resolve(name);
    }

    default public Path feedFileHashed(URI uri) {
        Objects.requireNonNull(uri, "uri");
        return this.feedFile(OPDSURIHashing.hashOf(uri) + ".atom");
    }

    default public Path feedDirectory() {
        return this.typedDirectory("feeds");
    }

    default public Path imageFile(String name) {
        Objects.requireNonNull(name, "name");
        return this.imageDirectory().resolve(name);
    }

    default public Path imageFileHashed(URI uri) {
        Objects.requireNonNull(uri, "uri");
        return this.imageFile(OPDSURIHashing.hashOf(uri));
    }

    default public Path imageDirectory() {
        return this.typedDirectory("images");
    }

    default public Path bookFile(String name) {
        Objects.requireNonNull(name, "name");
        return this.bookDirectory().resolve(name);
    }

    default public Path bookFileHashed(URI uri) {
        Objects.requireNonNull(uri, "uri");
        return this.bookFile(OPDSURIHashing.hashOf(uri) + ".epub");
    }

    default public Path bookDirectory() {
        return this.typedDirectory("books");
    }

    @Value.Default
    @Value.Parameter
    default public Set<OPDSGetKind> fetchedKinds() {
        return EnumSet.allOf(OPDSGetKind.class);
    }

    @Value.Parameter
    public Optional<OPDSSquashConfiguration> squash();

    public OptionalDouble scaleImages();

    @Value.Check
    default public void checkPreconditions() {
        Path outputArchive;
        Path outputPath = this.output();
        if (!outputPath.isAbsolute()) {
            throw new IllegalArgumentException(String.format("Output path %s must be absolute", outputPath));
        }
        Optional<Path> outputArchiveOpt = this.outputArchive();
        if (outputArchiveOpt.isPresent() && !(outputArchive = outputArchiveOpt.get()).isAbsolute()) {
            throw new IllegalArgumentException(String.format("Output archive path %s must be absolute", outputArchive));
        }
    }

    public Optional<URI> outputManifestBaseURI();

    @Value.Default
    default public UUID outputManifestID() {
        return UUID.randomUUID();
    }

    @Value.Default
    default public String outputManifestTitle() {
        return "";
    }
}

