/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.opdsget.api;

import java.net.URI;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import one.lfa.opdsget.api.FileEntry;
import one.lfa.opdsget.api.OPDSManifestDescriptionType;
import org.immutables.value.Generated;

@Generated(from="OPDSManifestDescriptionType", generator="Immutables")
public final class OPDSManifestDescription
implements OPDSManifestDescriptionType {
    private final UUID id;
    private final String rootFile;
    private final String title;
    private final OffsetDateTime updated;
    private final String searchIndex;
    private final URI base;
    private final Map<URI, FileEntry> files;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private OPDSManifestDescription(Builder builder) {
        this.id = builder.id;
        this.rootFile = builder.rootFile;
        this.searchIndex = builder.searchIndex;
        this.base = builder.base;
        this.files = OPDSManifestDescription.createUnmodifiableMap(false, false, builder.files);
        if (builder.title != null) {
            this.initShim.setTitle(builder.title);
        }
        if (builder.updated != null) {
            this.initShim.setUpdated(builder.updated);
        }
        this.title = this.initShim.title();
        this.updated = this.initShim.updated();
        this.initShim = null;
    }

    private String titleInitialize() {
        return OPDSManifestDescriptionType.super.title();
    }

    private OffsetDateTime updatedInitialize() {
        return OPDSManifestDescriptionType.super.updated();
    }

    @Override
    public UUID id() {
        return this.id;
    }

    @Override
    public String rootFile() {
        return this.rootFile;
    }

    @Override
    public String title() {
        InitShim shim = this.initShim;
        return shim != null ? shim.title() : this.title;
    }

    @Override
    public OffsetDateTime updated() {
        InitShim shim = this.initShim;
        return shim != null ? shim.updated() : this.updated;
    }

    @Override
    public Optional<String> searchIndex() {
        return Optional.ofNullable(this.searchIndex);
    }

    @Override
    public Optional<URI> base() {
        return Optional.ofNullable(this.base);
    }

    @Override
    public Map<URI, FileEntry> files() {
        return this.files;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof OPDSManifestDescription && this.equalTo((OPDSManifestDescription)another);
    }

    private boolean equalTo(OPDSManifestDescription another) {
        return this.id.equals(another.id) && this.rootFile.equals(another.rootFile) && this.title.equals(another.title) && this.updated.equals(another.updated) && Objects.equals(this.searchIndex, another.searchIndex) && Objects.equals(this.base, another.base) && this.files.equals(another.files);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.rootFile.hashCode();
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + this.updated.hashCode();
        h += (h << 5) + Objects.hashCode(this.searchIndex);
        h += (h << 5) + Objects.hashCode(this.base);
        h += (h << 5) + this.files.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("OPDSManifestDescription{");
        builder.append("id=").append(this.id);
        builder.append(", ");
        builder.append("rootFile=").append(this.rootFile);
        builder.append(", ");
        builder.append("title=").append(this.title);
        builder.append(", ");
        builder.append("updated=").append(this.updated);
        if (this.searchIndex != null) {
            builder.append(", ");
            builder.append("searchIndex=").append(this.searchIndex);
        }
        if (this.base != null) {
            builder.append(", ");
            builder.append("base=").append(this.base);
        }
        builder.append(", ");
        builder.append("files=").append(this.files);
        return builder.append("}").toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="OPDSManifestDescriptionType", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_ROOT_FILE = 2L;
        private long initBits = 3L;
        private UUID id;
        private String rootFile;
        private String title;
        private OffsetDateTime updated;
        private String searchIndex;
        private URI base;
        private Map<URI, FileEntry> files = new LinkedHashMap<URI, FileEntry>();

        private Builder() {
        }

        public final Builder from(OPDSManifestDescriptionType instance) {
            Optional<URI> baseOptional;
            Objects.requireNonNull(instance, "instance");
            this.setId(instance.id());
            this.setRootFile(instance.rootFile());
            this.setTitle(instance.title());
            this.setUpdated(instance.updated());
            Optional<String> searchIndexOptional = instance.searchIndex();
            if (searchIndexOptional.isPresent()) {
                this.setSearchIndex(searchIndexOptional);
            }
            if ((baseOptional = instance.base()).isPresent()) {
                this.setBase(baseOptional);
            }
            this.putAllFiles(instance.files());
            return this;
        }

        public final Builder setId(UUID id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setRootFile(String rootFile) {
            this.rootFile = Objects.requireNonNull(rootFile, "rootFile");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setTitle(String title) {
            this.title = Objects.requireNonNull(title, "title");
            return this;
        }

        public final Builder setUpdated(OffsetDateTime updated) {
            this.updated = Objects.requireNonNull(updated, "updated");
            return this;
        }

        public final Builder setSearchIndex(String searchIndex) {
            this.searchIndex = Objects.requireNonNull(searchIndex, "searchIndex");
            return this;
        }

        public final Builder setSearchIndex(Optional<String> searchIndex) {
            this.searchIndex = searchIndex.orElse(null);
            return this;
        }

        public final Builder setBase(URI base) {
            this.base = Objects.requireNonNull(base, "base");
            return this;
        }

        public final Builder setBase(Optional<? extends URI> base) {
            this.base = base.orElse(null);
            return this;
        }

        public final Builder putFiles(URI key, FileEntry value) {
            this.files.put(Objects.requireNonNull(key, "files key"), Objects.requireNonNull(value, "files value"));
            return this;
        }

        public final Builder putFiles(Map.Entry<? extends URI, ? extends FileEntry> entry) {
            URI k = entry.getKey();
            FileEntry v = entry.getValue();
            this.files.put(Objects.requireNonNull(k, "files key"), Objects.requireNonNull(v, "files value"));
            return this;
        }

        public final Builder setFiles(Map<? extends URI, ? extends FileEntry> entries) {
            this.files.clear();
            return this.putAllFiles(entries);
        }

        public final Builder putAllFiles(Map<? extends URI, ? extends FileEntry> entries) {
            for (Map.Entry<? extends URI, ? extends FileEntry> e : entries.entrySet()) {
                URI k = e.getKey();
                FileEntry v = e.getValue();
                this.files.put(Objects.requireNonNull(k, "files key"), Objects.requireNonNull(v, "files value"));
            }
            return this;
        }

        public OPDSManifestDescription build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new OPDSManifestDescription(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("rootFile");
            }
            return "Cannot build OPDSManifestDescription, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="OPDSManifestDescriptionType", generator="Immutables")
    private final class InitShim {
        private byte titleBuildStage = 0;
        private String title;
        private byte updatedBuildStage = 0;
        private OffsetDateTime updated;

        private InitShim() {
        }

        String title() {
            if (this.titleBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.titleBuildStage == 0) {
                this.titleBuildStage = (byte)-1;
                this.title = Objects.requireNonNull(OPDSManifestDescription.this.titleInitialize(), "title");
                this.titleBuildStage = 1;
            }
            return this.title;
        }

        void setTitle(String title) {
            this.title = title;
            this.titleBuildStage = 1;
        }

        OffsetDateTime updated() {
            if (this.updatedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.updatedBuildStage == 0) {
                this.updatedBuildStage = (byte)-1;
                this.updated = Objects.requireNonNull(OPDSManifestDescription.this.updatedInitialize(), "updated");
                this.updatedBuildStage = 1;
            }
            return this.updated;
        }

        void setUpdated(OffsetDateTime updated) {
            this.updated = updated;
            this.updatedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.titleBuildStage == -1) {
                attributes.add("title");
            }
            if (this.updatedBuildStage == -1) {
                attributes.add("updated");
            }
            return "Cannot build OPDSManifestDescription, attribute initializers form cycle " + attributes;
        }
    }
}

