package one.lfa.opdsget.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * HTTP Basic auth.
 */
@Generated(from = "OPDSAuthenticationType.OPDSAuthenticationBasicType", generator = "Immutables")
@SuppressWarnings({"all"})
public final class OPDSAuthenticationBasic
    implements OPDSAuthenticationType.OPDSAuthenticationBasicType {
  private final String user;
  private final String password;

  private OPDSAuthenticationBasic(String user, String password) {
    this.user = Objects.requireNonNull(user, "user");
    this.password = Objects.requireNonNull(password, "password");
  }

  private OPDSAuthenticationBasic(OPDSAuthenticationBasic.Builder builder) {
    this.user = builder.user;
    this.password = builder.password;
  }

  /**
   * @return The username
   */
  @Override
  public String user() {
    return user;
  }

  /**
   * @return The password
   */
  @Override
  public String password() {
    return password;
  }

  /**
   * This instance is equal to all instances of {@code OPDSAuthenticationBasic} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof OPDSAuthenticationBasic
        && equalTo((OPDSAuthenticationBasic) another);
  }

  private boolean equalTo(OPDSAuthenticationBasic another) {
    return user.equals(another.user)
        && password.equals(another.password);
  }

  /**
   * Computes a hash code from attributes: {@code user}, {@code password}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + user.hashCode();
    h += (h << 5) + password.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code OPDSAuthenticationBasic} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OPDSAuthenticationBasic{"
        + "user=" + user
        + ", password=" + password
        + "}";
  }

  /**
   * Construct a new immutable {@code OPDSAuthenticationBasic} instance.
   * @param user The value for the {@code user} attribute
   * @param password The value for the {@code password} attribute
   * @return An immutable OPDSAuthenticationBasic instance
   */
  public static OPDSAuthenticationBasic of(String user, String password) {
    return new OPDSAuthenticationBasic(user, password);
  }

  /**
   * Creates a builder for {@link OPDSAuthenticationBasic OPDSAuthenticationBasic}.
   * <pre>
   * OPDSAuthenticationBasic.builder()
   *    .setUser(String) // required {@link OPDSAuthenticationType.OPDSAuthenticationBasicType#user() user}
   *    .setPassword(String) // required {@link OPDSAuthenticationType.OPDSAuthenticationBasicType#password() password}
   *    .build();
   * </pre>
   * @return A new OPDSAuthenticationBasic builder
   */
  public static OPDSAuthenticationBasic.Builder builder() {
    return new OPDSAuthenticationBasic.Builder();
  }

  /**
   * Builds instances of type {@link OPDSAuthenticationBasic OPDSAuthenticationBasic}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OPDSAuthenticationType.OPDSAuthenticationBasicType", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_USER = 0x1L;
    private static final long INIT_BIT_PASSWORD = 0x2L;
    private long initBits = 0x3L;

    private String user;
    private String password;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OPDSAuthenticationBasicType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OPDSAuthenticationType.OPDSAuthenticationBasicType instance) {
      Objects.requireNonNull(instance, "instance");
      setUser(instance.user());
      setPassword(instance.password());
      return this;
    }

    /**
     * Initializes the value for the {@link OPDSAuthenticationType.OPDSAuthenticationBasicType#user() user} attribute.
     * @param user The value for user 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUser(String user) {
      this.user = Objects.requireNonNull(user, "user");
      initBits &= ~INIT_BIT_USER;
      return this;
    }

    /**
     * Initializes the value for the {@link OPDSAuthenticationType.OPDSAuthenticationBasicType#password() password} attribute.
     * @param password The value for password 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPassword(String password) {
      this.password = Objects.requireNonNull(password, "password");
      initBits &= ~INIT_BIT_PASSWORD;
      return this;
    }

    /**
     * Builds a new {@link OPDSAuthenticationBasic OPDSAuthenticationBasic}.
     * @return An immutable instance of OPDSAuthenticationBasic
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public OPDSAuthenticationBasic build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new OPDSAuthenticationBasic(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_USER) != 0) attributes.add("user");
      if ((initBits & INIT_BIT_PASSWORD) != 0) attributes.add("password");
      return "Cannot build OPDSAuthenticationBasic, some of required attributes are not set " + attributes;
    }
  }
}
