package one.lfa.opdsget.api;

import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * A file that has been downloaded to the local filesystem.
 */
@Generated(from = "OPDSLocalFileType", generator = "Immutables")
@SuppressWarnings({"all"})
public final class OPDSLocalFile implements OPDSLocalFileType {
  private final URI uri;
  private final Path file;

  private OPDSLocalFile(URI uri, Path file) {
    this.uri = Objects.requireNonNull(uri, "uri");
    this.file = Objects.requireNonNull(file, "file");
  }

  private OPDSLocalFile(OPDSLocalFile.Builder builder) {
    this.uri = builder.uri;
    this.file = builder.file;
  }

  /**
   * @return The original URI
   */
  @Override
  public URI uri() {
    return uri;
  }

  /**
   * @return The output file
   */
  @Override
  public Path file() {
    return file;
  }

  /**
   * This instance is equal to all instances of {@code OPDSLocalFile} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof OPDSLocalFile
        && equalTo((OPDSLocalFile) another);
  }

  private boolean equalTo(OPDSLocalFile another) {
    return uri.equals(another.uri)
        && file.equals(another.file);
  }

  /**
   * Computes a hash code from attributes: {@code uri}, {@code file}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + uri.hashCode();
    h += (h << 5) + file.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code OPDSLocalFile} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OPDSLocalFile{"
        + "uri=" + uri
        + ", file=" + file
        + "}";
  }

  /**
   * Construct a new immutable {@code OPDSLocalFile} instance.
   * @param uri The value for the {@code uri} attribute
   * @param file The value for the {@code file} attribute
   * @return An immutable OPDSLocalFile instance
   */
  public static OPDSLocalFile of(URI uri, Path file) {
    return new OPDSLocalFile(uri, file);
  }

  /**
   * Creates a builder for {@link OPDSLocalFile OPDSLocalFile}.
   * <pre>
   * OPDSLocalFile.builder()
   *    .setUri(java.net.URI) // required {@link OPDSLocalFileType#uri() uri}
   *    .setFile(java.nio.file.Path) // required {@link OPDSLocalFileType#file() file}
   *    .build();
   * </pre>
   * @return A new OPDSLocalFile builder
   */
  public static OPDSLocalFile.Builder builder() {
    return new OPDSLocalFile.Builder();
  }

  /**
   * Builds instances of type {@link OPDSLocalFile OPDSLocalFile}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OPDSLocalFileType", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_URI = 0x1L;
    private static final long INIT_BIT_FILE = 0x2L;
    private long initBits = 0x3L;

    private URI uri;
    private Path file;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OPDSLocalFileType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OPDSLocalFileType instance) {
      Objects.requireNonNull(instance, "instance");
      setUri(instance.uri());
      setFile(instance.file());
      return this;
    }

    /**
     * Initializes the value for the {@link OPDSLocalFileType#uri() uri} attribute.
     * @param uri The value for uri 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUri(URI uri) {
      this.uri = Objects.requireNonNull(uri, "uri");
      initBits &= ~INIT_BIT_URI;
      return this;
    }

    /**
     * Initializes the value for the {@link OPDSLocalFileType#file() file} attribute.
     * @param file The value for file 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setFile(Path file) {
      this.file = Objects.requireNonNull(file, "file");
      initBits &= ~INIT_BIT_FILE;
      return this;
    }

    /**
     * Builds a new {@link OPDSLocalFile OPDSLocalFile}.
     * @return An immutable instance of OPDSLocalFile
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public OPDSLocalFile build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new OPDSLocalFile(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_URI) != 0) attributes.add("uri");
      if ((initBits & INIT_BIT_FILE) != 0) attributes.add("file");
      return "Cannot build OPDSLocalFile, some of required attributes are not set " + attributes;
    }
  }
}
