/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.opdsget.api;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import one.lfa.opdsget.api.OPDSAuthenticationBasic;
import one.lfa.opdsget.api.OPDSAuthenticationType;
import one.lfa.opdsget.api.OPDSHTTPData;
import one.lfa.opdsget.api.OPDSHTTPException;
import one.lfa.opdsget.api.OPDSHTTPType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OPDSHTTPDefault
implements OPDSHTTPType {
    private static final Logger LOG = LoggerFactory.getLogger(OPDSHTTPDefault.class);
    private static final long RETRY_WAIT_SECONDS = 6L;
    private static final int RETRY_MAX_ATTEMPTS = 10;

    private static void configureConnectionAuth(HttpURLConnection connection, OPDSAuthenticationType auth) {
        switch (auth.kind()) {
            case AUTHENTICATION_BASIC: {
                OPDSAuthenticationBasic basic = (OPDSAuthenticationBasic)auth;
                String text = new StringBuilder(64).append(basic.user()).append(":").append(basic.password()).toString();
                String encoded = Base64.getEncoder().encodeToString(text.getBytes(StandardCharsets.US_ASCII));
                connection.addRequestProperty("Authorization", "Basic " + encoded);
                break;
            }
        }
    }

    private static void delay() {
        try {
            long seconds = 6L;
            LOG.debug("waiting for {} seconds", (Object)6L);
            Thread.sleep(6000L);
        }
        catch (InterruptedException e) {
            LOG.error("delay interrupted: ", (Throwable)e);
        }
    }

    private static String failureMessage(URI uri, int code, String message) {
        return new StringBuilder(128).append("GET failed: ").append(code).append(" ").append(message).append(System.lineSeparator()).append("  URI: ").append(uri).append(System.lineSeparator()).toString();
    }

    @Override
    public OPDSHTTPData get(URI uri, Optional<OPDSAuthenticationType> auth_opt) throws OPDSHTTPException {
        URL url;
        LOG.debug("GET {}", (Object)uri);
        try {
            url = uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new OPDSHTTPException(e, -1, "");
        }
        for (int attempt = 0; attempt < 10; ++attempt) {
            try {
                String failure_message;
                String message;
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setInstanceFollowRedirects(false);
                connection.setRequestMethod("GET");
                connection.setRequestProperty("User-Agent", "one.lfa.opdsget");
                auth_opt.ifPresent(auth -> OPDSHTTPDefault.configureConnectionAuth(connection, auth));
                int code = connection.getResponseCode();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("GET {} -> {} ({} of {})", new Object[]{uri, code, attempt + 1, 10});
                }
                switch (connection.getResponseCode()) {
                    case 301: 
                    case 302: {
                        String location = URLDecoder.decode(connection.getHeaderField("Location"), "UTF-8");
                        URL base = new URL(url.toString());
                        URL next = new URL(base, location);
                        try {
                            return this.get(new URI(next.getProtocol(), next.getHost(), next.getPath(), next.getQuery()), Optional.empty());
                        }
                        catch (URISyntaxException e) {
                            throw new OPDSHTTPException(e, -1, "");
                        }
                    }
                }
                if (code < 500) {
                    if (code >= 400) {
                        message = connection.getResponseMessage();
                        failure_message = OPDSHTTPDefault.failureMessage(uri, code, message);
                        throw new OPDSHTTPException(failure_message, code, message);
                    }
                    return OPDSHTTPData.of(connection.getContentLengthLong(), connection.getContentType(), connection.getInputStream());
                }
                message = connection.getResponseMessage();
                failure_message = OPDSHTTPDefault.failureMessage(uri, code, message);
                LOG.error("{}", (Object)failure_message);
                OPDSHTTPDefault.delay();
                continue;
            }
            catch (IOException e) {
                LOG.error("i/o error: GET {}: ", (Object)uri, (Object)e);
                OPDSHTTPDefault.delay();
            }
        }
        throw new OPDSHTTPException(new StringBuilder(128).append("Failed to retrieve URI after repeated attempts").append(System.lineSeparator()).append("  URI: ").append(uri).append(System.lineSeparator()).append("  Attempts: ").append(10).append(System.lineSeparator()).toString(), -1, "");
    }
}

