package one.lfa.opdsget.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * An authentication matcher that works from a list of patterns. URIs will be matched against the
 * given list of patterns, in order, stopping at the first pattern that matches (or returning no
 * authentication data if no patterns match).
 */
@Generated(from = "OPDSAuthenticationPatternMappedType", generator = "Immutables")
@SuppressWarnings({"all"})
public final class OPDSAuthenticationPatternMapped
    implements OPDSAuthenticationPatternMappedType {
  private final List<OPDSMatchingAuthentication> patterns;

  private OPDSAuthenticationPatternMapped(Iterable<? extends OPDSMatchingAuthentication> patterns) {
    this.patterns = createUnmodifiableList(false, createSafeList(patterns, true, false));
  }

  private OPDSAuthenticationPatternMapped(OPDSAuthenticationPatternMapped.Builder builder) {
    this.patterns = createUnmodifiableList(true, builder.patterns);
  }

  /**
   * @return The list of pattern matchers in application order
   */
  @Override
  public List<OPDSMatchingAuthentication> patterns() {
    return patterns;
  }

  /**
   * This instance is equal to all instances of {@code OPDSAuthenticationPatternMapped} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof OPDSAuthenticationPatternMapped
        && equalTo((OPDSAuthenticationPatternMapped) another);
  }

  private boolean equalTo(OPDSAuthenticationPatternMapped another) {
    return patterns.equals(another.patterns);
  }

  /**
   * Computes a hash code from attributes: {@code patterns}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + patterns.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code OPDSAuthenticationPatternMapped} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OPDSAuthenticationPatternMapped{"
        + "patterns=" + patterns
        + "}";
  }

  /**
   * Construct a new immutable {@code OPDSAuthenticationPatternMapped} instance.
   * @param patterns The value for the {@code patterns} attribute
   * @return An immutable OPDSAuthenticationPatternMapped instance
   */
  public static OPDSAuthenticationPatternMapped of(List<OPDSMatchingAuthentication> patterns) {
    return of((Iterable<? extends OPDSMatchingAuthentication>) patterns);
  }

  /**
   * Construct a new immutable {@code OPDSAuthenticationPatternMapped} instance.
   * @param patterns The value for the {@code patterns} attribute
   * @return An immutable OPDSAuthenticationPatternMapped instance
   */
  public static OPDSAuthenticationPatternMapped of(Iterable<? extends OPDSMatchingAuthentication> patterns) {
    return new OPDSAuthenticationPatternMapped(patterns);
  }

  /**
   * Creates a builder for {@link OPDSAuthenticationPatternMapped OPDSAuthenticationPatternMapped}.
   * <pre>
   * OPDSAuthenticationPatternMapped.builder()
   *    .addPatterns|addAllPatterns(OPDSMatchingAuthentication) // {@link OPDSAuthenticationPatternMappedType#patterns() patterns} elements
   *    .build();
   * </pre>
   * @return A new OPDSAuthenticationPatternMapped builder
   */
  public static OPDSAuthenticationPatternMapped.Builder builder() {
    return new OPDSAuthenticationPatternMapped.Builder();
  }

  /**
   * Builds instances of type {@link OPDSAuthenticationPatternMapped OPDSAuthenticationPatternMapped}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OPDSAuthenticationPatternMappedType", generator = "Immutables")
  public static final class Builder {
    private List<OPDSMatchingAuthentication> patterns = new ArrayList<OPDSMatchingAuthentication>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OPDSAuthenticationPatternMappedType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OPDSAuthenticationPatternMappedType instance) {
      Objects.requireNonNull(instance, "instance");
      addAllPatterns(instance.patterns());
      return this;
    }

    /**
     * Adds one element to {@link OPDSAuthenticationPatternMappedType#patterns() patterns} list.
     * @param element A patterns element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addPatterns(OPDSMatchingAuthentication element) {
      this.patterns.add(Objects.requireNonNull(element, "patterns element"));
      return this;
    }

    /**
     * Adds elements to {@link OPDSAuthenticationPatternMappedType#patterns() patterns} list.
     * @param elements An array of patterns elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addPatterns(OPDSMatchingAuthentication... elements) {
      for (OPDSMatchingAuthentication element : elements) {
        this.patterns.add(Objects.requireNonNull(element, "patterns element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link OPDSAuthenticationPatternMappedType#patterns() patterns} list.
     * @param elements An iterable of patterns elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPatterns(Iterable<? extends OPDSMatchingAuthentication> elements) {
      this.patterns.clear();
      return addAllPatterns(elements);
    }

    /**
     * Adds elements to {@link OPDSAuthenticationPatternMappedType#patterns() patterns} list.
     * @param elements An iterable of patterns elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPatterns(Iterable<? extends OPDSMatchingAuthentication> elements) {
      for (OPDSMatchingAuthentication element : elements) {
        this.patterns.add(Objects.requireNonNull(element, "patterns element"));
      }
      return this;
    }

    /**
     * Builds a new {@link OPDSAuthenticationPatternMapped OPDSAuthenticationPatternMapped}.
     * @return An immutable instance of OPDSAuthenticationPatternMapped
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public OPDSAuthenticationPatternMapped build() {
      return new OPDSAuthenticationPatternMapped(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
