package one.lfa.opdsget.api;

import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.immutables.value.Generated;

/**
 * Configuration values for the OPDS retriever.
 */
@Generated(from = "OPDSGetConfigurationType", generator = "Immutables")
@SuppressWarnings({"all"})
public final class OPDSGetConfiguration implements OPDSGetConfigurationType {
  private final Path output;
  private final Path outputArchive;
  private final URI remoteURI;
  private final OPDSURIRewriterType uriRewriter;
  private final Function<URI, Optional<OPDSAuthenticationType>> authenticationSupplier;
  private final Set<OPDSGetKind> fetchedKinds;
  private final OPDSSquashConfiguration squash;
  private final Double scaleImages;
  private final URI outputManifestBaseURI;
  private final UUID outputManifestID;
  private final String outputManifestTitle;

  @SuppressWarnings("unchecked") // safe covariant cast
  private OPDSGetConfiguration(
      Path output,
      Optional<? extends Path> outputArchive,
      URI remoteURI,
      OPDSURIRewriterType uriRewriter,
      Function<URI, Optional<OPDSAuthenticationType>> authenticationSupplier,
      Iterable<OPDSGetKind> fetchedKinds,
      Optional<? extends OPDSSquashConfiguration> squash) {
    this.output = Objects.requireNonNull(output, "output");
    this.outputArchive = outputArchive.orElse(null);
    this.remoteURI = Objects.requireNonNull(remoteURI, "remoteURI");
    initShim.setUriRewriter(Objects.requireNonNull(uriRewriter, "uriRewriter"));
    initShim.setAuthenticationSupplier(Objects.requireNonNull(authenticationSupplier, "authenticationSupplier"));
    initShim.setFetchedKinds(createUnmodifiableEnumSet(fetchedKinds));
    this.squash = squash.orElse(null);
    this.scaleImages = null;
    this.outputManifestBaseURI = null;
    this.uriRewriter = initShim.uriRewriter();
    this.authenticationSupplier = initShim.authenticationSupplier();
    this.fetchedKinds = initShim.fetchedKinds();
    this.outputManifestID = initShim.outputManifestID();
    this.outputManifestTitle = initShim.outputManifestTitle();
    this.initShim = null;
  }

  private OPDSGetConfiguration(OPDSGetConfiguration.Builder builder) {
    this.output = builder.output;
    this.outputArchive = builder.outputArchive;
    this.remoteURI = builder.remoteURI;
    this.squash = builder.squash;
    this.scaleImages = builder.scaleImages;
    this.outputManifestBaseURI = builder.outputManifestBaseURI;
    if (builder.uriRewriter != null) {
      initShim.setUriRewriter(builder.uriRewriter);
    }
    if (builder.authenticationSupplier != null) {
      initShim.setAuthenticationSupplier(builder.authenticationSupplier);
    }
    if (builder.fetchedKindsIsSet()) {
      initShim.setFetchedKinds(createUnmodifiableEnumSet(builder.fetchedKinds));
    }
    if (builder.outputManifestID != null) {
      initShim.setOutputManifestID(builder.outputManifestID);
    }
    if (builder.outputManifestTitle != null) {
      initShim.setOutputManifestTitle(builder.outputManifestTitle);
    }
    this.uriRewriter = initShim.uriRewriter();
    this.authenticationSupplier = initShim.authenticationSupplier();
    this.fetchedKinds = initShim.fetchedKinds();
    this.outputManifestID = initShim.outputManifestID();
    this.outputManifestTitle = initShim.outputManifestTitle();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "OPDSGetConfigurationType", generator = "Immutables")
  private final class InitShim {
    private byte uriRewriterBuildStage = STAGE_UNINITIALIZED;
    private OPDSURIRewriterType uriRewriter;

    OPDSURIRewriterType uriRewriter() {
      if (uriRewriterBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (uriRewriterBuildStage == STAGE_UNINITIALIZED) {
        uriRewriterBuildStage = STAGE_INITIALIZING;
        this.uriRewriter = Objects.requireNonNull(uriRewriterInitialize(), "uriRewriter");
        uriRewriterBuildStage = STAGE_INITIALIZED;
      }
      return this.uriRewriter;
    }

    void setUriRewriter(OPDSURIRewriterType uriRewriter) {
      this.uriRewriter = uriRewriter;
      uriRewriterBuildStage = STAGE_INITIALIZED;
    }

    private byte authenticationSupplierBuildStage = STAGE_UNINITIALIZED;
    private Function<URI, Optional<OPDSAuthenticationType>> authenticationSupplier;

    Function<URI, Optional<OPDSAuthenticationType>> authenticationSupplier() {
      if (authenticationSupplierBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (authenticationSupplierBuildStage == STAGE_UNINITIALIZED) {
        authenticationSupplierBuildStage = STAGE_INITIALIZING;
        this.authenticationSupplier = Objects.requireNonNull(authenticationSupplierInitialize(), "authenticationSupplier");
        authenticationSupplierBuildStage = STAGE_INITIALIZED;
      }
      return this.authenticationSupplier;
    }

    void setAuthenticationSupplier(Function<URI, Optional<OPDSAuthenticationType>> authenticationSupplier) {
      this.authenticationSupplier = authenticationSupplier;
      authenticationSupplierBuildStage = STAGE_INITIALIZED;
    }

    private byte fetchedKindsBuildStage = STAGE_UNINITIALIZED;
    private Set<OPDSGetKind> fetchedKinds;

    Set<OPDSGetKind> fetchedKinds() {
      if (fetchedKindsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (fetchedKindsBuildStage == STAGE_UNINITIALIZED) {
        fetchedKindsBuildStage = STAGE_INITIALIZING;
        this.fetchedKinds = createUnmodifiableEnumSet(fetchedKindsInitialize());
        fetchedKindsBuildStage = STAGE_INITIALIZED;
      }
      return this.fetchedKinds;
    }

    void setFetchedKinds(Set<OPDSGetKind> fetchedKinds) {
      this.fetchedKinds = fetchedKinds;
      fetchedKindsBuildStage = STAGE_INITIALIZED;
    }

    private byte outputManifestIDBuildStage = STAGE_UNINITIALIZED;
    private UUID outputManifestID;

    UUID outputManifestID() {
      if (outputManifestIDBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (outputManifestIDBuildStage == STAGE_UNINITIALIZED) {
        outputManifestIDBuildStage = STAGE_INITIALIZING;
        this.outputManifestID = Objects.requireNonNull(outputManifestIDInitialize(), "outputManifestID");
        outputManifestIDBuildStage = STAGE_INITIALIZED;
      }
      return this.outputManifestID;
    }

    void setOutputManifestID(UUID outputManifestID) {
      this.outputManifestID = outputManifestID;
      outputManifestIDBuildStage = STAGE_INITIALIZED;
    }

    private byte outputManifestTitleBuildStage = STAGE_UNINITIALIZED;
    private String outputManifestTitle;

    String outputManifestTitle() {
      if (outputManifestTitleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (outputManifestTitleBuildStage == STAGE_UNINITIALIZED) {
        outputManifestTitleBuildStage = STAGE_INITIALIZING;
        this.outputManifestTitle = Objects.requireNonNull(outputManifestTitleInitialize(), "outputManifestTitle");
        outputManifestTitleBuildStage = STAGE_INITIALIZED;
      }
      return this.outputManifestTitle;
    }

    void setOutputManifestTitle(String outputManifestTitle) {
      this.outputManifestTitle = outputManifestTitle;
      outputManifestTitleBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (uriRewriterBuildStage == STAGE_INITIALIZING) attributes.add("uriRewriter");
      if (authenticationSupplierBuildStage == STAGE_INITIALIZING) attributes.add("authenticationSupplier");
      if (fetchedKindsBuildStage == STAGE_INITIALIZING) attributes.add("fetchedKinds");
      if (outputManifestIDBuildStage == STAGE_INITIALIZING) attributes.add("outputManifestID");
      if (outputManifestTitleBuildStage == STAGE_INITIALIZING) attributes.add("outputManifestTitle");
      return "Cannot build OPDSGetConfiguration, attribute initializers form cycle " + attributes;
    }
  }

  private OPDSURIRewriterType uriRewriterInitialize() {
    return OPDSGetConfigurationType.super.uriRewriter();
  }

  private Function<URI, Optional<OPDSAuthenticationType>> authenticationSupplierInitialize() {
    return OPDSGetConfigurationType.super.authenticationSupplier();
  }

  private Set<OPDSGetKind> fetchedKindsInitialize() {
    return OPDSGetConfigurationType.super.fetchedKinds();
  }

  private UUID outputManifestIDInitialize() {
    return OPDSGetConfigurationType.super.outputManifestID();
  }

  private String outputManifestTitleInitialize() {
    return OPDSGetConfigurationType.super.outputManifestTitle();
  }

  /**
   * @return The output directory
   */
  @Override
  public Path output() {
    return output;
  }

  /**
   * @return The zip file that will be created containing the contents of the output directory
   */
  @Override
  public Optional<Path> outputArchive() {
    return Optional.ofNullable(outputArchive);
  }

  /**
   * @return The starting URI for the OPDS feed
   */
  @Override
  public URI remoteURI() {
    return remoteURI;
  }

  /**
   * A function used to rewrite URIs. The function will be passed the original URI and the path to
   * the local file. The function must return a URI that will be used to refer to the local file.
   * This is used for, for example, prefixing rewritten URIs with {@code file:///android_asset/} for
   * producing feeds bundled into Android applications.
   * @return A URI rewriter
   */
  @Override
  public OPDSURIRewriterType uriRewriter() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.uriRewriter()
        : this.uriRewriter;
  }

  /**
   * A function that returns authentication information for URIs, if required.
   * @return The authentication data, if any is required
   */
  @Override
  public Function<URI, Optional<OPDSAuthenticationType>> authenticationSupplier() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.authenticationSupplier()
        : this.authenticationSupplier;
  }

  /**
   * @return The set of feed content kinds that will be fetched
   */
  @Override
  public Set<OPDSGetKind> fetchedKinds() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.fetchedKinds()
        : this.fetchedKinds;
  }

  /**
   * @return The squash configuration if EPUB squashing should be performed
   */
  @Override
  public Optional<OPDSSquashConfiguration> squash() {
    return Optional.ofNullable(squash);
  }

  /**
   * @return The amount by which to scale cover images
   */
  @Override
  public OptionalDouble scaleImages() {
    return scaleImages != null
        ? OptionalDouble.of(scaleImages)
        : OptionalDouble.empty();
  }

  /**
   * @return The base URI that will be placed into manifest files
   */
  @Override
  public Optional<URI> outputManifestBaseURI() {
    return Optional.ofNullable(outputManifestBaseURI);
  }

  /**
   * @return The UUID that will be used as the unique ID of the generated manifest file
   */
  @Override
  public UUID outputManifestID() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.outputManifestID()
        : this.outputManifestID;
  }

  /**
   * @return The text that will be used as the title in the generated manifest file
   */
  @Override
  public String outputManifestTitle() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.outputManifestTitle()
        : this.outputManifestTitle;
  }

  /**
   * This instance is equal to all instances of {@code OPDSGetConfiguration} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof OPDSGetConfiguration
        && equalTo((OPDSGetConfiguration) another);
  }

  private boolean equalTo(OPDSGetConfiguration another) {
    return output.equals(another.output)
        && Objects.equals(outputArchive, another.outputArchive)
        && remoteURI.equals(another.remoteURI)
        && uriRewriter.equals(another.uriRewriter)
        && authenticationSupplier.equals(another.authenticationSupplier)
        && fetchedKinds.equals(another.fetchedKinds)
        && Objects.equals(squash, another.squash)
        && Objects.equals(scaleImages, another.scaleImages)
        && Objects.equals(outputManifestBaseURI, another.outputManifestBaseURI)
        && outputManifestID.equals(another.outputManifestID)
        && outputManifestTitle.equals(another.outputManifestTitle);
  }

  /**
   * Computes a hash code from attributes: {@code output}, {@code outputArchive}, {@code remoteURI}, {@code uriRewriter}, {@code authenticationSupplier}, {@code fetchedKinds}, {@code squash}, {@code scaleImages}, {@code outputManifestBaseURI}, {@code outputManifestID}, {@code outputManifestTitle}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + output.hashCode();
    h += (h << 5) + Objects.hashCode(outputArchive);
    h += (h << 5) + remoteURI.hashCode();
    h += (h << 5) + uriRewriter.hashCode();
    h += (h << 5) + authenticationSupplier.hashCode();
    h += (h << 5) + fetchedKinds.hashCode();
    h += (h << 5) + Objects.hashCode(squash);
    h += (h << 5) + Objects.hashCode(scaleImages);
    h += (h << 5) + Objects.hashCode(outputManifestBaseURI);
    h += (h << 5) + outputManifestID.hashCode();
    h += (h << 5) + outputManifestTitle.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code OPDSGetConfiguration} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("OPDSGetConfiguration{");
    builder.append("output=").append(output);
    if (outputArchive != null) {
      builder.append(", ");
      builder.append("outputArchive=").append(outputArchive);
    }
    builder.append(", ");
    builder.append("remoteURI=").append(remoteURI);
    builder.append(", ");
    builder.append("uriRewriter=").append(uriRewriter);
    builder.append(", ");
    builder.append("authenticationSupplier=").append(authenticationSupplier);
    builder.append(", ");
    builder.append("fetchedKinds=").append(fetchedKinds);
    if (squash != null) {
      builder.append(", ");
      builder.append("squash=").append(squash);
    }
    if (scaleImages != null) {
      builder.append(", ");
      builder.append("scaleImages=").append(scaleImages);
    }
    if (outputManifestBaseURI != null) {
      builder.append(", ");
      builder.append("outputManifestBaseURI=").append(outputManifestBaseURI);
    }
    builder.append(", ");
    builder.append("outputManifestID=").append(outputManifestID);
    builder.append(", ");
    builder.append("outputManifestTitle=").append(outputManifestTitle);
    return builder.append("}").toString();
  }

  /**
   * Construct a new immutable {@code OPDSGetConfiguration} instance.
   * @param output The value for the {@code output} attribute
   * @param outputArchive The value for the {@code outputArchive} attribute
   * @param remoteURI The value for the {@code remoteURI} attribute
   * @param uriRewriter The value for the {@code uriRewriter} attribute
   * @param authenticationSupplier The value for the {@code authenticationSupplier} attribute
   * @param fetchedKinds The value for the {@code fetchedKinds} attribute
   * @param squash The value for the {@code squash} attribute
   * @return An immutable OPDSGetConfiguration instance
   */
  public static OPDSGetConfiguration of(Path output, Optional<Path> outputArchive, URI remoteURI, OPDSURIRewriterType uriRewriter, Function<URI, Optional<OPDSAuthenticationType>> authenticationSupplier, Set<OPDSGetKind> fetchedKinds, Optional<OPDSSquashConfiguration> squash) {
    return of(output, outputArchive, remoteURI, uriRewriter, authenticationSupplier, (Iterable<OPDSGetKind>) fetchedKinds, squash);
  }

  /**
   * Construct a new immutable {@code OPDSGetConfiguration} instance.
   * @param output The value for the {@code output} attribute
   * @param outputArchive The value for the {@code outputArchive} attribute
   * @param remoteURI The value for the {@code remoteURI} attribute
   * @param uriRewriter The value for the {@code uriRewriter} attribute
   * @param authenticationSupplier The value for the {@code authenticationSupplier} attribute
   * @param fetchedKinds The value for the {@code fetchedKinds} attribute
   * @param squash The value for the {@code squash} attribute
   * @return An immutable OPDSGetConfiguration instance
   */
  public static OPDSGetConfiguration of(Path output, Optional<? extends Path> outputArchive, URI remoteURI, OPDSURIRewriterType uriRewriter, Function<URI, Optional<OPDSAuthenticationType>> authenticationSupplier, Iterable<OPDSGetKind> fetchedKinds, Optional<? extends OPDSSquashConfiguration> squash) {
    return validate(new OPDSGetConfiguration(output, outputArchive, remoteURI, uriRewriter, authenticationSupplier, fetchedKinds, squash));
  }

  private static OPDSGetConfiguration validate(OPDSGetConfiguration instance) {
    instance.checkPreconditions();
    return instance;
  }

  /**
   * Creates a builder for {@link OPDSGetConfiguration OPDSGetConfiguration}.
   * <pre>
   * OPDSGetConfiguration.builder()
   *    .setOutput(java.nio.file.Path) // required {@link OPDSGetConfigurationType#output() output}
   *    .setOutputArchive(java.nio.file.Path) // optional {@link OPDSGetConfigurationType#outputArchive() outputArchive}
   *    .setRemoteURI(java.net.URI) // required {@link OPDSGetConfigurationType#remoteURI() remoteURI}
   *    .setUriRewriter(one.lfa.opdsget.api.OPDSURIRewriterType) // optional {@link OPDSGetConfigurationType#uriRewriter() uriRewriter}
   *    .setAuthenticationSupplier(function.Function&amp;lt;java.net.URI, Optional&amp;lt;one.lfa.opdsget.api.OPDSAuthenticationType&amp;gt;&amp;gt;) // optional {@link OPDSGetConfigurationType#authenticationSupplier() authenticationSupplier}
   *    .addFetchedKinds|addAllFetchedKinds(one.lfa.opdsget.api.OPDSGetKind) // {@link OPDSGetConfigurationType#fetchedKinds() fetchedKinds} elements
   *    .setSquash(OPDSSquashConfiguration) // optional {@link OPDSGetConfigurationType#squash() squash}
   *    .setScaleImages(double) // optional {@link OPDSGetConfigurationType#scaleImages() scaleImages}
   *    .setOutputManifestBaseURI(java.net.URI) // optional {@link OPDSGetConfigurationType#outputManifestBaseURI() outputManifestBaseURI}
   *    .setOutputManifestID(UUID) // optional {@link OPDSGetConfigurationType#outputManifestID() outputManifestID}
   *    .setOutputManifestTitle(String) // optional {@link OPDSGetConfigurationType#outputManifestTitle() outputManifestTitle}
   *    .build();
   * </pre>
   * @return A new OPDSGetConfiguration builder
   */
  public static OPDSGetConfiguration.Builder builder() {
    return new OPDSGetConfiguration.Builder();
  }

  /**
   * Builds instances of type {@link OPDSGetConfiguration OPDSGetConfiguration}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OPDSGetConfigurationType", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_OUTPUT = 0x1L;
    private static final long INIT_BIT_REMOTE_U_R_I = 0x2L;
    private static final long OPT_BIT_FETCHED_KINDS = 0x1L;
    private long initBits = 0x3L;
    private long optBits;

    private Path output;
    private Path outputArchive;
    private URI remoteURI;
    private OPDSURIRewriterType uriRewriter;
    private Function<URI, Optional<OPDSAuthenticationType>> authenticationSupplier;
    private EnumSet<OPDSGetKind> fetchedKinds = EnumSet.noneOf(OPDSGetKind.class);
    private OPDSSquashConfiguration squash;
    private Double scaleImages;
    private URI outputManifestBaseURI;
    private UUID outputManifestID;
    private String outputManifestTitle;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OPDSGetConfigurationType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OPDSGetConfigurationType instance) {
      Objects.requireNonNull(instance, "instance");
      setOutput(instance.output());
      Optional<Path> outputArchiveOptional = instance.outputArchive();
      if (outputArchiveOptional.isPresent()) {
        setOutputArchive(outputArchiveOptional);
      }
      setRemoteURI(instance.remoteURI());
      setUriRewriter(instance.uriRewriter());
      setAuthenticationSupplier(instance.authenticationSupplier());
      addAllFetchedKinds(instance.fetchedKinds());
      Optional<OPDSSquashConfiguration> squashOptional = instance.squash();
      if (squashOptional.isPresent()) {
        setSquash(squashOptional);
      }
      OptionalDouble scaleImagesOptional = instance.scaleImages();
      if (scaleImagesOptional.isPresent()) {
        setScaleImages(scaleImagesOptional);
      }
      Optional<URI> outputManifestBaseURIOptional = instance.outputManifestBaseURI();
      if (outputManifestBaseURIOptional.isPresent()) {
        setOutputManifestBaseURI(outputManifestBaseURIOptional);
      }
      setOutputManifestID(instance.outputManifestID());
      setOutputManifestTitle(instance.outputManifestTitle());
      return this;
    }

    /**
     * Initializes the value for the {@link OPDSGetConfigurationType#output() output} attribute.
     * @param output The value for output 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOutput(Path output) {
      this.output = Objects.requireNonNull(output, "output");
      initBits &= ~INIT_BIT_OUTPUT;
      return this;
    }

    /**
     * Initializes the optional value {@link OPDSGetConfigurationType#outputArchive() outputArchive} to outputArchive.
     * @param outputArchive The value for outputArchive
     * @return {@code this} builder for chained invocation
     */
    public final Builder setOutputArchive(Path outputArchive) {
      this.outputArchive = Objects.requireNonNull(outputArchive, "outputArchive");
      return this;
    }

    /**
     * Initializes the optional value {@link OPDSGetConfigurationType#outputArchive() outputArchive} to outputArchive.
     * @param outputArchive The value for outputArchive
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOutputArchive(Optional<? extends Path> outputArchive) {
      this.outputArchive = outputArchive.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link OPDSGetConfigurationType#remoteURI() remoteURI} attribute.
     * @param remoteURI The value for remoteURI 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setRemoteURI(URI remoteURI) {
      this.remoteURI = Objects.requireNonNull(remoteURI, "remoteURI");
      initBits &= ~INIT_BIT_REMOTE_U_R_I;
      return this;
    }

    /**
     * Initializes the value for the {@link OPDSGetConfigurationType#uriRewriter() uriRewriter} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link OPDSGetConfigurationType#uriRewriter() uriRewriter}.</em>
     * @param uriRewriter The value for uriRewriter 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUriRewriter(OPDSURIRewriterType uriRewriter) {
      this.uriRewriter = Objects.requireNonNull(uriRewriter, "uriRewriter");
      return this;
    }

    /**
     * Initializes the value for the {@link OPDSGetConfigurationType#authenticationSupplier() authenticationSupplier} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link OPDSGetConfigurationType#authenticationSupplier() authenticationSupplier}.</em>
     * @param authenticationSupplier The value for authenticationSupplier 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setAuthenticationSupplier(Function<URI, Optional<OPDSAuthenticationType>> authenticationSupplier) {
      this.authenticationSupplier = Objects.requireNonNull(authenticationSupplier, "authenticationSupplier");
      return this;
    }

    /**
     * Adds one element to {@link OPDSGetConfigurationType#fetchedKinds() fetchedKinds} set.
     * @param element A fetchedKinds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addFetchedKinds(OPDSGetKind element) {
      this.fetchedKinds.add(Objects.requireNonNull(element, "fetchedKinds element"));
      optBits |= OPT_BIT_FETCHED_KINDS;
      return this;
    }

    /**
     * Adds elements to {@link OPDSGetConfigurationType#fetchedKinds() fetchedKinds} set.
     * @param elements An array of fetchedKinds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addFetchedKinds(OPDSGetKind... elements) {
      for (OPDSGetKind element : elements) {
        this.fetchedKinds.add(Objects.requireNonNull(element, "fetchedKinds element"));
      }
      optBits |= OPT_BIT_FETCHED_KINDS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link OPDSGetConfigurationType#fetchedKinds() fetchedKinds} set.
     * @param elements An iterable of fetchedKinds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setFetchedKinds(Iterable<OPDSGetKind> elements) {
      this.fetchedKinds.clear();
      return addAllFetchedKinds(elements);
    }

    /**
     * Adds elements to {@link OPDSGetConfigurationType#fetchedKinds() fetchedKinds} set.
     * @param elements An iterable of fetchedKinds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllFetchedKinds(Iterable<OPDSGetKind> elements) {
      for (OPDSGetKind element : elements) {
        this.fetchedKinds.add(Objects.requireNonNull(element, "fetchedKinds element"));
      }
      optBits |= OPT_BIT_FETCHED_KINDS;
      return this;
    }

    /**
     * Initializes the optional value {@link OPDSGetConfigurationType#squash() squash} to squash.
     * @param squash The value for squash
     * @return {@code this} builder for chained invocation
     */
    public final Builder setSquash(OPDSSquashConfiguration squash) {
      this.squash = Objects.requireNonNull(squash, "squash");
      return this;
    }

    /**
     * Initializes the optional value {@link OPDSGetConfigurationType#squash() squash} to squash.
     * @param squash The value for squash
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setSquash(Optional<? extends OPDSSquashConfiguration> squash) {
      this.squash = squash.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link OPDSGetConfigurationType#scaleImages() scaleImages} to scaleImages.
     * @param scaleImages The value for scaleImages
     * @return {@code this} builder for chained invocation
     */
    public final Builder setScaleImages(double scaleImages) {
      this.scaleImages = scaleImages;
      return this;
    }

    /**
     * Initializes the optional value {@link OPDSGetConfigurationType#scaleImages() scaleImages} to scaleImages.
     * @param scaleImages The value for scaleImages
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setScaleImages(OptionalDouble scaleImages) {
      this.scaleImages = scaleImages.isPresent() ? scaleImages.getAsDouble() : null;
      return this;
    }

    /**
     * Initializes the optional value {@link OPDSGetConfigurationType#outputManifestBaseURI() outputManifestBaseURI} to outputManifestBaseURI.
     * @param outputManifestBaseURI The value for outputManifestBaseURI
     * @return {@code this} builder for chained invocation
     */
    public final Builder setOutputManifestBaseURI(URI outputManifestBaseURI) {
      this.outputManifestBaseURI = Objects.requireNonNull(outputManifestBaseURI, "outputManifestBaseURI");
      return this;
    }

    /**
     * Initializes the optional value {@link OPDSGetConfigurationType#outputManifestBaseURI() outputManifestBaseURI} to outputManifestBaseURI.
     * @param outputManifestBaseURI The value for outputManifestBaseURI
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOutputManifestBaseURI(Optional<? extends URI> outputManifestBaseURI) {
      this.outputManifestBaseURI = outputManifestBaseURI.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link OPDSGetConfigurationType#outputManifestID() outputManifestID} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link OPDSGetConfigurationType#outputManifestID() outputManifestID}.</em>
     * @param outputManifestID The value for outputManifestID 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOutputManifestID(UUID outputManifestID) {
      this.outputManifestID = Objects.requireNonNull(outputManifestID, "outputManifestID");
      return this;
    }

    /**
     * Initializes the value for the {@link OPDSGetConfigurationType#outputManifestTitle() outputManifestTitle} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link OPDSGetConfigurationType#outputManifestTitle() outputManifestTitle}.</em>
     * @param outputManifestTitle The value for outputManifestTitle 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOutputManifestTitle(String outputManifestTitle) {
      this.outputManifestTitle = Objects.requireNonNull(outputManifestTitle, "outputManifestTitle");
      return this;
    }

    /**
     * Builds a new {@link OPDSGetConfiguration OPDSGetConfiguration}.
     * @return An immutable instance of OPDSGetConfiguration
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public OPDSGetConfiguration build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return OPDSGetConfiguration.validate(new OPDSGetConfiguration(this));
    }

    private boolean fetchedKindsIsSet() {
      return (optBits & OPT_BIT_FETCHED_KINDS) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_OUTPUT) != 0) attributes.add("output");
      if ((initBits & INIT_BIT_REMOTE_U_R_I) != 0) attributes.add("remoteURI");
      return "Cannot build OPDSGetConfiguration, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  @SuppressWarnings("unchecked")
  private static <T extends Enum<T>> Set<T> createUnmodifiableEnumSet(Iterable<T> iterable) {
    if (iterable instanceof EnumSet<?>) {
      return Collections.unmodifiableSet(EnumSet.copyOf((EnumSet<T>) iterable));
    }
    List<T> list = createSafeList(iterable, true, false);
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default: return Collections.unmodifiableSet(EnumSet.copyOf(list));
    }
  }
}
