package one.lfa.opdsget.api;

import com.io7m.jlexing.core.LexicalPosition;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

/**
 * The type of parse errors.
 */
@Generated(from = "OPDSManifestParseErrorType", generator = "Immutables")
@SuppressWarnings({"all"})
public final class OPDSManifestParseError implements OPDSManifestParseErrorType {
  private final LexicalPosition<URI> lexical;
  private final OPDSManifestParseErrorType.Severity severity;
  private final String message;
  private final Exception exception;

  private OPDSManifestParseError(OPDSManifestParseError.Builder builder) {
    this.lexical = builder.lexical;
    this.severity = builder.severity;
    this.message = builder.message;
    this.exception = builder.exception;
  }

  /**
   * @return The value of the {@code lexical} attribute
   */
  @Override
  public LexicalPosition<URI> lexical() {
    return lexical;
  }

  /**
   * @return The error severity
   */
  @Override
  public OPDSManifestParseErrorType.Severity severity() {
    return severity;
  }

  /**
   * @return The error message
   */
  @Override
  public String message() {
    return message;
  }

  /**
   * @return The exception raised, if any
   */
  @Override
  public Optional<Exception> exception() {
    return Optional.ofNullable(exception);
  }

  /**
   * This instance is equal to all instances of {@code OPDSManifestParseError} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof OPDSManifestParseError
        && equalTo((OPDSManifestParseError) another);
  }

  private boolean equalTo(OPDSManifestParseError another) {
    return lexical.equals(another.lexical)
        && severity.equals(another.severity)
        && message.equals(another.message)
        && Objects.equals(exception, another.exception);
  }

  /**
   * Computes a hash code from attributes: {@code lexical}, {@code severity}, {@code message}, {@code exception}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + lexical.hashCode();
    h += (h << 5) + severity.hashCode();
    h += (h << 5) + message.hashCode();
    h += (h << 5) + Objects.hashCode(exception);
    return h;
  }

  /**
   * Prints the immutable value {@code OPDSManifestParseError} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("OPDSManifestParseError{");
    builder.append("lexical=").append(lexical);
    builder.append(", ");
    builder.append("severity=").append(severity);
    builder.append(", ");
    builder.append("message=").append(message);
    if (exception != null) {
      builder.append(", ");
      builder.append("exception=").append(exception);
    }
    return builder.append("}").toString();
  }

  /**
   * Creates a builder for {@link OPDSManifestParseError OPDSManifestParseError}.
   * <pre>
   * OPDSManifestParseError.builder()
   *    .setLexical(com.io7m.jlexing.core.LexicalPosition&amp;lt;java.net.URI&amp;gt;) // required {@link OPDSManifestParseErrorType#lexical() lexical}
   *    .setSeverity(one.lfa.opdsget.api.OPDSManifestParseErrorType.Severity) // required {@link OPDSManifestParseErrorType#severity() severity}
   *    .setMessage(String) // required {@link OPDSManifestParseErrorType#message() message}
   *    .setException(Exception) // optional {@link OPDSManifestParseErrorType#exception() exception}
   *    .build();
   * </pre>
   * @return A new OPDSManifestParseError builder
   */
  public static OPDSManifestParseError.Builder builder() {
    return new OPDSManifestParseError.Builder();
  }

  /**
   * Builds instances of type {@link OPDSManifestParseError OPDSManifestParseError}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OPDSManifestParseErrorType", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_LEXICAL = 0x1L;
    private static final long INIT_BIT_SEVERITY = 0x2L;
    private static final long INIT_BIT_MESSAGE = 0x4L;
    private long initBits = 0x7L;

    private LexicalPosition<URI> lexical;
    private OPDSManifestParseErrorType.Severity severity;
    private String message;
    private Exception exception;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OPDSManifestParseErrorType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OPDSManifestParseErrorType instance) {
      Objects.requireNonNull(instance, "instance");
      setLexical(instance.lexical());
      setSeverity(instance.severity());
      setMessage(instance.message());
      Optional<Exception> exceptionOptional = instance.exception();
      if (exceptionOptional.isPresent()) {
        setException(exceptionOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link OPDSManifestParseErrorType#lexical() lexical} attribute.
     * @param lexical The value for lexical 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setLexical(LexicalPosition<URI> lexical) {
      this.lexical = Objects.requireNonNull(lexical, "lexical");
      initBits &= ~INIT_BIT_LEXICAL;
      return this;
    }

    /**
     * Initializes the value for the {@link OPDSManifestParseErrorType#severity() severity} attribute.
     * @param severity The value for severity 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setSeverity(OPDSManifestParseErrorType.Severity severity) {
      this.severity = Objects.requireNonNull(severity, "severity");
      initBits &= ~INIT_BIT_SEVERITY;
      return this;
    }

    /**
     * Initializes the value for the {@link OPDSManifestParseErrorType#message() message} attribute.
     * @param message The value for message 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMessage(String message) {
      this.message = Objects.requireNonNull(message, "message");
      initBits &= ~INIT_BIT_MESSAGE;
      return this;
    }

    /**
     * Initializes the optional value {@link OPDSManifestParseErrorType#exception() exception} to exception.
     * @param exception The value for exception
     * @return {@code this} builder for chained invocation
     */
    public final Builder setException(Exception exception) {
      this.exception = Objects.requireNonNull(exception, "exception");
      return this;
    }

    /**
     * Initializes the optional value {@link OPDSManifestParseErrorType#exception() exception} to exception.
     * @param exception The value for exception
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setException(Optional<? extends Exception> exception) {
      this.exception = exception.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link OPDSManifestParseError OPDSManifestParseError}.
     * @return An immutable instance of OPDSManifestParseError
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public OPDSManifestParseError build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new OPDSManifestParseError(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_LEXICAL) != 0) attributes.add("lexical");
      if ((initBits & INIT_BIT_SEVERITY) != 0) attributes.add("severity");
      if ((initBits & INIT_BIT_MESSAGE) != 0) attributes.add("message");
      return "Cannot build OPDSManifestParseError, some of required attributes are not set " + attributes;
    }
  }
}
