/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.blackthorne.api;

import com.io7m.blackthorne.api.BTElementHandlerConstructorType;
import com.io7m.blackthorne.api.BTElementHandlerType;
import com.io7m.blackthorne.api.BTElementParsingContextType;
import com.io7m.blackthorne.api.BTIgnoreUnrecognizedElements;
import com.io7m.blackthorne.api.BTQualifiedName;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class BTFunctorHandler<A, B, C>
implements BTElementHandlerType<A, C> {
    private final BTElementHandlerType<A, B> handler;
    private final Function<B, C> function;

    public BTFunctorHandler(BTElementHandlerType<A, B> inHandler, Function<B, C> inFunction) {
        this.handler = Objects.requireNonNull(inHandler, "handler");
        this.function = Objects.requireNonNull(inFunction, "function");
    }

    @Override
    public Map<BTQualifiedName, BTElementHandlerConstructorType<?, ? extends A>> onChildHandlersRequested(BTElementParsingContextType context) {
        return this.handler.onChildHandlersRequested(context);
    }

    @Override
    public String name() {
        return String.format("[map %s]", this.handler.name());
    }

    @Override
    public BTIgnoreUnrecognizedElements onShouldIgnoreUnrecognizedElements(BTElementParsingContextType context) {
        return this.handler.onShouldIgnoreUnrecognizedElements(context);
    }

    @Override
    public void onElementStart(BTElementParsingContextType context, Attributes attributes) throws SAXException {
        this.handler.onElementStart(context, attributes);
    }

    @Override
    public void onChildValueProduced(BTElementParsingContextType context, A result) throws SAXException {
        this.handler.onChildValueProduced(context, result);
    }

    @Override
    public void onCharacters(BTElementParsingContextType context, char[] data, int offset, int length) throws SAXException {
        this.handler.onCharacters(context, data, offset, length);
    }

    @Override
    public C onElementFinished(BTElementParsingContextType context) throws SAXException {
        return this.function.apply(this.handler.onElementFinished(context));
    }
}

