/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jlexing.core;

import com.io7m.jlexing.core.LexicalPosition;
import com.io7m.jlexing.core.LexicalPositionType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;

public final class LexicalPositionMutable<F>
implements LexicalPositionType<F> {
    private static final long INIT_BIT_LINE = 1L;
    private static final long INIT_BIT_COLUMN = 2L;
    private long initBits = 3L;
    private int line;
    private int column;
    private Optional<F> file = Optional.empty();

    private LexicalPositionMutable() {
    }

    public static <F> LexicalPositionMutable<F> create(int line, int column, Optional<F> file) {
        return new LexicalPositionMutable<F>().setLine(line).setColumn(column).setFile(file);
    }

    public static <F> LexicalPositionMutable<F> create() {
        return new LexicalPositionMutable<F>();
    }

    @Override
    public final int line() {
        if (!this.lineIsSet()) {
            this.checkRequiredAttributes();
        }
        return this.line;
    }

    @Override
    public final int column() {
        if (!this.columnIsSet()) {
            this.checkRequiredAttributes();
        }
        return this.column;
    }

    @Override
    public final Optional<F> file() {
        return this.file;
    }

    public LexicalPositionMutable<F> clear() {
        this.initBits = 3L;
        this.line = 0;
        this.column = 0;
        this.file = Optional.empty();
        return this;
    }

    public LexicalPositionMutable<F> from(LexicalPositionType<F> instance) {
        Objects.requireNonNull(instance, "instance");
        this.setLine(instance.line());
        this.setColumn(instance.column());
        Optional<F> fileOptional = instance.file();
        if (fileOptional.isPresent()) {
            this.setFile(fileOptional);
        }
        return this;
    }

    public LexicalPositionMutable<F> setLine(int line) {
        this.line = line;
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    public LexicalPositionMutable<F> setColumn(int column) {
        this.column = column;
        this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        return this;
    }

    public LexicalPositionMutable<F> setFile(F file) {
        this.file = Optional.of(file);
        return this;
    }

    public LexicalPositionMutable<F> setFile(Optional<F> file) {
        this.file = Objects.requireNonNull(file, "file");
        return this;
    }

    public final boolean lineIsSet() {
        return (this.initBits & 1L) == 0L;
    }

    public final boolean columnIsSet() {
        return (this.initBits & 2L) == 0L;
    }

    public final LexicalPositionMutable<F> unsetLine() {
        this.initBits |= 1L;
        this.line = 0;
        return this;
    }

    public final LexicalPositionMutable<F> unsetColumn() {
        this.initBits |= 2L;
        this.column = 0;
        return this;
    }

    public final boolean isInitialized() {
        return this.initBits == 0L;
    }

    private void checkRequiredAttributes() {
        if (!this.isInitialized()) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if (!this.lineIsSet()) {
            attributes.add("line");
        }
        if (!this.columnIsSet()) {
            attributes.add("column");
        }
        return "LexicalPosition in not initialized, some of the required attributes are not set " + attributes;
    }

    public final LexicalPosition<F> toImmutable() {
        this.checkRequiredAttributes();
        return LexicalPosition.copyOf(this);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof LexicalPositionMutable)) {
            return false;
        }
        LexicalPositionMutable other = (LexicalPositionMutable)another;
        if (!this.isInitialized() || !other.isInitialized()) {
            return false;
        }
        return this.equalTo(other);
    }

    private boolean equalTo(LexicalPositionMutable another) {
        return this.line == another.line && this.column == another.column && Objects.equals(this.file, another.file);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.line;
        h += (h << 5) + this.column;
        h += (h << 5) + this.file.hashCode();
        return h;
    }

    public String toString() {
        return "LexicalPositionMutable{line=" + (Serializable)(this.lineIsSet() ? Integer.valueOf(this.line()) : "?") + ", column=" + (Serializable)(this.columnIsSet() ? Integer.valueOf(this.column()) : "?") + ", file=" + this.file() + "}";
    }
}

