/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.util;

import com.twelvemonkeys.image.ImageUtil;
import com.twelvemonkeys.imageio.util.IIOInputStreamAdapter;
import com.twelvemonkeys.imageio.util.IIOOutputStreamAdapter;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TreeSet;
import javax.imageio.IIOParam;
import javax.imageio.ImageIO;
import javax.imageio.spi.IIOServiceProvider;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public final class IIOUtil {
    private IIOUtil() {
    }

    public static InputStream createStreamAdapter(ImageInputStream imageInputStream) {
        return new BufferedInputStream(new IIOInputStreamAdapter(imageInputStream));
    }

    public static InputStream createStreamAdapter(ImageInputStream imageInputStream, long l) {
        return new BufferedInputStream(new IIOInputStreamAdapter(imageInputStream, l));
    }

    public static OutputStream createStreamAdapter(ImageOutputStream imageOutputStream) {
        return new BufferedOutputStream(new IIOOutputStreamAdapter(imageOutputStream));
    }

    public static Image fakeSubsampling(Image image, IIOParam iIOParam) {
        if (image == null) {
            return null;
        }
        if (iIOParam != null) {
            int n = iIOParam.getSourceXSubsampling();
            int n2 = iIOParam.getSourceYSubsampling();
            if (n > 1 || n2 > 1) {
                int n3 = (ImageUtil.getWidth(image) + n - 1) / n;
                int n4 = (ImageUtil.getHeight(image) + n2 - 1) / n2;
                return image.getScaledInstance(n3, n4, 2);
            }
        }
        return image;
    }

    public static Rectangle getSourceRegion(IIOParam iIOParam, int n, int n2) {
        Rectangle rectangle = new Rectangle(n, n2);
        if (iIOParam != null) {
            Rectangle rectangle2 = iIOParam.getSourceRegion();
            if (rectangle2 != null) {
                rectangle = rectangle.intersection(rectangle2);
            }
            int n3 = iIOParam.getSubsamplingXOffset();
            int n4 = iIOParam.getSubsamplingYOffset();
            rectangle.x += n3;
            rectangle.y += n4;
            rectangle.width -= n3;
            rectangle.height -= n4;
        }
        return rectangle;
    }

    public static BufferedImage fakeAOI(BufferedImage bufferedImage, Rectangle rectangle) {
        if (bufferedImage == null) {
            return null;
        }
        if (rectangle != null && (rectangle.x != 0 || rectangle.y != 0 || rectangle.width != bufferedImage.getWidth() || rectangle.height != bufferedImage.getHeight())) {
            return bufferedImage.getSubimage(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        return bufferedImage;
    }

    public static <T> void deregisterProvider(ServiceRegistry serviceRegistry, IIOServiceProvider iIOServiceProvider, Class<T> clazz) {
        serviceRegistry.deregisterServiceProvider(clazz.cast(iIOServiceProvider), clazz);
    }

    public static <T> T lookupProviderByName(ServiceRegistry serviceRegistry, String string, Class<T> clazz) {
        try {
            return clazz.cast(serviceRegistry.getServiceProviderByClass(Class.forName(string)));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static String[] getNormalizedReaderFormatNames() {
        return IIOUtil.normalizeNames(ImageIO.getReaderFormatNames());
    }

    public static String[] getNormalizedWriterFormatNames() {
        return IIOUtil.normalizeNames(ImageIO.getWriterFormatNames());
    }

    private static String[] normalizeNames(String[] stringArray) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string : stringArray) {
            treeSet.add(string.toUpperCase());
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }
}

