/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.opdsget.api;

import com.io7m.jaffirm.core.Invariants;
import java.net.URI;
import java.nio.file.Path;
import java.util.Objects;
import one.lfa.opdsget.api.OPDSLocalFile;
import one.lfa.opdsget.api.OPDSURIRewriterType;

public final class OPDSURIRewriters {
    private OPDSURIRewriters() {
    }

    public static OPDSURIRewriterType relativeRewriter() {
        return (sourceFileOpt, targetFile) -> {
            if (sourceFileOpt.isPresent()) {
                OPDSLocalFile sourceFile = (OPDSLocalFile)sourceFileOpt.get();
                Path sourceURI = sourceFile.file().toAbsolutePath().getParent();
                Invariants.checkInvariant(sourceURI, sourceURI.isAbsolute(), u -> "Source must be absolute");
                Path targetURI = targetFile.file().toAbsolutePath();
                Invariants.checkInvariant(targetURI, targetURI.isAbsolute(), u -> "Target must be absolute");
                URI relative = URI.create(sourceURI.relativize(targetURI).toString());
                Invariants.checkInvariant(relative, !relative.isAbsolute(), u -> "Output must be relative");
                return relative;
            }
            Path sourceURI = targetFile.file().getParent().getParent().toAbsolutePath();
            Path targetURI = targetFile.file().toAbsolutePath();
            Invariants.checkInvariant(targetURI, targetURI.isAbsolute(), u -> "Target must be absolute");
            URI relative = URI.create(sourceURI.relativize(targetURI).toString());
            Invariants.checkInvariant(relative, !relative.isAbsolute(), u -> "Output must be relative");
            return relative;
        };
    }

    public static OPDSURIRewriterType plainFileRewriter(Path output) {
        return OPDSURIRewriters.namedSchemeRewriter("file", output);
    }

    public static OPDSURIRewriterType namedSchemeRewriter(String scheme, Path output) {
        Objects.requireNonNull(scheme, "scheme");
        Objects.requireNonNull(output, "output");
        return (sourceFile, targetFile) -> {
            Path file = targetFile.file();
            return URI.create(scheme + "://" + output.relativize(file));
        };
    }

    public static OPDSURIRewriterType noRewriter() {
        return (sourceFile, targetFile) -> targetFile.uri();
    }
}

