/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jaffirm.core;

import com.io7m.jaffirm.core.ContractLongConditionType;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;

public final class ContractLongCondition
implements ContractLongConditionType {
    private final LongPredicate predicate;
    private final LongFunction<String> describer;

    private ContractLongCondition(LongPredicate predicate, LongFunction<String> describer) {
        this.predicate = Objects.requireNonNull(predicate, "predicate");
        this.describer = Objects.requireNonNull(describer, "describer");
    }

    private ContractLongCondition(ContractLongCondition original, LongPredicate predicate, LongFunction<String> describer) {
        this.predicate = predicate;
        this.describer = describer;
    }

    @Override
    public LongPredicate predicate() {
        return this.predicate;
    }

    @Override
    public LongFunction<String> describer() {
        return this.describer;
    }

    public final ContractLongCondition withPredicate(LongPredicate value) {
        if (this.predicate == value) {
            return this;
        }
        LongPredicate newValue = Objects.requireNonNull(value, "predicate");
        return new ContractLongCondition(this, newValue, this.describer);
    }

    public final ContractLongCondition withDescriber(LongFunction<String> value) {
        if (this.describer == value) {
            return this;
        }
        LongFunction<String> newValue = Objects.requireNonNull(value, "describer");
        return new ContractLongCondition(this, this.predicate, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ContractLongCondition && this.equalTo((ContractLongCondition)another);
    }

    private boolean equalTo(ContractLongCondition another) {
        return this.predicate.equals(another.predicate) && this.describer.equals(another.describer);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.predicate.hashCode();
        h += (h << 5) + this.describer.hashCode();
        return h;
    }

    public String toString() {
        return "ContractLongCondition{predicate=" + this.predicate + ", describer=" + this.describer + "}";
    }

    public static ContractLongCondition of(LongPredicate predicate, LongFunction<String> describer) {
        return new ContractLongCondition(predicate, describer);
    }

    public static ContractLongCondition copyOf(ContractLongConditionType instance) {
        if (instance instanceof ContractLongCondition) {
            return (ContractLongCondition)instance;
        }
        return ContractLongCondition.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PREDICATE = 1L;
        private static final long INIT_BIT_DESCRIBER = 2L;
        private long initBits = 3L;
        private LongPredicate predicate;
        private LongFunction<String> describer;

        private Builder() {
        }

        public final Builder from(ContractLongConditionType instance) {
            Objects.requireNonNull(instance, "instance");
            this.setPredicate(instance.predicate());
            this.setDescriber(instance.describer());
            return this;
        }

        public final Builder setPredicate(LongPredicate predicate) {
            this.predicate = Objects.requireNonNull(predicate, "predicate");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setDescriber(LongFunction<String> describer) {
            this.describer = Objects.requireNonNull(describer, "describer");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ContractLongCondition build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ContractLongCondition(null, this.predicate, this.describer);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("predicate");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("describer");
            }
            return "Cannot build ContractLongCondition, some of required attributes are not set " + attributes;
        }
    }
}

