/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jaffirm.core;

import com.io7m.jaffirm.core.ContractConditionType;
import com.io7m.jaffirm.core.ContractDoubleConditionType;
import com.io7m.jaffirm.core.ContractIntConditionType;
import com.io7m.jaffirm.core.ContractLongConditionType;
import com.io7m.jaffirm.core.InvariantViolationException;
import com.io7m.jaffirm.core.SafeApplication;
import com.io7m.jaffirm.core.Violations;
import com.io7m.junreachable.UnreachableCodeException;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class Invariants {
    private Invariants() {
        throw new UnreachableCodeException();
    }

    @SafeVarargs
    public static <T> T checkInvariants(T value, ContractConditionType<T> ... conditions) throws InvariantViolationException {
        Violations violations = Violations.innerCheckAll(value, conditions);
        if (violations != null) {
            throw new InvariantViolationException(Invariants.failedMessage(value, violations), null, violations.count());
        }
        return value;
    }

    public static int checkInvariantsI(int value, ContractIntConditionType ... conditions) throws InvariantViolationException {
        Violations violations = Violations.innerCheckAllInt(value, conditions);
        if (violations != null) {
            throw new InvariantViolationException(Invariants.failedMessage(value, violations), null, violations.count());
        }
        return value;
    }

    public static long checkInvariantsL(long value, ContractLongConditionType ... conditions) throws InvariantViolationException {
        Violations violations = Violations.innerCheckAllLong(value, conditions);
        if (violations != null) {
            throw new InvariantViolationException(Invariants.failedMessage(value, violations), null, violations.count());
        }
        return value;
    }

    public static double checkInvariantsD(double value, ContractDoubleConditionType ... conditions) throws InvariantViolationException {
        Violations violations = Violations.innerCheckAllDouble(value, conditions);
        if (violations != null) {
            throw new InvariantViolationException(Invariants.failedMessage(value, violations), null, violations.count());
        }
        return value;
    }

    public static <T> T checkInvariant(T value, ContractConditionType<T> condition) throws InvariantViolationException {
        return Invariants.checkInvariant(value, condition.predicate(), condition.describer());
    }

    public static <T> T checkInvariant(T value, Predicate<T> predicate, Function<T, String> describer) {
        boolean ok;
        try {
            ok = predicate.test(value);
        }
        catch (Throwable e) {
            Violations violations = Violations.singleViolation(SafeApplication.failedPredicate(e));
            throw new InvariantViolationException(Invariants.failedMessage(value, violations), e, violations.count());
        }
        return Invariants.innerCheckInvariant(value, ok, describer);
    }

    public static <T> T checkInvariant(T value, boolean condition, Function<T, String> describer) {
        return Invariants.innerCheckInvariant(value, condition, describer);
    }

    public static void checkInvariant(boolean condition, String message) throws InvariantViolationException {
        if (!condition) {
            Violations violations = Violations.singleViolation(message);
            throw new InvariantViolationException(Invariants.failedMessage("<unspecified>", violations), null, violations.count());
        }
    }

    public static void checkInvariant(boolean condition, Supplier<String> message) throws InvariantViolationException {
        if (!condition) {
            Violations violations = Violations.singleViolation(SafeApplication.applySupplierChecked(message));
            throw new InvariantViolationException(Invariants.failedMessage("<unspecified>", violations), null, violations.count());
        }
    }

    public static <T> T checkInvariantV(T value, boolean condition, String format, Object ... objects) {
        if (!condition) {
            Violations violations = Violations.singleViolation(String.format(format, objects));
            throw new InvariantViolationException(Invariants.failedMessage(value, violations), null, violations.count());
        }
        return value;
    }

    public static void checkInvariantV(boolean condition, String format, Object ... objects) {
        Invariants.checkInvariantV("<unspecified>", condition, format, objects);
    }

    public static int checkInvariantI(int value, ContractIntConditionType condition) throws InvariantViolationException {
        return Invariants.checkInvariantI(value, condition.predicate(), condition.describer());
    }

    public static int checkInvariantI(int value, IntPredicate predicate, IntFunction<String> describer) {
        boolean ok;
        try {
            ok = predicate.test(value);
        }
        catch (Throwable e) {
            Violations violations = Violations.singleViolation(SafeApplication.failedPredicate(e));
            throw new InvariantViolationException(Invariants.failedMessage(value, violations), e, violations.count());
        }
        return Invariants.innerCheckInvariantI(value, ok, describer);
    }

    public static int checkInvariantI(int value, boolean condition, IntFunction<String> describer) {
        return Invariants.innerCheckInvariantI(value, condition, describer);
    }

    public static long checkInvariantL(long value, ContractLongConditionType condition) throws InvariantViolationException {
        return Invariants.checkInvariantL(value, condition.predicate(), condition.describer());
    }

    public static long checkInvariantL(long value, LongPredicate predicate, LongFunction<String> describer) {
        boolean ok;
        try {
            ok = predicate.test(value);
        }
        catch (Throwable e) {
            Violations violations = Violations.singleViolation(SafeApplication.failedPredicate(e));
            throw new InvariantViolationException(Invariants.failedMessage(value, violations), e, violations.count());
        }
        return Invariants.innerCheckInvariantL(value, ok, describer);
    }

    public static long checkInvariantL(long value, boolean condition, LongFunction<String> describer) {
        return Invariants.innerCheckInvariantL(value, condition, describer);
    }

    public static double checkInvariantD(double value, ContractDoubleConditionType condition) throws InvariantViolationException {
        return Invariants.checkInvariantD(value, condition.predicate(), condition.describer());
    }

    public static double checkInvariantD(double value, DoublePredicate predicate, DoubleFunction<String> describer) {
        boolean ok;
        try {
            ok = predicate.test(value);
        }
        catch (Throwable e) {
            Violations violations = Violations.singleViolation(SafeApplication.failedPredicate(e));
            throw new InvariantViolationException(Invariants.failedMessage(value, violations), e, violations.count());
        }
        return Invariants.innerCheckInvariantD(value, ok, describer);
    }

    public static double checkInvariantD(double value, boolean condition, DoubleFunction<String> describer) {
        return Invariants.innerCheckInvariantD(value, condition, describer);
    }

    private static <T> T innerCheckInvariant(T value, boolean condition, Function<T, String> describer) {
        if (!condition) {
            Violations violations = Violations.singleViolation(SafeApplication.applyDescriberChecked(value, describer));
            throw new InvariantViolationException(Invariants.failedMessage(value, violations), null, violations.count());
        }
        return value;
    }

    private static double innerCheckInvariantD(double value, boolean condition, DoubleFunction<String> describer) {
        if (!condition) {
            Violations violations = Violations.singleViolation(SafeApplication.applyDescriberDChecked(value, describer));
            throw new InvariantViolationException(Invariants.failedMessage(value, violations), null, violations.count());
        }
        return value;
    }

    private static long innerCheckInvariantL(long value, boolean condition, LongFunction<String> describer) {
        if (!condition) {
            Violations violations = Violations.singleViolation(SafeApplication.applyDescriberLChecked(value, describer));
            throw new InvariantViolationException(Invariants.failedMessage(value, violations), null, violations.count());
        }
        return value;
    }

    private static int innerCheckInvariantI(int value, boolean condition, IntFunction<String> describer) {
        if (!condition) {
            Violations violations = Violations.singleViolation(SafeApplication.applyDescriberIChecked(value, describer));
            throw new InvariantViolationException(Invariants.failedMessage(value, violations), null, violations.count());
        }
        return value;
    }

    private static <T> String failedMessage(T value, Violations violations) {
        String line_separator = System.lineSeparator();
        StringBuilder sb = new StringBuilder(128);
        sb.append("Invariant violation.");
        sb.append(line_separator);
        sb.append("  Received: ");
        sb.append(value);
        sb.append(line_separator);
        sb.append("  Violated conditions: ");
        sb.append(line_separator);
        String[] messages = violations.messages();
        for (int index = 0; index < messages.length; ++index) {
            if (messages[index] == null) continue;
            sb.append("    [");
            sb.append(index);
            sb.append("]: ");
            sb.append(messages[index]);
            sb.append(line_separator);
        }
        return sb.toString();
    }
}

