/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.jpeg;

import com.twelvemonkeys.imageio.color.YCbCrConverter;
import com.twelvemonkeys.imageio.metadata.Directory;
import com.twelvemonkeys.imageio.metadata.Entry;
import com.twelvemonkeys.imageio.plugins.jpeg.JPEGImageReader;
import com.twelvemonkeys.imageio.plugins.jpeg.ThumbnailReadProgressListener;
import com.twelvemonkeys.imageio.plugins.jpeg.ThumbnailReader;
import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.lang.Validate;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import javax.imageio.IIOException;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

final class EXIFThumbnailReader
extends ThumbnailReader {
    private final ImageReader reader;
    private final Directory ifd;
    private final ImageInputStream stream;
    private final int compression;
    private transient SoftReference<BufferedImage> cachedThumbnail;

    EXIFThumbnailReader(ThumbnailReadProgressListener thumbnailReadProgressListener, ImageReader imageReader, int n, int n2, Directory directory, ImageInputStream imageInputStream) {
        super(thumbnailReadProgressListener, n, n2);
        this.reader = Validate.notNull(imageReader);
        this.ifd = directory;
        this.stream = imageInputStream;
        Entry entry = directory.getEntryById(259);
        this.compression = entry != null ? ((Number)entry.getValue()).intValue() : 6;
    }

    @Override
    public BufferedImage read() throws IOException {
        if (this.compression == 1) {
            this.processThumbnailStarted();
            BufferedImage bufferedImage = this.readUncompressed();
            this.processThumbnailProgress(100.0f);
            this.processThumbnailComplete();
            return bufferedImage;
        }
        if (this.compression == 6) {
            this.processThumbnailStarted();
            BufferedImage bufferedImage = this.readJPEGCached(true);
            this.processThumbnailProgress(100.0f);
            this.processThumbnailComplete();
            return bufferedImage;
        }
        throw new IIOException("Unsupported EXIF thumbnail compression: " + this.compression);
    }

    private BufferedImage readJPEGCached(boolean bl) throws IOException {
        BufferedImage bufferedImage;
        BufferedImage bufferedImage2 = bufferedImage = this.cachedThumbnail != null ? this.cachedThumbnail.get() : null;
        if (bufferedImage == null) {
            bufferedImage = this.readJPEG();
        }
        this.cachedThumbnail = bl ? null : new SoftReference<BufferedImage>(bufferedImage);
        return bufferedImage;
    }

    /*
     * Loose catch block
     */
    private BufferedImage readJPEG() throws IOException {
        Entry entry = this.ifd.getEntryById(513);
        if (entry != null) {
            this.stream.seek(((Number)entry.getValue()).longValue());
            InputStream inputStream = IIOUtil.createStreamAdapter(this.stream);
            byte[] byArray = new byte[]{(byte)inputStream.read(), (byte)inputStream.read(), -1, -31, 0, 16, 69, 120, 105, 102, 0, 0, 77, 77, 0, 42, 0, 0, 0, 0};
            inputStream = new SequenceInputStream(new ByteArrayInputStream(byArray), inputStream);
            try {
                try (MemoryCacheImageInputStream memoryCacheImageInputStream = new MemoryCacheImageInputStream(inputStream);){
                    BufferedImage bufferedImage = EXIFThumbnailReader.readJPEGThumbnail(this.reader, memoryCacheImageInputStream);
                    return bufferedImage;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                inputStream.close();
            }
        }
        throw new IIOException("Missing JPEGInterchangeFormat tag for JPEG compressed EXIF thumbnail");
    }

    private BufferedImage readUncompressed() throws IOException {
        int[] nArray;
        Entry entry = this.ifd.getEntryById(256);
        Entry entry2 = this.ifd.getEntryById(257);
        if (entry == null || entry2 == null) {
            throw new IIOException("Missing dimensions for uncompressed EXIF thumbnail");
        }
        Entry entry3 = this.ifd.getEntryById(258);
        Entry entry4 = this.ifd.getEntryById(277);
        Entry entry5 = this.ifd.getEntryById(262);
        int n = ((Number)entry.getValue()).intValue();
        int n2 = ((Number)entry2.getValue()).intValue();
        if (entry3 != null && !Arrays.equals(nArray = (int[])entry3.getValue(), new int[]{8, 8, 8})) {
            throw new IIOException("Unknown BitsPerSample value for uncompressed EXIF thumbnail (expected [8, 8, 8]): " + entry3.getValueAsString());
        }
        if (entry4 != null && (Integer)entry4.getValue() != 3) {
            throw new IIOException("Unknown SamplesPerPixel value for uncompressed EXIF thumbnail (expected 3): " + entry4.getValueAsString());
        }
        int n3 = entry5 != null ? ((Number)entry5.getValue()).intValue() : 2;
        Entry entry6 = this.ifd.getEntryById(273);
        if (entry6 != null) {
            this.stream.seek(((Number)entry6.getValue()).longValue());
            int n4 = n * n2 * 3;
            byte[] byArray = JPEGImageReader.readFully(this.stream, n4);
            switch (n3) {
                case 2: {
                    break;
                }
                case 6: {
                    for (int i = 0; i < n4; i += 3) {
                        YCbCrConverter.convertYCbCr2RGB(byArray, byArray, i);
                    }
                    break;
                }
                default: {
                    throw new IIOException("Unknown PhotometricInterpretation value for uncompressed EXIF thumbnail (expected 2 or 6): " + n3);
                }
            }
            return ThumbnailReader.readRawThumbnail(byArray, n4, 0, n, n2);
        }
        throw new IIOException("Missing StripOffsets tag for uncompressed EXIF thumbnail");
    }

    @Override
    public int getWidth() throws IOException {
        if (this.compression == 1) {
            Entry entry = this.ifd.getEntryById(256);
            if (entry == null) {
                throw new IIOException("Missing dimensions for uncompressed EXIF thumbnail");
            }
            return ((Number)entry.getValue()).intValue();
        }
        if (this.compression == 6) {
            return this.readJPEGCached(false).getWidth();
        }
        throw new IIOException("Unsupported EXIF thumbnail compression (expected 1 or 6): " + this.compression);
    }

    @Override
    public int getHeight() throws IOException {
        if (this.compression == 1) {
            Entry entry = this.ifd.getEntryById(257);
            if (entry == null) {
                throw new IIOException("Missing dimensions for uncompressed EXIF thumbnail");
            }
            return ((Number)entry.getValue()).intValue();
        }
        if (this.compression == 6) {
            return this.readJPEGCached(false).getHeight();
        }
        throw new IIOException("Unsupported EXIF thumbnail compression  (expected 1 or 6): " + this.compression);
    }
}

