/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.jpeg;

import com.twelvemonkeys.imageio.plugins.jpeg.AdobeDCT;
import com.twelvemonkeys.imageio.plugins.jpeg.Application;
import com.twelvemonkeys.imageio.plugins.jpeg.Frame;
import com.twelvemonkeys.imageio.plugins.jpeg.JFIF;
import com.twelvemonkeys.imageio.plugins.jpeg.JFXX;
import com.twelvemonkeys.imageio.plugins.jpeg.JFXXThumbnailReader;
import com.twelvemonkeys.imageio.plugins.jpeg.JPEGImageReader;
import com.twelvemonkeys.xml.XMLSerializer;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.util.List;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class JPEGImage10MetadataCleaner {
    static final String JAVAX_IMAGEIO_JPEG_IMAGE_1_0 = "javax_imageio_jpeg_image_1.0";
    private final JPEGImageReader reader;

    JPEGImage10MetadataCleaner(JPEGImageReader jPEGImageReader) {
        this.reader = jPEGImageReader;
    }

    IIOMetadata cleanMetadata(IIOMetadata iIOMetadata) throws IOException {
        Object object;
        Object object2;
        NodeList nodeList;
        Object object3;
        Object object5;
        List<Application> list = this.reader.getAppSegments(-1, null);
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)iIOMetadata.getAsTree(JAVAX_IMAGEIO_JPEG_IMAGE_1_0);
        IIOMetadataNode iIOMetadataNode2 = (IIOMetadataNode)iIOMetadataNode.getElementsByTagName("JPEGvariety").item(0);
        IIOMetadataNode iIOMetadataNode3 = (IIOMetadataNode)iIOMetadataNode.getElementsByTagName("markerSequence").item(0);
        JFIF jFIF = this.reader.getJFIF();
        JFXX jFXX = this.reader.getJFXX();
        AdobeDCT adobeDCT = this.reader.getAdobeDCT();
        ICC_Profile iCC_Profile = this.reader.getEmbeddedICCProfile(true);
        Frame frame = this.reader.getSOF();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (jFIF != null) {
            if (frame.componentsInFrame() == 1 || frame.componentsInFrame() == 3) {
                IIOMetadataNode iIOMetadataNode4;
                object5 = new IIOMetadataNode("app0JFIF");
                ((IIOMetadataNode)object5).setAttribute("majorVersion", String.valueOf(jFIF.majorVersion));
                ((IIOMetadataNode)object5).setAttribute("minorVersion", String.valueOf(jFIF.minorVersion));
                ((IIOMetadataNode)object5).setAttribute("resUnits", String.valueOf(jFIF.units));
                ((IIOMetadataNode)object5).setAttribute("Xdensity", String.valueOf(Math.max(1, jFIF.xDensity)));
                ((IIOMetadataNode)object5).setAttribute("Ydensity", String.valueOf(Math.max(1, jFIF.yDensity)));
                ((IIOMetadataNode)object5).setAttribute("thumbWidth", String.valueOf(jFIF.xThumbnail));
                ((IIOMetadataNode)object5).setAttribute("thumbHeight", String.valueOf(jFIF.yThumbnail));
                iIOMetadataNode2.appendChild((Node)object5);
                bl = true;
                if (iCC_Profile != null) {
                    iIOMetadataNode4 = new IIOMetadataNode("app2ICC");
                    iIOMetadataNode4.setUserObject(iCC_Profile);
                    ((IIOMetadataNode)object5).appendChild(iIOMetadataNode4);
                    bl3 = true;
                }
                if (jFXX != null) {
                    iIOMetadataNode4 = new IIOMetadataNode("JFXX");
                    ((IIOMetadataNode)object5).appendChild(iIOMetadataNode4);
                    IIOMetadataNode object42 = new IIOMetadataNode("app0JFXX");
                    object42.setAttribute("extensionCode", String.valueOf(jFXX.extensionCode));
                    object3 = new JFXXThumbnailReader(null, this.reader.getThumbnailReader(), 0, 0, jFXX);
                    switch (jFXX.extensionCode) {
                        case 16: {
                            nodeList = new IIOMetadataNode("JFIFthumbJPEG");
                            object2 = ((JFXXThumbnailReader)object3).readMetadata();
                            object = ((IIOMetadata)object2).getAsTree(JAVAX_IMAGEIO_JPEG_IMAGE_1_0);
                            ((IIOMetadataNode)nodeList).appendChild(object.getLastChild());
                            object42.appendChild((Node)((Object)nodeList));
                            break;
                        }
                        case 17: {
                            nodeList = new IIOMetadataNode("JFIFthumbPalette");
                            ((IIOMetadataNode)nodeList).setAttribute("thumbWidth", String.valueOf(((JFXXThumbnailReader)object3).getWidth()));
                            ((IIOMetadataNode)nodeList).setAttribute("thumbHeight", String.valueOf(((JFXXThumbnailReader)object3).getHeight()));
                            object42.appendChild((Node)((Object)nodeList));
                            break;
                        }
                        case 19: {
                            nodeList = new IIOMetadataNode("JFIFthumbRGB");
                            ((IIOMetadataNode)nodeList).setAttribute("thumbWidth", String.valueOf(((JFXXThumbnailReader)object3).getWidth()));
                            ((IIOMetadataNode)nodeList).setAttribute("thumbHeight", String.valueOf(((JFXXThumbnailReader)object3).getHeight()));
                            object42.appendChild((Node)((Object)nodeList));
                            break;
                        }
                        default: {
                            this.reader.processWarningOccurred(String.format("Unknown JFXX extension code: %d", jFXX.extensionCode));
                        }
                    }
                    iIOMetadataNode4.appendChild(object42);
                    bl2 = true;
                }
            } else {
                this.reader.processWarningOccurred(String.format("Incompatible JFIF marker segment in stream. SOF%d has %d color components, JFIF allows only 1 or 3 components. Ignoring JFIF marker.", frame.marker & 0xF, frame.componentsInFrame()));
            }
        }
        if (adobeDCT != null && (adobeDCT.transform == 2 && frame.componentsInFrame() < 4 || adobeDCT.transform == 1 && frame.componentsInFrame() < 3)) {
            this.reader.processWarningOccurred(String.format("Invalid Adobe App14 marker. Indicates %s data, but SOF%d has %d color component(s). Ignoring Adobe App14 marker.", adobeDCT.transform == 2 ? "YCCK/CMYK" : "YCC/RGB", frame.marker & 0xF, frame.componentsInFrame()));
            object5 = iIOMetadataNode.getElementsByTagName("app14Adobe");
            for (int i = object5.getLength() - 1; i >= 0; --i) {
                Node node = object5.item(i);
                node.getParentNode().removeChild(node);
            }
        }
        object5 = null;
        for (Application application : list) {
            if (application.marker == 65504 && "JFIF".equals(application.identifier) && bl || application.marker == 65504 && "JFXX".equals(application.identifier) && bl2 || application.marker == 65505 && "Exif".equals(application.identifier) || application.marker == 65506 && "ICC_PROFILE".equals(application.identifier) && bl3 || application.marker == 65518 && "Adobe".equals(application.identifier)) continue;
            object3 = new IIOMetadataNode("unknown");
            ((IIOMetadataNode)object3).setAttribute("MarkerTag", Integer.toString(application.marker & 0xFF));
            ((IIOMetadataNode)object3).setUserObject(application.data);
            if (object5 == null) {
                nodeList = iIOMetadataNode3.getElementsByTagName("unknown");
                object5 = nodeList.getLength() > 0 ? nodeList.item(nodeList.getLength() - 1).getNextSibling() : iIOMetadataNode3.getFirstChild();
            }
            iIOMetadataNode3.insertBefore((Node)object3, (Node)object5);
        }
        NodeList nodeList2 = iIOMetadataNode3.getElementsByTagName("sof");
        if (nodeList2.getLength() > 0) {
            NodeList nodeList3 = nodeList2.item(0).getChildNodes();
            for (int i = 0; i < nodeList3.getLength(); ++i) {
                this.forceComponentIdInRange((IIOMetadataNode)nodeList3.item(i), "componentId");
            }
        }
        NodeList nodeList4 = iIOMetadataNode3.getElementsByTagName("sos");
        for (int i = 0; i < nodeList4.getLength(); ++i) {
            nodeList = nodeList4.item(i).getChildNodes();
            for (int j = 0; j < nodeList.getLength(); ++j) {
                this.forceComponentIdInRange((IIOMetadataNode)nodeList.item(j), "componentSelector");
            }
        }
        NodeList nodeList5 = iIOMetadataNode3.getElementsByTagName("dht");
        for (int i = 0; i < nodeList5.getLength(); ++i) {
            object2 = nodeList5.item(i);
            object = object2.getChildNodes();
            if (object.getLength() < 1) {
                object2.getParentNode().removeChild((Node)object2);
                this.reader.processWarningOccurred("Metadata contains empty dht node. Ignoring.");
                continue;
            }
            if (object.getLength() <= 4) continue;
            IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("dht");
            object2.getParentNode().insertBefore(iIOMetadataNode4, object2.getNextSibling());
            for (int j = object.getLength() - 1; j >= 0; --j) {
                Element element = (Element)object.item(j);
                String string = element.getAttribute("class");
                if (!"1".equals(string)) continue;
                object2.removeChild(element);
                iIOMetadataNode4.insertBefore(element, iIOMetadataNode4.getFirstChild());
            }
        }
        try {
            iIOMetadata.setFromTree(JAVAX_IMAGEIO_JPEG_IMAGE_1_0, iIOMetadataNode);
        }
        catch (IIOInvalidTreeException iIOInvalidTreeException) {
            if (JPEGImageReader.DEBUG) {
                new XMLSerializer(System.out, System.getProperty("file.encoding")).serialize(iIOMetadata.getAsTree(JAVAX_IMAGEIO_JPEG_IMAGE_1_0), false);
                System.out.println("-- 8< --");
                new XMLSerializer(System.out, System.getProperty("file.encoding")).serialize(iIOMetadataNode, false);
            }
            throw iIOInvalidTreeException;
        }
        return iIOMetadata;
    }

    private void forceComponentIdInRange(IIOMetadataNode iIOMetadataNode, String string) {
        String string2 = iIOMetadataNode.getAttribute(string);
        if (string2 != null) {
            try {
                int n = Integer.parseInt(string2);
                if (n < 0) {
                    n = (byte)n & 0xFF;
                    iIOMetadataNode.setAttribute(string, String.valueOf(n));
                }
            }
            catch (NumberFormatException numberFormatException) {
                if ("scanComponentSpec".equals(iIOMetadataNode.getNodeName())) {
                    this.reader.processWarningOccurred("Bad SOS component selector: " + string2);
                }
                this.reader.processWarningOccurred("Bad SOF component id: " + string2);
            }
        }
    }
}

