/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.opdsget.api;

import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import one.lfa.opdsget.api.ImmutableStyleType;
import one.lfa.opdsget.api.OPDSAuthenticationType;
import one.lfa.opdsget.api.OPDSMatchingAuthentication;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ImmutableStyleType
@Value.Immutable
public interface OPDSAuthenticationPatternMappedType
extends Function<URI, Optional<OPDSAuthenticationType>> {
    public static final Logger LOG = LoggerFactory.getLogger(OPDSAuthenticationPatternMappedType.class);

    @Value.Parameter
    public List<OPDSMatchingAuthentication> patterns();

    @Override
    default public Optional<OPDSAuthenticationType> apply(URI uri) {
        Objects.requireNonNull(uri, "uri");
        List<OPDSMatchingAuthentication> patterns = this.patterns();
        String uri_text = uri.toString();
        for (int index = 0; index < patterns.size(); ++index) {
            OPDSMatchingAuthentication uri_matcher = patterns.get(index);
            Matcher matcher = uri_matcher.pattern().matcher(uri_text);
            if (matcher.matches()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("{} matches {}", (Object)uri_matcher.pattern().pattern(), (Object)uri_text);
                }
                return uri_matcher.authentication();
            }
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace("{} does not match {}", (Object)uri_matcher.pattern().pattern(), (Object)uri_text);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("no pattern matches {}", (Object)uri_text);
        }
        return Optional.empty();
    }
}

