/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.opdsget.api;

import java.net.URI;
import java.util.Map;
import one.lfa.opdsget.api.ImmutableStyleType;
import one.lfa.opdsget.api.OPDSLocalFile;
import org.immutables.value.Value;

@ImmutableStyleType
@Value.Immutable
public interface OPDSDocumentProcessedType {
    @Value.Default
    @Value.Parameter
    default public Map<URI, OPDSLocalFile> feeds() {
        return Map.of();
    }

    @Value.Default
    @Value.Parameter
    default public Map<URI, OPDSLocalFile> images() {
        return Map.of();
    }

    @Value.Default
    @Value.Parameter
    default public Map<URI, OPDSLocalFile> books() {
        return Map.of();
    }

    @Value.Parameter
    public OPDSLocalFile file();

    @Value.Parameter
    public boolean isEntry();

    @Value.Parameter
    public String title();

    @Value.Check
    default public void checkPreconditions() {
        for (URI uri : this.feeds().keySet()) {
            if (uri.isAbsolute()) continue;
            throw new IllegalArgumentException("Non-absolute feed URI: " + uri);
        }
        for (URI uri : this.images().keySet()) {
            if (uri.isAbsolute()) continue;
            throw new IllegalArgumentException("Non-absolute image URI: " + uri);
        }
        for (URI uri : this.books().keySet()) {
            if (uri.isAbsolute()) continue;
            throw new IllegalArgumentException("Non-absolute book URI: " + uri);
        }
    }
}

