/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.opdsget.api;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Objects;
import one.lfa.opdsget.api.OPDSHTTPDataType;
import org.immutables.value.Generated;

@Generated(from="OPDSHTTPDataType", generator="Immutables")
public final class OPDSHTTPData
implements OPDSHTTPDataType {
    private final long size;
    private final String contentType;
    private final InputStream stream;

    private OPDSHTTPData(long size, String contentType, InputStream stream) {
        this.size = size;
        this.contentType = Objects.requireNonNull(contentType, "contentType");
        this.stream = Objects.requireNonNull(stream, "stream");
    }

    private OPDSHTTPData(Builder builder) {
        this.size = builder.size;
        this.contentType = builder.contentType;
        this.stream = builder.stream;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public String contentType() {
        return this.contentType;
    }

    @Override
    public InputStream stream() {
        return this.stream;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof OPDSHTTPData && this.equalTo((OPDSHTTPData)another);
    }

    private boolean equalTo(OPDSHTTPData another) {
        return this.size == another.size && this.contentType.equals(another.contentType) && this.stream.equals(another.stream);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.size);
        h += (h << 5) + this.contentType.hashCode();
        h += (h << 5) + this.stream.hashCode();
        return h;
    }

    public String toString() {
        return "OPDSHTTPData{size=" + this.size + ", contentType=" + this.contentType + ", stream=" + this.stream + "}";
    }

    public static OPDSHTTPData of(long size, String contentType, InputStream stream) {
        return new OPDSHTTPData(size, contentType, stream);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OPDSHTTPDataType", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_SIZE = 1L;
        private static final long INIT_BIT_CONTENT_TYPE = 2L;
        private static final long INIT_BIT_STREAM = 4L;
        private long initBits = 7L;
        private long size;
        private String contentType;
        private InputStream stream;

        private Builder() {
        }

        public final Builder from(OPDSHTTPDataType instance) {
            Objects.requireNonNull(instance, "instance");
            this.setSize(instance.size());
            this.setContentType(instance.contentType());
            this.setStream(instance.stream());
            return this;
        }

        public final Builder setSize(long size) {
            this.size = size;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setContentType(String contentType) {
            this.contentType = Objects.requireNonNull(contentType, "contentType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setStream(InputStream stream) {
            this.stream = Objects.requireNonNull(stream, "stream");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public OPDSHTTPData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new OPDSHTTPData(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("size");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("contentType");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("stream");
            }
            return "Cannot build OPDSHTTPData, some of required attributes are not set " + attributes;
        }
    }
}

