/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.opdsget.api;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import one.lfa.opdsget.api.OPDSAuthenticationType;
import one.lfa.opdsget.api.OPDSMatchingAuthenticationType;
import org.immutables.value.Generated;

@Generated(from="OPDSMatchingAuthenticationType", generator="Immutables")
public final class OPDSMatchingAuthentication
implements OPDSMatchingAuthenticationType {
    private final String patternText;
    private final transient Pattern pattern;
    private final OPDSAuthenticationType authentication;

    private OPDSMatchingAuthentication(String patternText, Optional<? extends OPDSAuthenticationType> authentication) {
        this.patternText = Objects.requireNonNull(patternText, "patternText");
        this.authentication = authentication.orElse(null);
        this.pattern = Objects.requireNonNull(OPDSMatchingAuthenticationType.super.pattern(), "pattern");
    }

    private OPDSMatchingAuthentication(Builder builder) {
        this.patternText = builder.patternText;
        this.authentication = builder.authentication;
        this.pattern = Objects.requireNonNull(OPDSMatchingAuthenticationType.super.pattern(), "pattern");
    }

    @Override
    public String patternText() {
        return this.patternText;
    }

    @Override
    public Pattern pattern() {
        return this.pattern;
    }

    @Override
    public Optional<OPDSAuthenticationType> authentication() {
        return Optional.ofNullable(this.authentication);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof OPDSMatchingAuthentication && this.equalTo((OPDSMatchingAuthentication)another);
    }

    private boolean equalTo(OPDSMatchingAuthentication another) {
        return this.patternText.equals(another.patternText) && Objects.equals(this.authentication, another.authentication);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.patternText.hashCode();
        h += (h << 5) + Objects.hashCode(this.authentication);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("OPDSMatchingAuthentication{");
        builder.append("patternText=").append(this.patternText);
        if (this.authentication != null) {
            builder.append(", ");
            builder.append("authentication=").append(this.authentication);
        }
        return builder.append("}").toString();
    }

    public static OPDSMatchingAuthentication of(String patternText, Optional<? extends OPDSAuthenticationType> authentication) {
        return new OPDSMatchingAuthentication(patternText, authentication);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OPDSMatchingAuthenticationType", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_PATTERN_TEXT = 1L;
        private long initBits = 1L;
        private String patternText;
        private OPDSAuthenticationType authentication;

        private Builder() {
        }

        public final Builder from(OPDSMatchingAuthenticationType instance) {
            Objects.requireNonNull(instance, "instance");
            this.setPatternText(instance.patternText());
            Optional<OPDSAuthenticationType> authenticationOptional = instance.authentication();
            if (authenticationOptional.isPresent()) {
                this.setAuthentication(authenticationOptional);
            }
            return this;
        }

        public final Builder setPatternText(String patternText) {
            this.patternText = Objects.requireNonNull(patternText, "patternText");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setAuthentication(OPDSAuthenticationType authentication) {
            this.authentication = Objects.requireNonNull(authentication, "authentication");
            return this;
        }

        public final Builder setAuthentication(Optional<? extends OPDSAuthenticationType> authentication) {
            this.authentication = authentication.orElse(null);
            return this;
        }

        public OPDSMatchingAuthentication build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new OPDSMatchingAuthentication(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("patternText");
            }
            return "Cannot build OPDSMatchingAuthentication, some of required attributes are not set " + attributes;
        }
    }
}

