/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.opdsget.api;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;

public final class OPDSURIHashing {
    private static final char[] HEX_CODE = "0123456789ABCDEF".toCharArray();

    private OPDSURIHashing() {
    }

    private static String hexShow(byte[] data) {
        StringBuilder sb = new StringBuilder(data.length * 2);
        for (byte b : data) {
            sb.append(HEX_CODE[b >> 4 & 0xF]);
            sb.append(HEX_CODE[b & 0xF]);
        }
        return sb.toString();
    }

    public static String hashOf(URI uri) {
        Objects.requireNonNull(uri, "uri");
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            return OPDSURIHashing.hexShow(digest.digest(uri.toString().getBytes(StandardCharsets.UTF_8)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

