/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.opdsget.cmdline;

import ch.qos.logback.classic.Level;
import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.internal.Console;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.lfa.epubsquash.vanilla.EPUBSquashers;
import one.lfa.opdsget.api.OPDSAuthenticationPatternMapped;
import one.lfa.opdsget.api.OPDSAuthenticationPatternMappedParser;
import one.lfa.opdsget.api.OPDSAuthenticationType;
import one.lfa.opdsget.api.OPDSGetConfiguration;
import one.lfa.opdsget.api.OPDSGetKind;
import one.lfa.opdsget.api.OPDSHTTPDefault;
import one.lfa.opdsget.api.OPDSRetrieverType;
import one.lfa.opdsget.api.OPDSSquashConfiguration;
import one.lfa.opdsget.api.OPDSURIRewriterType;
import one.lfa.opdsget.api.OPDSURIRewriters;
import one.lfa.opdsget.cmdline.UUIDConverter;
import one.lfa.opdsget.vanilla.OPDSManifestWriters;
import one.lfa.opdsget.vanilla.OPDSRetrievers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Main {
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);

    private Main() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        List excluded_kinds;
        Arguments parsed_arguments = new Arguments();
        JCommander jcommander = JCommander.newBuilder().programName("opdsget").addObject(parsed_arguments).build();
        try {
            jcommander.parse(args);
        }
        catch (ParameterException e) {
            LOG.error("could not parse command line arguments: {}", (Object)e.getMessage());
            StringBuilder sb = new StringBuilder(128);
            jcommander.setConsole(new StringBuilderConsole(sb));
            jcommander.usage();
            System.err.println(sb.toString());
            System.exit(1);
            return;
        }
        ch.qos.logback.classic.Logger root = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger("ROOT");
        root.setLevel(parsed_arguments.log_level.level);
        try {
            excluded_kinds = parsed_arguments.exclude_content_kinds.stream().map(OPDSGetKind::ofName).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOG.error("could not parse one or more content kinds: {}", (Object)e.getMessage());
            StringBuilder sb = new StringBuilder(128);
            jcommander.setConsole(new StringBuilderConsole(sb));
            jcommander.usage();
            System.err.println(sb.toString());
            System.exit(1);
            return;
        }
        Set<OPDSGetKind> included_kinds = Stream.of(OPDSGetKind.values()).filter(kind -> !excluded_kinds.contains(kind)).collect(Collectors.toSet());
        LOG.debug("excluding content kinds: {}", (Object)excluded_kinds);
        LOG.debug("including content kinds: {}", (Object)included_kinds);
        ExecutorService exec = Executors.newFixedThreadPool(4, runnable -> {
            Thread th = new Thread(runnable);
            th.setName("one.lfa.opdsget.io[" + th.getId() + "]");
            return th;
        });
        try {
            OPDSGetConfiguration.Builder builder = OPDSGetConfiguration.builder().setOutput(parsed_arguments.output_directory.toAbsolutePath()).setOutputManifestBaseURI(Optional.ofNullable(parsed_arguments.output_manifest_base_uri)).setOutputManifestID(parsed_arguments.output_manifest_uuid).setRemoteURI(parsed_arguments.feed).setFetchedKinds(included_kinds).setUriRewriter(Main.uriRewriterStrategy(parsed_arguments, parsed_arguments.uri_rewrite_strategy)).setOutputArchive(Optional.ofNullable(parsed_arguments.output_archive).map(x$0 -> Paths.get(x$0, new String[0])).map(Path::toAbsolutePath)).setScaleImages(OptionalDouble.of(parsed_arguments.scaleCoverImages)).setAuthenticationSupplier(Main.loadAuth(parsed_arguments.auth));
            if (parsed_arguments.squash) {
                builder.setSquash(OPDSSquashConfiguration.builder().setMaximumImageHeight(parsed_arguments.image_max_height).setMaximumImageWidth(parsed_arguments.image_max_width).setScaleFactor(parsed_arguments.image_scale).build());
            }
            OPDSGetConfiguration config = builder.build();
            OPDSRetrieverType retriever = OPDSRetrievers.providerWith(new EPUBSquashers(), new OPDSManifestWriters(), new OPDSHTTPDefault()).create(exec);
            retriever.retrieve(config).get();
        }
        catch (ParseException e) {
            LOG.error("error parsing authentication file: ", e);
            System.exit(1);
        }
        catch (ExecutionException e) {
            LOG.error("error retrieving feed: ", e.getCause());
            System.exit(1);
        }
        catch (Exception e) {
            LOG.error("error retrieving feed: ", e);
            System.exit(1);
        }
        finally {
            exec.shutdown();
        }
    }

    private static OPDSURIRewriterType uriRewriterStrategy(Arguments arguments, OPDSURIRewriteStrategy strategy) {
        switch (strategy) {
            case NONE: {
                return OPDSURIRewriters.noRewriter();
            }
            case NAMED: {
                return OPDSURIRewriters.namedSchemeRewriter(arguments.uri_rewrite_scheme_name, arguments.output_directory);
            }
            case RELATIVE: {
                return OPDSURIRewriters.relativeRewriter();
            }
        }
        throw new IllegalStateException("Unreachable code");
    }

    private static Function<URI, Optional<OPDSAuthenticationType>> loadAuth(String auth) throws IOException, ParseException {
        if (auth != null) {
            Path path = Paths.get(auth, new String[0]);
            try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
                OPDSAuthenticationPatternMapped oPDSAuthenticationPatternMapped = OPDSAuthenticationPatternMappedParser.parse(path.toUri(), stream);
                return oPDSAuthenticationPatternMapped;
            }
        }
        return uri -> Optional.empty();
    }

    final class OPDSLogLevelConverter
    implements IStringConverter<OPDSLogLevel> {
        OPDSLogLevelConverter() {
        }

        @Override
        public OPDSLogLevel convert(String value) {
            switch (value) {
                case "error": {
                    return OPDSLogLevel.ERROR;
                }
                case "info": {
                    return OPDSLogLevel.INFO;
                }
                case "debug": {
                    return OPDSLogLevel.DEBUG;
                }
                case "trace": {
                    return OPDSLogLevel.TRACE;
                }
            }
            throw new IllegalArgumentException("Could not parse '" + value + "' as log level");
        }
    }

    private static final class StringBuilderConsole
    implements Console {
        private final StringBuilder stringBuilder;

        StringBuilderConsole(StringBuilder inStringBuilder) {
            this.stringBuilder = Objects.requireNonNull(inStringBuilder, "inStringBuilder");
        }

        @Override
        public void print(String msg) {
            this.stringBuilder.append(msg);
        }

        @Override
        public void println(String msg) {
            this.stringBuilder.append(msg);
            this.stringBuilder.append(System.lineSeparator());
        }

        @Override
        public char[] readPassword(boolean echoInput) {
            return new char[0];
        }
    }

    private static final class Arguments {
        @Parameter(names={"--log-level"}, description="The logging level", converter=OPDSLogLevelConverter.class, required=false)
        private OPDSLogLevel log_level = OPDSLogLevel.INFO;
        @Parameter(names={"--feed"}, description="The URI of the remote feed", required=true)
        private URI feed;
        @Parameter(names={"--output-directory"}, description="The directory that will contain the downloaded feed objects", required=true)
        private Path output_directory;
        @Parameter(names={"--output-archive"}, description="The zip archive that will be created for the feed", required=false)
        private String output_archive;
        @Parameter(names={"--output-manifest-base-uri"}, description="The base URI that will be placed into manifest files", required=false)
        private URI output_manifest_base_uri;
        @Parameter(names={"--output-manifest-id"}, description="The UUID that will be placed into manifest files", converter=UUIDConverter.class, required=false)
        private UUID output_manifest_uuid = UUID.randomUUID();
        @Parameter(names={"--authentication"}, description="The file containing authentication information", required=false)
        private String auth;
        @Parameter(names={"--uri-rewrite-strategy"}, description="The strategy that will be used to rewrite URIs", required=false)
        private OPDSURIRewriteStrategy uri_rewrite_strategy = OPDSURIRewriteStrategy.RELATIVE;
        @Parameter(names={"--uri-rewrite-scheme-name"}, description="The name of the URI scheme used to rewrite URIs (if applicable)", required=false)
        private String uri_rewrite_scheme_name = "file";
        @Parameter(names={"--exclude-content-kind"}, description="The kind of content that will not be downloaded (Specify multiple times for multiple kinds)", required=false)
        private List<String> exclude_content_kinds = List.of();
        @Parameter(names={"--squash-image-max-width"}, required=false, description="The maximum width of images")
        private double image_max_width = 1600.0;
        @Parameter(names={"--squash-image-max-height"}, required=false, description="The maximum height of images")
        private double image_max_height = 1170.0;
        @Parameter(names={"--squash-image-scale"}, required=false, description="The image scale value")
        private double image_scale = 1.0;
        @Parameter(names={"--squash"}, required=false, description="True if EPUB files should be squashed to reduce their size")
        private boolean squash;
        @Parameter(names={"--scale-cover-images"}, required=false, description="A scale value in the range (0.0, 1.0] by which to scale cover images")
        private double scaleCoverImages = 1.0;

        Arguments() {
        }
    }

    static enum OPDSURIRewriteStrategy {
        NONE,
        NAMED,
        RELATIVE;

    }

    static enum OPDSLogLevel {
        ERROR(Level.ERROR),
        INFO(Level.INFO),
        DEBUG(Level.DEBUG),
        TRACE(Level.TRACE);

        private final Level level;

        private OPDSLogLevel(Level in_level) {
            this.level = Objects.requireNonNull(in_level, "level");
        }

        public String toString() {
            switch (this) {
                case ERROR: {
                    return "error";
                }
                case INFO: {
                    return "info";
                }
                case DEBUG: {
                    return "debug";
                }
                case TRACE: {
                    return "trace";
                }
            }
            throw new IllegalStateException("Unreachable code");
        }
    }
}

