/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.opdsget.vanilla;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import one.lfa.opdsget.api.FileEntry;
import one.lfa.opdsget.api.OPDSManifestDescription;
import one.lfa.opdsget.api.OPDSManifestWriterType;
import one.lfa.opdsget.manifest.schema.ManifestSchemas;
import org.apache.commons.codec.binary.Hex;

public final class OPDSManifestWriter
implements OPDSManifestWriterType {
    private final OutputStream outputStream;
    private final ByteArrayOutputStream buffer;
    private final OPDSManifestDescription description;

    OPDSManifestWriter(OPDSManifestDescription inDescription, OutputStream inOutputStream) {
        this.description = Objects.requireNonNull(inDescription, "inDescription");
        this.outputStream = Objects.requireNonNull(inOutputStream, "outputStream");
        this.buffer = new ByteArrayOutputStream(4096);
    }

    private static void writeFile(XMLStreamWriter writer, String namespaceURI, FileEntry file) throws XMLStreamException {
        writer.writeStartElement("om", "File", namespaceURI);
        writer.writeAttribute("name", file.path());
        writer.writeAttribute("hashAlgorithm", file.hashAlgorithm());
        writer.writeAttribute("hash", Hex.encodeHexString(file.hash(), false));
        writer.writeEndElement();
    }

    @Override
    public void write() throws IOException {
        try {
            Optional<URI> baseOpt;
            String namespaceURI = ManifestSchemas.schema1p0Namespace().toString();
            XMLOutputFactory factory = XMLOutputFactory.newFactory();
            XMLStreamWriter writer = factory.createXMLStreamWriter(this.buffer, "UTF-8");
            writer.writeStartDocument("UTF-8", "1.0");
            writer.setPrefix("om", namespaceURI);
            writer.writeStartElement(namespaceURI, "Manifest");
            writer.writeNamespace("om", namespaceURI);
            writer.writeAttribute("rootFile", this.description.rootFile());
            writer.writeAttribute("id", this.description.id().toString());
            writer.writeAttribute("updated", this.description.updated().toString());
            Optional<String> searchOpt = this.description.searchIndex();
            if (searchOpt.isPresent()) {
                writer.writeAttribute("searchIndex", searchOpt.get());
            }
            if ((baseOpt = this.description.base()).isPresent()) {
                writer.writeAttribute("base", baseOpt.get().toString());
            }
            this.writeFiles(namespaceURI, writer);
            writer.writeEndElement();
            writer.writeEndDocument();
            this.buffer.flush();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("standalone", "yes");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(new StreamSource(new ByteArrayInputStream(this.buffer.toByteArray())), new StreamResult(this.outputStream));
            this.outputStream.flush();
        }
        catch (XMLStreamException | TransformerException e) {
            throw new IOException(e);
        }
    }

    private void writeFiles(String namespaceURI, XMLStreamWriter writer) throws XMLStreamException {
        Map<URI, FileEntry> files = this.description.files();
        Set<Map.Entry<URI, FileEntry>> entries = files.entrySet();
        List sorted = entries.stream().sorted(Comparator.comparing(e -> ((FileEntry)e.getValue()).path())).collect(Collectors.toUnmodifiableList());
        for (Map.Entry entry : sorted) {
            OPDSManifestWriter.writeFile(writer, namespaceURI, (FileEntry)entry.getValue());
        }
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }
}

