/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.opdsget.vanilla;

import com.io7m.jaffirm.core.Preconditions;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import one.lfa.epubsquash.api.EPUBSquasherProviderType;
import one.lfa.opdsget.api.FileEntry;
import one.lfa.opdsget.api.OPDSAuthenticationType;
import one.lfa.opdsget.api.OPDSDocumentProcessed;
import one.lfa.opdsget.api.OPDSGetConfiguration;
import one.lfa.opdsget.api.OPDSHTTPData;
import one.lfa.opdsget.api.OPDSHTTPDefault;
import one.lfa.opdsget.api.OPDSHTTPType;
import one.lfa.opdsget.api.OPDSManifestDescription;
import one.lfa.opdsget.api.OPDSManifestWriterProviderType;
import one.lfa.opdsget.api.OPDSRetrieverProviderType;
import one.lfa.opdsget.api.OPDSRetrieverType;
import one.lfa.opdsget.vanilla.OPDSDocumentProcessor;
import one.lfa.opdsget.vanilla.OPDSHashing;
import one.lfa.opdsget.vanilla.OPDSManifestFileEntryKind;
import one.lfa.opdsget.vanilla.OPDSTaskArchive;
import one.lfa.opdsget.vanilla.OPDSTaskImageScale;
import one.lfa.opdsget.vanilla.OPDSTaskIndex;
import one.lfa.opdsget.vanilla.OPDSTaskSquash;
import one.lfa.opdsget.vanilla.OPDSTaskWriteManifest;
import one.lfa.opdsget.vanilla.OPDSXMLParsers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public final class OPDSRetrievers
implements OPDSRetrieverProviderType {
    private static final Logger LOG = LoggerFactory.getLogger(OPDSRetrievers.class);
    private final OPDSHTTPType http;
    private final OPDSXMLParsers parsers;
    private final EPUBSquasherProviderType squashers;
    private final OPDSManifestWriterProviderType manifestWriters;

    private OPDSRetrievers(EPUBSquasherProviderType in_squashers, OPDSManifestWriterProviderType in_manifest_writers, OPDSHTTPType in_http) {
        this.http = Objects.requireNonNull(in_http, "http");
        this.squashers = Objects.requireNonNull(in_squashers, "squashers");
        this.manifestWriters = Objects.requireNonNull(in_manifest_writers, "in_manifest_writers");
        this.parsers = new OPDSXMLParsers();
    }

    public static OPDSRetrieverProviderType provider() {
        EPUBSquasherProviderType epubSquashers = ServiceLoader.load(EPUBSquasherProviderType.class).findFirst().orElseThrow(() -> new IllegalStateException("No available epub squasher provider"));
        OPDSManifestWriterProviderType manifestWriters = ServiceLoader.load(OPDSManifestWriterProviderType.class).findFirst().orElseThrow(() -> new IllegalStateException("No available manifest writer provider"));
        return new OPDSRetrievers(epubSquashers, manifestWriters, new OPDSHTTPDefault());
    }

    public static OPDSRetrieverProviderType providerWith(EPUBSquasherProviderType in_squashers, OPDSManifestWriterProviderType in_manifest_writers, OPDSHTTPType in_http) {
        return new OPDSRetrievers(in_squashers, in_manifest_writers, in_http);
    }

    @Override
    public OPDSRetrieverType create(ExecutorService executor) {
        return new Retriever(executor, this.parsers, this.http, this.squashers, this.manifestWriters);
    }

    private static final class Retrieval {
        private final EPUBSquasherProviderType squashers;
        private final ExecutorService executor;
        private final HashMap<URI, FileEntry> manifestFiles;
        private final HashSet<URI> retrieved;
        private final Map<URI, OPDSDocumentProcessed> processed;
        private final Object manifestLock;
        private final OPDSGetConfiguration configuration;
        private final OPDSHTTPType http;
        private final OPDSManifestDescription.Builder manifestBuilder;
        private final OPDSManifestWriterProviderType manifestWriters;
        private final OPDSXMLParsers parsers;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Retrieval(OPDSGetConfiguration inConfiguration, ExecutorService inExecutor, OPDSHTTPType inHttp, OPDSXMLParsers inParsers, EPUBSquasherProviderType inSquashers, OPDSManifestWriterProviderType inManifestWriters) {
            this.configuration = Objects.requireNonNull(inConfiguration, "configuration");
            this.executor = Objects.requireNonNull(inExecutor, "executor");
            this.http = Objects.requireNonNull(inHttp, "http");
            this.parsers = Objects.requireNonNull(inParsers, "parsers");
            this.squashers = Objects.requireNonNull(inSquashers, "squashers");
            this.manifestWriters = Objects.requireNonNull(inManifestWriters, "manifestWriters");
            this.retrieved = new HashSet(128);
            this.processed = new HashMap<URI, OPDSDocumentProcessed>(128);
            this.manifestBuilder = OPDSManifestDescription.builder();
            this.manifestBuilder.setBase(this.configuration.outputManifestBaseURI());
            this.manifestFiles = new HashMap(128);
            Object object = this.manifestLock = new Object();
            synchronized (object) {
                this.manifestBuilder.setId(this.configuration.outputManifestID());
            }
        }

        private static Path temporaryFile(Path path) {
            return Paths.get(new StringBuilder(64).append(path.toString()).append(".tmp").toString(), new String[0]);
        }

        private CompletableFuture<Void> processFeed(Optional<OPDSDocumentProcessed> document, URI uri) {
            LOG.debug("processFeed: {}", (Object)uri);
            return CompletableFuture.supplyAsync(() -> this.processOne(document, uri), this.executor).thenComposeAsync(this::runSubTasksIfNecessary, (Executor)ForkJoinPool.commonPool());
        }

        private CompletableFuture<Void> runSubTasksIfNecessary(Optional<OPDSDocumentProcessed> next) {
            return next.map(this::runSubTasks).orElse(CompletableFuture.completedFuture(null));
        }

        private CompletableFuture<Void> runSubTasks(OPDSDocumentProcessed document) {
            List feedTasks = document.feeds().values().stream().map(f -> this.processFeed(Optional.of(document), f.uri())).collect(Collectors.toList());
            List imageTasks = document.images().values().stream().map(f -> this.downloadImageTask(document, f.uri())).collect(Collectors.toList());
            List bookTasks = document.books().values().stream().map(f -> this.downloadBookTask(document, f.uri())).collect(Collectors.toList());
            List<CompletableFuture> tasks = List.of(feedTasks, bookTasks, imageTasks).stream().flatMap(Collection::stream).collect(Collectors.toList());
            return CompletableFuture.allOf(tasks.toArray(new CompletableFuture[tasks.size()]));
        }

        private void downloadFile(URI uri, Path path, Path path_tmp) {
            try {
                Optional<OPDSAuthenticationType> authentication = this.configuration.authenticationSupplier().apply(uri);
                OPDSHTTPData data = this.http.get(uri, authentication);
                Files.createDirectories(path_tmp.getParent(), new FileAttribute[0]);
                try (OutputStream output = Files.newOutputStream(path_tmp, StandardOpenOption.CREATE_NEW);){
                    try (InputStream input = data.stream();){
                        input.transferTo(output);
                        Files.move(path_tmp, path, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                    }
                    this.saveFileInManifest(uri, path, OPDSManifestFileEntryKind.GENERAL);
                }
                catch (FileAlreadyExistsException e) {
                    LOG.debug("file already exists: {}", (Object)path_tmp);
                }
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
        }

        private void downloadImage(OPDSDocumentProcessed document, URI uri) {
            Path path = this.configuration.imageFileHashed(uri);
            Path path_tmp = Retrieval.temporaryFile(path);
            LOG.info("image GET {} -> {} (from {})", uri, path, document.file().uri());
            this.downloadFile(uri, path, path_tmp);
        }

        private CompletableFuture<Void> downloadImageTask(OPDSDocumentProcessed document, URI uri) {
            return CompletableFuture.runAsync(() -> this.downloadImage(document, uri), this.executor);
        }

        private void downloadBook(OPDSDocumentProcessed document, URI uri) {
            Path path = this.configuration.bookFileHashed(uri);
            Path path_tmp = Retrieval.temporaryFile(path);
            LOG.info("book GET {} -> {} (from {})", uri, path, document.file().uri());
            this.downloadFile(uri, path, path_tmp);
        }

        private CompletableFuture<Void> downloadBookTask(OPDSDocumentProcessed document, URI uri) {
            return CompletableFuture.runAsync(() -> this.downloadBook(document, uri), this.executor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Optional<OPDSDocumentProcessed> processOne(Optional<OPDSDocumentProcessed> parent_document, URI uri) {
            try {
                Document document;
                Object object = this.manifestLock;
                synchronized (object) {
                    if (this.retrieved.contains(uri)) {
                        return Optional.empty();
                    }
                    this.retrieved.add(uri);
                }
                LOG.info("feed GET {} {}", (Object)uri, (Object)parent_document.map(doc -> "(from " + doc.file().uri() + ")").orElse(""));
                if (!uri.isAbsolute()) {
                    throw new IllegalArgumentException(String.format("URI %s is not absolute", uri));
                }
                OPDSHTTPData data = this.http.get(uri, this.configuration.authenticationSupplier().apply(uri));
                LOG.debug("processOne: parse: {}", (Object)uri);
                try (InputStream stream = data.stream();){
                    document = this.parsers.parse(uri, stream);
                }
                OPDSDocumentProcessed result = new OPDSDocumentProcessor().process(this.configuration, document);
                Object object2 = this.manifestLock;
                synchronized (object2) {
                    if (this.processed.containsKey(uri)) {
                        throw new IllegalStateException(String.format("URI %s should not already have been processed", uri));
                    }
                    this.processed.put(uri, result);
                }
                boolean isRootFeed = Objects.equals(uri, this.configuration.remoteURI());
                if (isRootFeed) {
                    this.serializeProperties(result);
                }
                Path file = result.file().file();
                LOG.debug("processOne: serialize: {} -> {}", (Object)uri, (Object)file);
                this.serializeFeed(document, result);
                OPDSManifestFileEntryKind entryKind = isRootFeed ? OPDSManifestFileEntryKind.ROOT_FEED : OPDSManifestFileEntryKind.GENERAL;
                this.saveFileInManifest(uri, file, entryKind);
                return Optional.of(result);
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void saveFileInManifest(URI uri, Path file, OPDSManifestFileEntryKind kind) throws IOException {
            Preconditions.checkPreconditionV(file, file.isAbsolute(), "Path %s must be absolute", file);
            Path relative = this.configuration.output().relativize(file);
            String relativeName = relative.toString();
            byte[] hash = OPDSHashing.sha256HashOf(file);
            LOG.debug("manifest: {} -> {}", (Object)uri, (Object)relative);
            Object object = this.manifestLock;
            synchronized (object) {
                FileEntry entry = FileEntry.builder().setHash(hash).setHashAlgorithm("SHA-256").setPath(relativeName).build();
                this.manifestFiles.put(uri, entry);
                switch (kind) {
                    case GENERAL: {
                        break;
                    }
                    case ROOT_FEED: {
                        this.manifestBuilder.setRootFile(relativeName);
                        break;
                    }
                    case SEARCH_INDEX: {
                        this.manifestBuilder.setSearchIndex(relativeName);
                    }
                }
            }
        }

        private void serializeProperties(OPDSDocumentProcessed result) throws IOException {
            Path output = this.configuration.output();
            Path file = output.resolve("info.properties");
            Path file_tmp = Retrieval.temporaryFile(file);
            Files.createDirectories(file_tmp.getParent(), new FileAttribute[0]);
            try (BufferedWriter out = Files.newBufferedWriter(file_tmp, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
                out.append("initial_file = ");
                out.append(output.relativize(result.file().file()).toString());
                out.newLine();
                out.flush();
            }
            Files.move(file_tmp, file, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }

        private void serializeFeed(Document document, OPDSDocumentProcessed result) throws TransformerException, IOException {
            TransformerFactory transformer_factory = TransformerFactory.newInstance();
            Transformer transformer = transformer_factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            Path path = result.file().file();
            Path path_tmp = Retrieval.temporaryFile(path);
            Files.createDirectories(path_tmp.getParent(), new FileAttribute[0]);
            try (OutputStream output = Files.newOutputStream(path_tmp, StandardOpenOption.CREATE_NEW);){
                transformer.transform(new DOMSource(document), new StreamResult(output));
                Files.move(path_tmp, path, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (FileAlreadyExistsException e) {
                LOG.debug("file already exists: {}", (Object)path_tmp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Map<URI, OPDSDocumentProcessed> processed() {
            Object object = this.manifestLock;
            synchronized (object) {
                return Map.copyOf(this.processed);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        OPDSManifestDescription manifest() {
            Object object = this.manifestLock;
            synchronized (object) {
                this.manifestBuilder.putAllFiles(this.manifestFiles);
                return this.manifestBuilder.build();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onFileChanged(OPDSManifestFileEntryKind kind, Path path) {
            LOG.debug("onFileChanged: {} {}", (Object)kind, (Object)path);
            Preconditions.checkPreconditionV(path, path.isAbsolute(), "Path %s must be absolute", path);
            String relativeFile = this.configuration.output().relativize(path).toString();
            Object object = this.manifestLock;
            synchronized (object) {
                for (Map.Entry<URI, FileEntry> entry : this.manifestFiles.entrySet()) {
                    URI uri = entry.getKey();
                    FileEntry file = entry.getValue();
                    if (!Objects.equals(file.path(), relativeFile)) continue;
                    LOG.debug("onFileChanged: found existing file for {} ({})", (Object)path, (Object)uri);
                    try {
                        this.saveFileInManifest(uri, path, kind);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    return;
                }
                try {
                    LOG.debug("onFileChanged: could not find existing file for {}", (Object)path);
                    this.saveFileInManifest(URI.create(path.getFileName().toString()), path, kind);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
    }

    private static final class Retriever
    implements OPDSRetrieverType {
        private final ExecutorService executor;
        private final OPDSHTTPType http;
        private final EPUBSquasherProviderType squashers;
        private final OPDSManifestWriterProviderType manifestWriters;
        private final OPDSXMLParsers parsers;

        Retriever(ExecutorService in_executor, OPDSXMLParsers in_parsers, OPDSHTTPType in_http, EPUBSquasherProviderType in_squashers, OPDSManifestWriterProviderType inManifestWriters) {
            this.executor = Objects.requireNonNull(in_executor, "executor");
            this.parsers = Objects.requireNonNull(in_parsers, "parsers");
            this.http = Objects.requireNonNull(in_http, "http");
            this.squashers = Objects.requireNonNull(in_squashers, "squashers");
            this.manifestWriters = Objects.requireNonNull(inManifestWriters, "inManifestWriters");
        }

        @Override
        public CompletableFuture<Void> retrieve(OPDSGetConfiguration config) {
            Objects.requireNonNull(config, "configuration");
            Retrieval retrieval = new Retrieval(config, this.executor, this.http, this.parsers, this.squashers, this.manifestWriters);
            Function<Void, CompletionStage> indexTask = ignored -> OPDSTaskIndex.task(config, retrieval.processed(), retrieval::onFileChanged, this.executor);
            Function<Void, CompletionStage> squashTask = ignored -> OPDSTaskSquash.task(config, this.squashers, retrieval::onFileChanged, this.executor);
            Function<Void, CompletionStage> imageScaleTask = ignored -> OPDSTaskImageScale.task(config, retrieval::onFileChanged, this.executor);
            Function<Void, CompletionStage> manifestWriteTask = ignored -> OPDSTaskWriteManifest.task(config, this.manifestWriters, retrieval.manifest(), this.executor);
            Function<Void, CompletionStage> archiveTask = ignored -> OPDSTaskArchive.task(config, this.executor);
            return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)retrieval.processFeed(Optional.empty(), config.remoteURI()).thenCompose(indexTask)).thenCompose(squashTask)).thenCompose(imageScaleTask)).thenCompose(manifestWriteTask)).thenCompose(archiveTask);
        }
    }
}

