/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jxe.core;

import com.io7m.jxe.core.JXEHardenedDispatchingResolver;
import com.io7m.jxe.core.JXESchemaResolutionMappings;
import com.io7m.jxe.core.JXEXInclude;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class JXEHardenedSAXParsers {
    private final SAXParserFactory parsers = SAXParserFactory.newInstance();

    public XMLReader createXMLReaderNonValidating(Optional<Path> base_directory, JXEXInclude xinclude) throws ParserConfigurationException, SAXException {
        Objects.requireNonNull(base_directory, "Base directory");
        Objects.requireNonNull(xinclude, "xinclude");
        SAXParser parser = this.parsers.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        reader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        reader.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        reader.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        reader.setFeature("http://apache.org/xml/features/xinclude", xinclude == JXEXInclude.XINCLUDE_ENABLED);
        reader.setFeature("http://xml.org/sax/features/namespaces", true);
        reader.setFeature("http://xml.org/sax/features/validation", false);
        reader.setFeature("http://apache.org/xml/features/validation/schema", false);
        reader.setFeature("http://xml.org/sax/features/use-entity-resolver2", true);
        reader.setEntityResolver(JXEHardenedDispatchingResolver.create(base_directory, JXESchemaResolutionMappings.builder().build()));
        return reader;
    }

    public XMLReader createXMLReader(Optional<Path> base_directory, JXEXInclude xinclude, JXESchemaResolutionMappings in_schemas) throws ParserConfigurationException, SAXException {
        Objects.requireNonNull(base_directory, "Base directory");
        Objects.requireNonNull(xinclude, "xinclude");
        Objects.requireNonNull(in_schemas, "Schemas");
        SAXParser parser = this.parsers.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        reader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        reader.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "file");
        reader.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        reader.setFeature("http://apache.org/xml/features/xinclude", xinclude == JXEXInclude.XINCLUDE_ENABLED);
        reader.setFeature("http://xml.org/sax/features/namespaces", true);
        reader.setFeature("http://xml.org/sax/features/validation", true);
        reader.setFeature("http://apache.org/xml/features/validation/schema", true);
        StringBuilder locations = new StringBuilder(128);
        in_schemas.mappings().forEach((uri, schema) -> {
            locations.append(uri);
            locations.append(' ');
            locations.append(schema.fileIdentifier());
            locations.append(' ');
        });
        reader.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", locations.toString());
        reader.setFeature("http://xml.org/sax/features/use-entity-resolver2", true);
        reader.setEntityResolver(JXEHardenedDispatchingResolver.create(base_directory, in_schemas));
        return reader;
    }
}

