/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.color;

import com.twelvemonkeys.lang.Validate;
import java.awt.Point;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

public final class DiscreteAlphaIndexColorModel
extends ColorModel {
    private final IndexColorModel icm;

    public DiscreteAlphaIndexColorModel(IndexColorModel indexColorModel) {
        super(Validate.notNull(indexColorModel, "IndexColorModel").getPixelSize() * 2, new int[]{indexColorModel.getPixelSize(), indexColorModel.getPixelSize(), indexColorModel.getPixelSize(), indexColorModel.getPixelSize()}, indexColorModel.getColorSpace(), true, false, 3, indexColorModel.getTransferType());
        this.icm = indexColorModel;
    }

    @Override
    public final int getRed(int n) {
        return this.icm.getRed(n);
    }

    @Override
    public final int getGreen(int n) {
        return this.icm.getGreen(n);
    }

    @Override
    public final int getBlue(int n) {
        return this.icm.getBlue(n);
    }

    @Override
    public final int getAlpha(int n) {
        return (int)((float)n / (float)((1 << this.getComponentSize(3)) - 1) * 255.0f + 0.5f);
    }

    private int getSample(Object object, int n) {
        int n2;
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n2 = byArray[n] & 0xFF;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n2 = sArray[n] & 0xFFFF;
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                n2 = nArray[n];
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        return n2;
    }

    @Override
    public final int getRed(Object object) {
        return this.getRed(this.getSample(object, 0));
    }

    @Override
    public final int getGreen(Object object) {
        return this.getGreen(this.getSample(object, 0));
    }

    @Override
    public final int getBlue(Object object) {
        return this.getBlue(this.getSample(object, 0));
    }

    @Override
    public final int getAlpha(Object object) {
        return this.getAlpha(this.getSample(object, 1));
    }

    @Override
    public final SampleModel createCompatibleSampleModel(int n, int n2) {
        return new PixelInterleavedSampleModel(this.transferType, n, n2, 2, n * 2, new int[]{0, 1});
    }

    @Override
    public final boolean isCompatibleSampleModel(SampleModel sampleModel) {
        return sampleModel instanceof PixelInterleavedSampleModel && sampleModel.getNumBands() == 2;
    }

    @Override
    public final WritableRaster createCompatibleWritableRaster(int n, int n2) {
        return Raster.createWritableRaster(this.createCompatibleSampleModel(n, n2), new Point(0, 0));
    }

    @Override
    public final boolean isCompatibleRaster(Raster raster) {
        int n = raster.getSampleModel().getSampleSize(0);
        return raster.getTransferType() == this.transferType && raster.getNumBands() == 2 && 1 << n >= this.icm.getMapSize();
    }

    @Override
    public String toString() {
        return "DiscreteAlphaIndexColorModel: #pixelBits = " + this.pixel_bits + " numComponents = " + this.getNumComponents() + " color space = " + this.getColorSpace() + " transparency = " + this.getTransparency() + " has alpha = " + this.hasAlpha() + " isAlphaPre = " + this.isAlphaPremultiplied();
    }
}

