/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.opdsget.api;

import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import one.lfa.opdsget.api.OPDSLocalFileType;
import org.immutables.value.Generated;

@Generated(from="OPDSLocalFileType", generator="Immutables")
public final class OPDSLocalFile
implements OPDSLocalFileType {
    private final URI uri;
    private final Path file;

    private OPDSLocalFile(URI uri, Path file) {
        this.uri = Objects.requireNonNull(uri, "uri");
        this.file = Objects.requireNonNull(file, "file");
    }

    private OPDSLocalFile(Builder builder) {
        this.uri = builder.uri;
        this.file = builder.file;
    }

    @Override
    public URI uri() {
        return this.uri;
    }

    @Override
    public Path file() {
        return this.file;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof OPDSLocalFile && this.equalTo((OPDSLocalFile)another);
    }

    private boolean equalTo(OPDSLocalFile another) {
        return this.uri.equals(another.uri) && this.file.equals(another.file);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.uri.hashCode();
        h += (h << 5) + this.file.hashCode();
        return h;
    }

    public String toString() {
        return "OPDSLocalFile{uri=" + this.uri + ", file=" + this.file + "}";
    }

    public static OPDSLocalFile of(URI uri, Path file) {
        return new OPDSLocalFile(uri, file);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OPDSLocalFileType", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_URI = 1L;
        private static final long INIT_BIT_FILE = 2L;
        private long initBits = 3L;
        private URI uri;
        private Path file;

        private Builder() {
        }

        public final Builder from(OPDSLocalFileType instance) {
            Objects.requireNonNull(instance, "instance");
            this.setUri(instance.uri());
            this.setFile(instance.file());
            return this;
        }

        public final Builder setUri(URI uri) {
            this.uri = Objects.requireNonNull(uri, "uri");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setFile(Path file) {
            this.file = Objects.requireNonNull(file, "file");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public OPDSLocalFile build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new OPDSLocalFile(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("uri");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("file");
            }
            return "Cannot build OPDSLocalFile, some of required attributes are not set " + attributes;
        }
    }
}

