/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.blackthorne.api;

import com.io7m.blackthorne.api.BTContentHandlerBuilderType;
import com.io7m.blackthorne.api.BTElementHandlerConstructorType;
import com.io7m.blackthorne.api.BTParseError;
import com.io7m.blackthorne.api.BTParseErrorType;
import com.io7m.blackthorne.api.BTQualifiedName;
import com.io7m.blackthorne.api.BTStackHandler;
import com.io7m.jlexing.core.LexicalPosition;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.ext.Locator2;

public final class BTContentHandler<T>
extends DefaultHandler2 {
    private final URI fileURI;
    private final Consumer<BTParseError> errorReceiver;
    private Locator2 locator;
    private Map<BTQualifiedName, BTElementHandlerConstructorType<?, T>> rootHandlers;
    private BTStackHandler<T> stackHandler;
    private boolean failed;

    public BTContentHandler(URI inFileURI, Consumer<BTParseError> inErrorReceiver, Map<BTQualifiedName, BTElementHandlerConstructorType<?, T>> inRootHandlers) {
        this.fileURI = Objects.requireNonNull(inFileURI, "fileURI");
        this.errorReceiver = Objects.requireNonNull(inErrorReceiver, "errorReceiver");
        this.rootHandlers = Map.copyOf(Objects.requireNonNull(inRootHandlers, "handlers"));
    }

    public static <U> BTContentHandlerBuilderType<U> builder() {
        return new Builder();
    }

    public static <U> BTContentHandlerBuilderType<U> builder(Class<U> clazz) {
        return new Builder();
    }

    @Override
    public void setDocumentLocator(Locator in_locator) {
        this.locator = (Locator2)Objects.requireNonNull(in_locator, "locator");
        this.stackHandler = new BTStackHandler<T>(this.locator, this.rootHandlers);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        try {
            this.stackHandler.onElementStarted(namespaceURI, localName, attributes);
        }
        catch (SAXParseException e) {
            this.error(e);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
        try {
            this.stackHandler.onElementFinished(namespaceURI, localName);
        }
        catch (SAXParseException e) {
            this.error(e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.stackHandler.onCharacters(ch, start, length);
        }
        catch (SAXParseException e) {
            this.error(e);
        }
    }

    @Override
    public void warning(SAXParseException e) {
        this.errorReceiver.accept(BTParseError.builder().setException(e).setSeverity(BTParseErrorType.Severity.WARNING).setMessage(e.getMessage()).setLexical(LexicalPosition.builder().setColumn(this.locator.getColumnNumber()).setLine(this.locator.getLineNumber()).setFile(this.fileURI).build()).build());
    }

    @Override
    public void error(SAXParseException e) {
        this.failed = true;
        this.errorReceiver.accept(BTParseError.builder().setException(e).setSeverity(BTParseErrorType.Severity.ERROR).setMessage(e.getMessage()).setLexical(LexicalPosition.builder().setColumn(this.locator.getColumnNumber()).setLine(this.locator.getLineNumber()).setFile(this.fileURI).build()).build());
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.failed = true;
        this.errorReceiver.accept(BTParseError.builder().setException(e).setSeverity(BTParseErrorType.Severity.ERROR).setMessage(e.getMessage()).setLexical(LexicalPosition.builder().setColumn(this.locator.getColumnNumber()).setLine(this.locator.getLineNumber()).setFile(this.fileURI).build()).build());
        throw e;
    }

    public Optional<? extends T> result() {
        return this.stackHandler.result();
    }

    public boolean failed() {
        return this.failed;
    }

    private static final class Builder<U>
    implements BTContentHandlerBuilderType<U> {
        private final HashMap<BTQualifiedName, BTElementHandlerConstructorType<?, U>> handlers = new HashMap(16);

        private Builder() {
        }

        @Override
        public BTContentHandlerBuilderType<U> addHandler(BTQualifiedName name, BTElementHandlerConstructorType<?, U> constructor) {
            this.handlers.put(Objects.requireNonNull(name, "name"), Objects.requireNonNull(constructor, "constructor"));
            return this;
        }

        @Override
        public BTContentHandler<U> build(URI fileURI, Consumer<BTParseError> errorConsumer) {
            return new BTContentHandler(Objects.requireNonNull(fileURI, "fileURI"), Objects.requireNonNull(errorConsumer, "errorConsumer"), Map.copyOf(this.handlers));
        }
    }
}

