/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.blackthorne.api;

import com.io7m.blackthorne.api.BTParseErrorType;
import com.io7m.jlexing.core.LexicalPosition;
import java.net.URI;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;

public final class BTParseError
implements BTParseErrorType {
    private final LexicalPosition<URI> lexical;
    private final BTParseErrorType.Severity severity;
    private final String message;
    private final Exception exception;

    private BTParseError(LexicalPosition<URI> lexical, BTParseErrorType.Severity severity, String message, Exception exception) {
        this.lexical = lexical;
        this.severity = severity;
        this.message = message;
        this.exception = exception;
    }

    @Override
    public LexicalPosition<URI> lexical() {
        return this.lexical;
    }

    @Override
    public BTParseErrorType.Severity severity() {
        return this.severity;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    public Optional<Exception> exception() {
        return Optional.ofNullable(this.exception);
    }

    public final BTParseError withLexical(LexicalPosition<URI> value) {
        if (this.lexical == value) {
            return this;
        }
        LexicalPosition<URI> newValue = Objects.requireNonNull(value, "lexical");
        return new BTParseError(newValue, this.severity, this.message, this.exception);
    }

    public final BTParseError withSeverity(BTParseErrorType.Severity value) {
        if (this.severity == value) {
            return this;
        }
        BTParseErrorType.Severity newValue = Objects.requireNonNull(value, "severity");
        if (this.severity.equals((Object)newValue)) {
            return this;
        }
        return new BTParseError(this.lexical, newValue, this.message, this.exception);
    }

    public final BTParseError withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new BTParseError(this.lexical, this.severity, newValue, this.exception);
    }

    public final BTParseError withException(Exception value) {
        Exception newValue = Objects.requireNonNull(value, "exception");
        if (this.exception == newValue) {
            return this;
        }
        return new BTParseError(this.lexical, this.severity, this.message, newValue);
    }

    public final BTParseError withException(Optional<? extends Exception> optional) {
        Exception value = optional.orElse(null);
        if (this.exception == value) {
            return this;
        }
        return new BTParseError(this.lexical, this.severity, this.message, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BTParseError && this.equalTo((BTParseError)another);
    }

    private boolean equalTo(BTParseError another) {
        return this.lexical.equals(another.lexical) && this.severity.equals((Object)another.severity) && this.message.equals(another.message) && Objects.equals(this.exception, another.exception);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.lexical.hashCode();
        h += (h << 5) + this.severity.hashCode();
        h += (h << 5) + this.message.hashCode();
        h += (h << 5) + Objects.hashCode(this.exception);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("BTParseError{");
        builder.append("lexical=").append(this.lexical);
        builder.append(", ");
        builder.append("severity=").append((Object)this.severity);
        builder.append(", ");
        builder.append("message=").append(this.message);
        if (this.exception != null) {
            builder.append(", ");
            builder.append("exception=").append(this.exception);
        }
        return builder.append("}").toString();
    }

    public static BTParseError copyOf(BTParseErrorType instance) {
        if (instance instanceof BTParseError) {
            return (BTParseError)instance;
        }
        return BTParseError.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_LEXICAL = 1L;
        private static final long INIT_BIT_SEVERITY = 2L;
        private static final long INIT_BIT_MESSAGE = 4L;
        private long initBits = 7L;
        private LexicalPosition<URI> lexical;
        private BTParseErrorType.Severity severity;
        private String message;
        private Exception exception;

        private Builder() {
        }

        public final Builder from(BTParseErrorType instance) {
            Objects.requireNonNull(instance, "instance");
            this.setLexical(instance.lexical());
            this.setSeverity(instance.severity());
            this.setMessage(instance.message());
            Optional<Exception> exceptionOptional = instance.exception();
            if (exceptionOptional.isPresent()) {
                this.setException(exceptionOptional);
            }
            return this;
        }

        public final Builder setLexical(LexicalPosition<URI> lexical) {
            this.lexical = Objects.requireNonNull(lexical, "lexical");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setSeverity(BTParseErrorType.Severity severity) {
            this.severity = Objects.requireNonNull(severity, "severity");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setMessage(String message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setException(Exception exception) {
            this.exception = Objects.requireNonNull(exception, "exception");
            return this;
        }

        public final Builder setException(Optional<? extends Exception> exception) {
            this.exception = exception.orElse(null);
            return this;
        }

        public BTParseError build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new BTParseError(this.lexical, this.severity, this.message, this.exception);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("lexical");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("severity");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("message");
            }
            return "Cannot build BTParseError, some of required attributes are not set " + attributes;
        }
    }
}

