/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.blackthorne.api;

import com.io7m.blackthorne.api.BTAttributesHandlerType;
import com.io7m.blackthorne.api.BTCharacterHandlerType;
import com.io7m.blackthorne.api.BTElementHandlerConstructorType;
import com.io7m.blackthorne.api.BTElementHandlerType;
import com.io7m.blackthorne.api.BTIgnoreUnrecognizedElements;
import com.io7m.blackthorne.api.BTListMonoHandler;
import com.io7m.blackthorne.api.BTListPolyHandler;
import com.io7m.blackthorne.api.BTQualifiedName;
import com.io7m.blackthorne.api.BTScalarAttributeHandler;
import com.io7m.blackthorne.api.BTScalarElementHandler;
import com.io7m.junreachable.UnreachableCodeException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public final class Blackthorne {
    private Blackthorne() {
        throw new UnreachableCodeException();
    }

    public static <CT, RT, RX> BTElementHandlerType<CT, RX> map(BTElementHandlerType<CT, RT> handler, Function<RT, RX> function) {
        return handler.map(function);
    }

    public static <CT, RT, RX extends RT> BTElementHandlerType<CT, RT> widen(BTElementHandlerType<CT, RX> handler) {
        return handler;
    }

    public static <CT, RT, RX> BTElementHandlerConstructorType<CT, RX> mapConstructor(BTElementHandlerConstructorType<CT, RT> constructor, Function<RT, RX> function) {
        return context -> {
            BTElementHandlerType newHandler = constructor.create(context);
            return Blackthorne.map(newHandler, function);
        };
    }

    public static <CT, RT, RX extends RT> BTElementHandlerConstructorType<CT, RT> widenConstructor(BTElementHandlerConstructorType<CT, RX> constructor) {
        return constructor;
    }

    public static <S> BTElementHandlerConstructorType<?, S> forScalar(BTQualifiedName elementName, BTCharacterHandlerType<S> parser) {
        Objects.requireNonNull(elementName, "elementName");
        Objects.requireNonNull(parser, "parser");
        return context -> new BTScalarElementHandler(elementName, parser);
    }

    public static <S> BTElementHandlerConstructorType<?, S> forScalar(String namespaceURI, String localName, BTCharacterHandlerType<S> parser) {
        Objects.requireNonNull(namespaceURI, "namespaceURI");
        Objects.requireNonNull(localName, "localName");
        Objects.requireNonNull(parser, "parser");
        return Blackthorne.forScalar(BTQualifiedName.of(namespaceURI, localName), parser);
    }

    public static <S> BTElementHandlerConstructorType<?, S> forScalarAttribute(BTQualifiedName elementName, BTAttributesHandlerType<S> parser) {
        Objects.requireNonNull(elementName, "elementName");
        Objects.requireNonNull(parser, "parser");
        return context -> new BTScalarAttributeHandler(elementName, parser);
    }

    public static <S> BTElementHandlerConstructorType<?, S> forScalarAttribute(String namespaceURI, String localName, BTAttributesHandlerType<S> parser) {
        Objects.requireNonNull(namespaceURI, "namespaceURI");
        Objects.requireNonNull(localName, "localName");
        Objects.requireNonNull(parser, "parser");
        return Blackthorne.forScalarAttribute(BTQualifiedName.of(namespaceURI, localName), parser);
    }

    public static <S> BTElementHandlerConstructorType<S, List<S>> forListMono(BTQualifiedName elementName, BTQualifiedName childElementName, BTElementHandlerConstructorType<?, ? extends S> itemHandler, BTIgnoreUnrecognizedElements ignoreUnrecognized) {
        Objects.requireNonNull(elementName, "elementName");
        Objects.requireNonNull(childElementName, "childElementName");
        Objects.requireNonNull(itemHandler, "itemHandler");
        return context -> new BTListMonoHandler(elementName, childElementName, itemHandler, ignoreUnrecognized);
    }

    public static <S> BTElementHandlerConstructorType<S, List<S>> forListPoly(BTQualifiedName elementName, Map<BTQualifiedName, BTElementHandlerConstructorType<?, ? extends S>> itemHandlers, BTIgnoreUnrecognizedElements ignoreUnrecognized) {
        Objects.requireNonNull(elementName, "elementName");
        Objects.requireNonNull(itemHandlers, "itemHandlers");
        return context -> new BTListPolyHandler(elementName, itemHandlers, ignoreUnrecognized);
    }
}

