/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jlexing.core;

import com.io7m.jlexing.core.LexicalPositionType;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;

public final class LexicalPosition<F>
implements LexicalPositionType<F> {
    private final int line;
    private final int column;
    private final F file;

    private LexicalPosition(int line, int column, Optional<? extends F> file) {
        this.line = line;
        this.column = column;
        this.file = file.orElse(null);
    }

    private LexicalPosition(LexicalPosition original, int line, int column, F file) {
        this.line = line;
        this.column = column;
        this.file = file;
    }

    @Override
    public int line() {
        return this.line;
    }

    @Override
    public int column() {
        return this.column;
    }

    @Override
    public Optional<F> file() {
        return Optional.ofNullable(this.file);
    }

    public final LexicalPosition<F> withLine(int value) {
        if (this.line == value) {
            return this;
        }
        return new LexicalPosition<F>(this, value, this.column, this.file);
    }

    public final LexicalPosition<F> withColumn(int value) {
        if (this.column == value) {
            return this;
        }
        return new LexicalPosition<F>(this, this.line, value, this.file);
    }

    public final LexicalPosition<F> withFile(F value) {
        F newValue = Objects.requireNonNull(value, "file");
        if (this.file == newValue) {
            return this;
        }
        return new LexicalPosition<F>(this, this.line, this.column, newValue);
    }

    public final LexicalPosition<F> withFile(Optional<? extends F> optional) {
        F value = optional.orElse(null);
        if (this.file == value) {
            return this;
        }
        return new LexicalPosition<Object>(this, this.line, this.column, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof LexicalPosition && this.equalTo((LexicalPosition)another);
    }

    private boolean equalTo(LexicalPosition<F> another) {
        return this.line == another.line && this.column == another.column && Objects.equals(this.file, another.file);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.line;
        h += (h << 5) + this.column;
        h += (h << 5) + Objects.hashCode(this.file);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("LexicalPosition{");
        builder.append("line=").append(this.line);
        builder.append(", ");
        builder.append("column=").append(this.column);
        if (this.file != null) {
            builder.append(", ");
            builder.append("file=").append(this.file);
        }
        return builder.append("}").toString();
    }

    public static <F> LexicalPosition<F> of(int line, int column, Optional<? extends F> file) {
        return new LexicalPosition<F>(line, column, file);
    }

    public static <F> LexicalPosition<F> copyOf(LexicalPositionType<F> instance) {
        if (instance instanceof LexicalPosition) {
            return (LexicalPosition)instance;
        }
        return LexicalPosition.builder().from(instance).build();
    }

    public static <F> Builder<F> builder() {
        return new Builder();
    }

    public static final class Builder<F> {
        private static final long INIT_BIT_LINE = 1L;
        private static final long INIT_BIT_COLUMN = 2L;
        private long initBits = 3L;
        private int line;
        private int column;
        private F file;

        private Builder() {
        }

        public final Builder<F> from(LexicalPositionType<F> instance) {
            Objects.requireNonNull(instance, "instance");
            this.setLine(instance.line());
            this.setColumn(instance.column());
            Optional<F> fileOptional = instance.file();
            if (fileOptional.isPresent()) {
                this.setFile(fileOptional);
            }
            return this;
        }

        public final Builder<F> setLine(int line) {
            this.line = line;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<F> setColumn(int column) {
            this.column = column;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder<F> setFile(F file) {
            this.file = Objects.requireNonNull(file, "file");
            return this;
        }

        public final Builder<F> setFile(Optional<? extends F> file) {
            this.file = file.orElse(null);
            return this;
        }

        public LexicalPosition<F> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new LexicalPosition(null, this.line, this.column, this.file);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("line");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("column");
            }
            return "Cannot build LexicalPosition, some of required attributes are not set " + attributes;
        }
    }
}

