/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.opdsget.api;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import one.lfa.opdsget.api.OPDSAuthenticationBasic;
import one.lfa.opdsget.api.OPDSAuthenticationPatternMapped;
import one.lfa.opdsget.api.OPDSAuthenticationType;
import one.lfa.opdsget.api.OPDSMatchingAuthentication;

public final class OPDSAuthenticationPatternMappedParser {
    private static final Pattern WHITESPACE = Pattern.compile("\\s+");

    private OPDSAuthenticationPatternMappedParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static OPDSAuthenticationPatternMapped parse(URI file, InputStream stream) throws IOException, ParseException {
        Objects.requireNonNull(file, "file");
        Objects.requireNonNull(stream, "stream");
        ArrayList<OPDSMatchingAuthentication> patterns = new ArrayList<OPDSMatchingAuthentication>(8);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            int line_number = 1;
            while (true) {
                try {
                    while (true) {
                        String trimmed;
                        String line;
                        if ((line = reader.readLine()) == null) {
                            OPDSAuthenticationPatternMapped oPDSAuthenticationPatternMapped = OPDSAuthenticationPatternMapped.of(patterns);
                            return oPDSAuthenticationPatternMapped;
                        }
                        if (line.startsWith("#") || (trimmed = line.trim()).isEmpty()) continue;
                        List<String> segments = List.of(WHITESPACE.split(trimmed));
                        if (segments.size() != 2) {
                            throw OPDSAuthenticationPatternMappedParser.syntaxError(file, line_number, "<pattern> ( <authentication-value> | 'none' )", line);
                        }
                        Pattern pattern = Pattern.compile(segments.get(0));
                        Optional<OPDSAuthenticationType> auth = OPDSAuthenticationPatternMappedParser.parseAuthentication(file, line_number, segments.get(1));
                        patterns.add(OPDSMatchingAuthentication.of(pattern.pattern(), auth));
                    }
                }
                finally {
                    ++line_number;
                    continue;
                }
                break;
            }
        }
    }

    private static Optional<OPDSAuthenticationType> parseAuthentication(URI file, int line_number, String text) throws ParseException {
        if (text.endsWith("none")) {
            return Optional.empty();
        }
        if (text.startsWith("basic:")) {
            List<String> segments = List.of(text.split(":"));
            if (segments.size() != 3) {
                throw OPDSAuthenticationPatternMappedParser.syntaxError(file, line_number, "'basic' , ':' , <username> , ':' , <password>", text);
            }
            return Optional.of(OPDSAuthenticationBasic.of(segments.get(1), segments.get(2)));
        }
        throw OPDSAuthenticationPatternMappedParser.syntaxError(file, line_number, "( <authentication-value> | 'none' )", text);
    }

    private static ParseException syntaxError(URI uri, int line_number, String expected, String received) {
        return new ParseException(new StringBuilder(64).append(uri).append(":").append(line_number).append(": Parse error.").append(System.lineSeparator()).append("  Expected: ").append(expected).append(System.lineSeparator()).append("  Received: ").append(received).toString(), line_number);
    }
}

