/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.opdsget.vanilla;

import java.io.BufferedWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.regex.Pattern;
import one.lfa.opdsget.api.OPDSDocumentProcessed;
import one.lfa.opdsget.api.OPDSGetConfiguration;
import one.lfa.opdsget.api.OPDSURIRewriterType;
import one.lfa.opdsget.vanilla.OPDSManifestChangeRequiredType;
import one.lfa.opdsget.vanilla.OPDSManifestFileEntryKind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OPDSTaskIndex {
    private static final Logger LOG = LoggerFactory.getLogger(OPDSTaskIndex.class);
    private static final Pattern WHITESPACE = Pattern.compile("\\s+");
    private static final Pattern NOT_UPPERCASE_ALPHA_NUMERIC = Pattern.compile("[^\\p{Lu}\\p{Digit}]+");
    private final OPDSGetConfiguration configuration;
    private final OPDSManifestChangeRequiredType onChangeRequired;
    private final Map<URI, OPDSDocumentProcessed> processed;

    private OPDSTaskIndex(OPDSGetConfiguration inConfiguration, OPDSManifestChangeRequiredType inOnChangeRequired, Map<URI, OPDSDocumentProcessed> inProcessed) {
        this.configuration = Objects.requireNonNull(inConfiguration, "configuration");
        this.onChangeRequired = Objects.requireNonNull(inOnChangeRequired, "onChangeRequired");
        this.processed = Objects.requireNonNull(inProcessed, "processed");
    }

    public static CompletionStage<Void> task(OPDSGetConfiguration configuration, Map<URI, OPDSDocumentProcessed> processed, OPDSManifestChangeRequiredType onChangeRequired, ExecutorService executor) {
        return CompletableFuture.runAsync(() -> new OPDSTaskIndex(configuration, onChangeRequired, processed).execute(), executor);
    }

    private void execute() {
        LOG.debug("executing indexing task");
        try {
            OPDSURIRewriterType rewriter = this.configuration.uriRewriter();
            TreeMap index = new TreeMap();
            for (Map.Entry<URI, OPDSDocumentProcessed> mapEntry : this.processed.entrySet()) {
                OPDSDocumentProcessed document = mapEntry.getValue();
                if (!document.isEntry()) continue;
                List<String> terms = List.of(WHITESPACE.split(document.title().toUpperCase()));
                for (String term : terms) {
                    String termTrimmed = term.trim().replaceAll(NOT_UPPERCASE_ALPHA_NUMERIC.pattern(), "");
                    if (termTrimmed.isBlank()) continue;
                    ArrayList<URI> uris = (ArrayList<URI>)index.get(termTrimmed);
                    if (uris == null) {
                        uris = new ArrayList<URI>(8);
                    }
                    URI rewriteURI = rewriter.rewrite(Optional.empty(), document.file());
                    uris.add(rewriteURI);
                    index.put(termTrimmed, uris);
                }
            }
            Path indexPath = this.configuration.output().resolve("index.txt");
            LOG.info("index {}", (Object)indexPath);
            try (BufferedWriter writer = Files.newBufferedWriter(indexPath, StandardCharsets.UTF_8, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
                for (String term : index.keySet()) {
                    for (URI uri : (List)index.get(term)) {
                        writer.append(term);
                        writer.append(" ");
                        writer.append(uri.toString());
                        writer.newLine();
                    }
                }
                writer.flush();
            }
            this.onChangeRequired.onFileChanged(OPDSManifestFileEntryKind.SEARCH_INDEX, indexPath);
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }
}

