/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.opdsget.vanilla;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import one.lfa.opdsget.api.OPDSGetConfiguration;
import one.lfa.opdsget.api.OPDSManifestDescription;
import one.lfa.opdsget.api.OPDSManifestWriterProviderType;
import one.lfa.opdsget.api.OPDSManifestWriterType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OPDSTaskWriteManifest {
    private static final Logger LOG = LoggerFactory.getLogger(OPDSTaskWriteManifest.class);
    private final OPDSGetConfiguration configuration;
    private final OPDSManifestWriterProviderType manifestWriters;
    private final OPDSManifestDescription manifest;

    private OPDSTaskWriteManifest(OPDSGetConfiguration inConfiguration, OPDSManifestWriterProviderType inManifestWriters, OPDSManifestDescription inManifest) {
        this.configuration = Objects.requireNonNull(inConfiguration, "configuration");
        this.manifestWriters = Objects.requireNonNull(inManifestWriters, "manifestWriters");
        this.manifest = Objects.requireNonNull(inManifest, "manifest");
    }

    public static CompletionStage<Void> task(OPDSGetConfiguration configuration, OPDSManifestWriterProviderType manifestWriters, OPDSManifestDescription inManifest, ExecutorService executor) {
        return CompletableFuture.runAsync(() -> new OPDSTaskWriteManifest(configuration, manifestWriters, inManifest).execute(), executor);
    }

    private void execute() {
        LOG.debug("executing manifest writing task");
        Path manifestPath = this.configuration.output().resolve("manifest.xml");
        LOG.info("manifest file {}", (Object)manifestPath);
        try (OutputStream stream = Files.newOutputStream(manifestPath, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
             OPDSManifestWriterType writer = this.manifestWriters.createWriter(this.manifest, stream);){
            writer.write();
            stream.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

