/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.blackthorne.api;

import com.io7m.blackthorne.api.BTAttributesHandlerType;
import com.io7m.blackthorne.api.BTCharacterHandlerType;
import com.io7m.blackthorne.api.BTContentHandler;
import com.io7m.blackthorne.api.BTElementHandlerConstructorType;
import com.io7m.blackthorne.api.BTElementHandlerType;
import com.io7m.blackthorne.api.BTException;
import com.io7m.blackthorne.api.BTIgnoreUnrecognizedElements;
import com.io7m.blackthorne.api.BTListMonoHandler;
import com.io7m.blackthorne.api.BTListPolyHandler;
import com.io7m.blackthorne.api.BTParseError;
import com.io7m.blackthorne.api.BTParseErrorType;
import com.io7m.blackthorne.api.BTQualifiedName;
import com.io7m.blackthorne.api.BTScalarAttributeHandler;
import com.io7m.blackthorne.api.BTScalarElementHandler;
import com.io7m.jlexing.core.LexicalPosition;
import com.io7m.junreachable.UnreachableCodeException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public final class Blackthorne {
    private static final Logger LOG = LoggerFactory.getLogger(Blackthorne.class);

    private Blackthorne() {
        throw new UnreachableCodeException();
    }

    public static <CT, RT, RX> BTElementHandlerType<CT, RX> map(BTElementHandlerType<CT, RT> handler, Function<RT, RX> function) {
        return handler.map(function);
    }

    public static <CT, RT, RX extends RT> BTElementHandlerType<CT, RT> widen(BTElementHandlerType<CT, RX> handler) {
        return handler;
    }

    public static <CT, RT, RX> BTElementHandlerConstructorType<CT, RX> mapConstructor(BTElementHandlerConstructorType<CT, RT> constructor, Function<RT, RX> function) {
        return context -> {
            BTElementHandlerType newHandler = constructor.create(context);
            return Blackthorne.map(newHandler, function);
        };
    }

    public static <CT, RT, RX extends RT> BTElementHandlerConstructorType<CT, RT> widenConstructor(BTElementHandlerConstructorType<CT, RX> constructor) {
        return constructor;
    }

    public static <S> BTElementHandlerConstructorType<?, S> forScalar(BTQualifiedName elementName, BTCharacterHandlerType<S> parser) {
        Objects.requireNonNull(elementName, "elementName");
        Objects.requireNonNull(parser, "parser");
        return context -> new BTScalarElementHandler(elementName, parser);
    }

    public static <S> BTElementHandlerConstructorType<?, S> forScalar(String namespaceURI, String localName, BTCharacterHandlerType<S> parser) {
        Objects.requireNonNull(namespaceURI, "namespaceURI");
        Objects.requireNonNull(localName, "localName");
        Objects.requireNonNull(parser, "parser");
        return Blackthorne.forScalar(BTQualifiedName.of(namespaceURI, localName), parser);
    }

    public static <S> BTElementHandlerConstructorType<?, S> forScalarAttribute(BTQualifiedName elementName, BTAttributesHandlerType<S> parser) {
        Objects.requireNonNull(elementName, "elementName");
        Objects.requireNonNull(parser, "parser");
        return context -> new BTScalarAttributeHandler(elementName, parser);
    }

    public static <S> BTElementHandlerConstructorType<?, S> forScalarAttribute(String namespaceURI, String localName, BTAttributesHandlerType<S> parser) {
        Objects.requireNonNull(namespaceURI, "namespaceURI");
        Objects.requireNonNull(localName, "localName");
        Objects.requireNonNull(parser, "parser");
        return Blackthorne.forScalarAttribute(BTQualifiedName.of(namespaceURI, localName), parser);
    }

    public static <S> BTElementHandlerConstructorType<S, List<S>> forListMono(BTQualifiedName elementName, BTQualifiedName childElementName, BTElementHandlerConstructorType<?, ? extends S> itemHandler, BTIgnoreUnrecognizedElements ignoreUnrecognized) {
        Objects.requireNonNull(elementName, "elementName");
        Objects.requireNonNull(childElementName, "childElementName");
        Objects.requireNonNull(itemHandler, "itemHandler");
        return context -> new BTListMonoHandler(elementName, childElementName, itemHandler, ignoreUnrecognized);
    }

    public static <S> BTElementHandlerConstructorType<S, List<S>> forListPoly(BTQualifiedName elementName, Map<BTQualifiedName, BTElementHandlerConstructorType<?, ? extends S>> itemHandlers, BTIgnoreUnrecognizedElements ignoreUnrecognized) {
        Objects.requireNonNull(elementName, "elementName");
        Objects.requireNonNull(itemHandlers, "itemHandlers");
        return context -> new BTListPolyHandler(elementName, itemHandlers, ignoreUnrecognized);
    }

    public static BTElementHandlerConstructorType<?, String> forScalarString(BTQualifiedName elementName) {
        return Blackthorne.forScalar(elementName, (context, characters, offset, length) -> new String(characters, offset, length));
    }

    public static BTElementHandlerConstructorType<?, String> forScalarString(String namespaceURI, String localName) {
        return Blackthorne.forScalar(namespaceURI, localName, (context, characters, offset, length) -> new String(characters, offset, length));
    }

    public static <S> BTElementHandlerConstructorType<?, S> forScalarFromString(BTQualifiedName elementName, Function<String, S> parser) {
        return Blackthorne.mapConstructor(Blackthorne.forScalarString(elementName), parser);
    }

    public static <S> BTElementHandlerConstructorType<?, S> forScalarFromString(String namespaceURI, String localName, Function<String, S> parser) {
        return Blackthorne.mapConstructor(Blackthorne.forScalarString(namespaceURI, localName), parser);
    }

    public static <T> T parse(URI source, InputStream stream, Callable<XMLReader> xmlReaders, Map<BTQualifiedName, BTElementHandlerConstructorType<?, T>> rootElements) throws BTException {
        ArrayList<BTParseError> errors = new ArrayList<BTParseError>(32);
        BTContentHandler<T> contentHandler = new BTContentHandler<T>(source, errors::add, rootElements);
        try {
            XMLReader reader = xmlReaders.call();
            reader.setContentHandler(contentHandler);
            reader.setErrorHandler(contentHandler);
            InputSource inputSource = new InputSource(stream);
            inputSource.setPublicId(source.toString());
            reader.parse(inputSource);
            Optional<T> resultOpt = contentHandler.result();
            if (resultOpt.isEmpty()) {
                throw new BTException("Parse failed.", new IOException(), errors);
            }
            return resultOpt.get();
        }
        catch (SAXParseException e) {
            LOG.error("error encountered during parsing: ", e);
            LexicalPosition<URI> position = LexicalPosition.of(e.getLineNumber(), e.getColumnNumber(), Optional.of(source));
            errors.add(BTParseError.builder().setLexical(position).setSeverity(BTParseErrorType.Severity.ERROR).setMessage(e.getMessage()).build());
            throw new BTException(e.getMessage(), e, errors);
        }
        catch (Exception e) {
            LOG.error("error encountered during parsing: ", e);
            LexicalPosition<URI> position = LexicalPosition.of(-1, -1, Optional.of(source));
            errors.add(BTParseError.builder().setLexical(position).setSeverity(BTParseErrorType.Severity.ERROR).setMessage(e.getMessage()).build());
            throw new BTException(e.getMessage(), e, errors);
        }
    }
}

