/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jaffirm.core;

import com.io7m.jaffirm.core.ContractConditionType;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

public final class ContractCondition<T>
implements ContractConditionType<T> {
    private final Predicate<T> predicate;
    private final Function<T, String> describer;

    private ContractCondition(Predicate<T> predicate, Function<T, String> describer) {
        this.predicate = Objects.requireNonNull(predicate, "predicate");
        this.describer = Objects.requireNonNull(describer, "describer");
    }

    private ContractCondition(ContractCondition original, Predicate<T> predicate, Function<T, String> describer) {
        this.predicate = predicate;
        this.describer = describer;
    }

    @Override
    public Predicate<T> predicate() {
        return this.predicate;
    }

    @Override
    public Function<T, String> describer() {
        return this.describer;
    }

    public final ContractCondition<T> withPredicate(Predicate<T> value) {
        if (this.predicate == value) {
            return this;
        }
        Predicate<T> newValue = Objects.requireNonNull(value, "predicate");
        return new ContractCondition<T>(this, newValue, this.describer);
    }

    public final ContractCondition<T> withDescriber(Function<T, String> value) {
        if (this.describer == value) {
            return this;
        }
        Function<T, String> newValue = Objects.requireNonNull(value, "describer");
        return new ContractCondition<T>(this, this.predicate, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ContractCondition && this.equalTo((ContractCondition)another);
    }

    private boolean equalTo(ContractCondition<?> another) {
        return this.predicate.equals(another.predicate) && this.describer.equals(another.describer);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.predicate.hashCode();
        h2 += (h2 << 5) + this.describer.hashCode();
        return h2;
    }

    public String toString() {
        return "ContractCondition{predicate=" + this.predicate + ", describer=" + this.describer + "}";
    }

    public static <T> ContractCondition<T> of(Predicate<T> predicate, Function<T, String> describer) {
        return new ContractCondition<T>(predicate, describer);
    }

    public static <T> ContractCondition<T> copyOf(ContractConditionType<T> instance) {
        if (instance instanceof ContractCondition) {
            return (ContractCondition)instance;
        }
        return ContractCondition.builder().from(instance).build();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static final class Builder<T> {
        private static final long INIT_BIT_PREDICATE = 1L;
        private static final long INIT_BIT_DESCRIBER = 2L;
        private long initBits = 3L;
        private Predicate<T> predicate;
        private Function<T, String> describer;

        private Builder() {
        }

        public final Builder<T> from(ContractConditionType<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.setPredicate(instance.predicate());
            this.setDescriber(instance.describer());
            return this;
        }

        public final Builder<T> setPredicate(Predicate<T> predicate) {
            this.predicate = Objects.requireNonNull(predicate, "predicate");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<T> setDescriber(Function<T, String> describer) {
            this.describer = Objects.requireNonNull(describer, "describer");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ContractCondition<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ContractCondition<T>(null, this.predicate, this.describer);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("predicate");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("describer");
            }
            return "Cannot build ContractCondition, some of required attributes are not set " + attributes;
        }
    }
}

