/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jxe.core;

import com.io7m.jxe.core.JXESchemaDefinition;
import com.io7m.jxe.core.JXESchemaResolutionMappings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public final class JXEHardenedDispatchingResolver
implements EntityResolver2 {
    private static final Logger LOG = LoggerFactory.getLogger(JXEHardenedDispatchingResolver.class);
    private final Optional<Path> base_directory;
    private final JXESchemaResolutionMappings schemas;

    private JXEHardenedDispatchingResolver(Optional<Path> in_base_directory, JXESchemaResolutionMappings in_schemas) {
        this.base_directory = Objects.requireNonNull(in_base_directory, "Base directory").map(p -> p.toAbsolutePath().normalize());
        this.schemas = Objects.requireNonNull(in_schemas, "Schemas");
    }

    public static JXEHardenedDispatchingResolver create(Optional<Path> in_base_directory, JXESchemaResolutionMappings in_schemas) {
        return new JXEHardenedDispatchingResolver(in_base_directory, in_schemas);
    }

    @Override
    public InputSource getExternalSubset(String name, String base_uri) throws SAXException {
        String line_separator = System.lineSeparator();
        throw new SAXException(new StringBuilder(128).append("External subsets are explicitly forbidden by this parser configuration.").append(line_separator).append("  Name: ").append(name).append(line_separator).toString());
    }

    @Override
    public InputSource resolveEntity(String name, String public_id, String base_uri, String system_id) throws SAXException, IOException {
        LOG.debug("resolveEntity: {} {} {} {}", name, public_id, base_uri, system_id);
        Optional<JXESchemaDefinition> schema_opt = this.schemas.mappings().values().stream().filter(def -> Objects.equals(def.fileIdentifier(), system_id)).findAny();
        if (schema_opt.isPresent()) {
            JXESchemaDefinition schema = schema_opt.get();
            URL location = schema.location();
            LOG.debug("resolving {} from internal resources -> {}", (Object)system_id, (Object)location);
            return JXEHardenedDispatchingResolver.createSource(location.openStream(), location.toString());
        }
        String line_separator = System.lineSeparator();
        try {
            URI uri = new URI(system_id);
            String scheme = uri.getScheme();
            if (!JXEHardenedDispatchingResolver.isResolvable(scheme)) {
                throw new SAXException(new StringBuilder(128).append("Refusing to resolve a non-file URI.").append(line_separator).append("  Base: ").append(this.base_directory).append(line_separator).append("  URI: ").append(uri).append(line_separator).toString());
            }
            if (!this.base_directory.isPresent()) {
                throw new SAXException(new StringBuilder(128).append("Refusing to allow access to the filesystem.").append(line_separator).append("  Input URI: ").append(uri).append(line_separator).toString());
            }
            Path base = this.base_directory.get();
            LOG.debug("resolving {} from filesystem", (Object)system_id);
            Path resolved = base.resolve(system_id).toAbsolutePath().normalize();
            if (!resolved.startsWith(base)) {
                throw new SAXException(new StringBuilder(128).append("Refusing to allow access to files above the base directory.").append(line_separator).append("  Base: ").append(base).append(line_separator).append("  Path: ").append(resolved).append(line_separator).toString());
            }
            if (!Files.isRegularFile(resolved, LinkOption.NOFOLLOW_LINKS)) {
                throw new NoSuchFileException(resolved.toString(), null, "File does not exist or is not a regular file");
            }
            return JXEHardenedDispatchingResolver.createSource(Files.newInputStream(resolved, new OpenOption[0]), resolved.toString());
        }
        catch (URISyntaxException e) {
            throw new SAXException(new StringBuilder(128).append("Refusing to resolve an unparseable URI.").append(line_separator).append("  Base: ").append(this.base_directory).append(line_separator).append("  URI: ").append(system_id).append(line_separator).toString(), e);
        }
    }

    private static InputSource createSource(InputStream stream, String system_id) {
        InputSource source = new InputSource(stream);
        source.setSystemId(system_id);
        return source;
    }

    private static boolean isResolvable(String scheme) {
        return Objects.equals("file", scheme) || scheme == null;
    }

    @Override
    public InputSource resolveEntity(String public_id, String system_id) {
        throw new UnsupportedOperationException("Simple entity resolution not supported");
    }
}

