/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jxe.core;

import com.io7m.jxe.core.JXESchemaDefinitionType;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Objects;

public final class JXESchemaDefinition
implements JXESchemaDefinitionType {
    private final URI namespace;
    private final String fileIdentifier;
    private final URL location;

    private JXESchemaDefinition(URI namespace, String fileIdentifier, URL location) {
        this.namespace = Objects.requireNonNull(namespace, "namespace");
        this.fileIdentifier = Objects.requireNonNull(fileIdentifier, "fileIdentifier");
        this.location = Objects.requireNonNull(location, "location");
    }

    private JXESchemaDefinition(JXESchemaDefinition original, URI namespace, String fileIdentifier, URL location) {
        this.namespace = namespace;
        this.fileIdentifier = fileIdentifier;
        this.location = location;
    }

    @Override
    public URI namespace() {
        return this.namespace;
    }

    @Override
    public String fileIdentifier() {
        return this.fileIdentifier;
    }

    @Override
    public URL location() {
        return this.location;
    }

    public final JXESchemaDefinition withNamespace(URI value) {
        if (this.namespace == value) {
            return this;
        }
        URI newValue = Objects.requireNonNull(value, "namespace");
        return new JXESchemaDefinition(this, newValue, this.fileIdentifier, this.location);
    }

    public final JXESchemaDefinition withFileIdentifier(String value) {
        if (this.fileIdentifier.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "fileIdentifier");
        return new JXESchemaDefinition(this, this.namespace, newValue, this.location);
    }

    public final JXESchemaDefinition withLocation(URL value) {
        if (this.location == value) {
            return this;
        }
        URL newValue = Objects.requireNonNull(value, "location");
        return new JXESchemaDefinition(this, this.namespace, this.fileIdentifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof JXESchemaDefinition && this.equalTo((JXESchemaDefinition)another);
    }

    private boolean equalTo(JXESchemaDefinition another) {
        return this.namespace.equals(another.namespace) && this.fileIdentifier.equals(another.fileIdentifier);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.namespace.hashCode();
        h2 += (h2 << 5) + this.fileIdentifier.hashCode();
        return h2;
    }

    public String toString() {
        return "JXESchemaDefinition{namespace=" + this.namespace + ", fileIdentifier=" + this.fileIdentifier + "}";
    }

    public static JXESchemaDefinition of(URI namespace, String fileIdentifier, URL location) {
        return new JXESchemaDefinition(namespace, fileIdentifier, location);
    }

    public static JXESchemaDefinition copyOf(JXESchemaDefinitionType instance) {
        if (instance instanceof JXESchemaDefinition) {
            return (JXESchemaDefinition)instance;
        }
        return JXESchemaDefinition.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAMESPACE = 1L;
        private static final long INIT_BIT_FILE_IDENTIFIER = 2L;
        private static final long INIT_BIT_LOCATION = 4L;
        private long initBits = 7L;
        private URI namespace;
        private String fileIdentifier;
        private URL location;

        private Builder() {
        }

        public final Builder from(JXESchemaDefinitionType instance) {
            Objects.requireNonNull(instance, "instance");
            this.setNamespace(instance.namespace());
            this.setFileIdentifier(instance.fileIdentifier());
            this.setLocation(instance.location());
            return this;
        }

        public final Builder setNamespace(URI namespace) {
            this.namespace = Objects.requireNonNull(namespace, "namespace");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setFileIdentifier(String fileIdentifier) {
            this.fileIdentifier = Objects.requireNonNull(fileIdentifier, "fileIdentifier");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setLocation(URL location) {
            this.location = Objects.requireNonNull(location, "location");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public JXESchemaDefinition build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new JXESchemaDefinition(null, this.namespace, this.fileIdentifier, this.location);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("namespace");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("fileIdentifier");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("location");
            }
            return "Cannot build JXESchemaDefinition, some of required attributes are not set " + attributes;
        }
    }
}

