/*
 * Decompiled with CFR 0.152.
 */
package one.lfa.opdsget.api;

import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import one.lfa.opdsget.api.OPDSAuthenticationType;
import one.lfa.opdsget.api.OPDSGetConfigurationType;
import one.lfa.opdsget.api.OPDSGetKind;
import one.lfa.opdsget.api.OPDSSquashConfiguration;
import one.lfa.opdsget.api.OPDSURIRewriterType;
import org.immutables.value.Generated;

@Generated(from="OPDSGetConfigurationType", generator="Immutables")
public final class OPDSGetConfiguration
implements OPDSGetConfigurationType {
    private final Path output;
    private final Path outputArchive;
    private final URI remoteURI;
    private final OPDSURIRewriterType uriRewriter;
    private final Function<URI, Optional<OPDSAuthenticationType>> authenticationSupplier;
    private final Set<OPDSGetKind> fetchedKinds;
    private final OPDSSquashConfiguration squash;
    private final Double scaleImages;
    private final URI outputManifestBaseURI;
    private final UUID outputManifestID;
    private final String outputManifestTitle;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private OPDSGetConfiguration(Path output, Optional<? extends Path> outputArchive, URI remoteURI, OPDSURIRewriterType uriRewriter, Function<URI, Optional<OPDSAuthenticationType>> authenticationSupplier, Iterable<OPDSGetKind> fetchedKinds, Optional<? extends OPDSSquashConfiguration> squash) {
        this.output = Objects.requireNonNull(output, "output");
        this.outputArchive = outputArchive.orElse(null);
        this.remoteURI = Objects.requireNonNull(remoteURI, "remoteURI");
        this.initShim.setUriRewriter(Objects.requireNonNull(uriRewriter, "uriRewriter"));
        this.initShim.setAuthenticationSupplier(Objects.requireNonNull(authenticationSupplier, "authenticationSupplier"));
        this.initShim.setFetchedKinds(OPDSGetConfiguration.createUnmodifiableEnumSet(fetchedKinds));
        this.squash = squash.orElse(null);
        this.scaleImages = null;
        this.outputManifestBaseURI = null;
        this.uriRewriter = this.initShim.uriRewriter();
        this.authenticationSupplier = this.initShim.authenticationSupplier();
        this.fetchedKinds = this.initShim.fetchedKinds();
        this.outputManifestID = this.initShim.outputManifestID();
        this.outputManifestTitle = this.initShim.outputManifestTitle();
        this.initShim = null;
    }

    private OPDSGetConfiguration(Builder builder) {
        this.output = builder.output;
        this.outputArchive = builder.outputArchive;
        this.remoteURI = builder.remoteURI;
        this.squash = builder.squash;
        this.scaleImages = builder.scaleImages;
        this.outputManifestBaseURI = builder.outputManifestBaseURI;
        if (builder.uriRewriter != null) {
            this.initShim.setUriRewriter(builder.uriRewriter);
        }
        if (builder.authenticationSupplier != null) {
            this.initShim.setAuthenticationSupplier(builder.authenticationSupplier);
        }
        if (builder.fetchedKindsIsSet()) {
            this.initShim.setFetchedKinds(OPDSGetConfiguration.createUnmodifiableEnumSet(builder.fetchedKinds));
        }
        if (builder.outputManifestID != null) {
            this.initShim.setOutputManifestID(builder.outputManifestID);
        }
        if (builder.outputManifestTitle != null) {
            this.initShim.setOutputManifestTitle(builder.outputManifestTitle);
        }
        this.uriRewriter = this.initShim.uriRewriter();
        this.authenticationSupplier = this.initShim.authenticationSupplier();
        this.fetchedKinds = this.initShim.fetchedKinds();
        this.outputManifestID = this.initShim.outputManifestID();
        this.outputManifestTitle = this.initShim.outputManifestTitle();
        this.initShim = null;
    }

    private OPDSURIRewriterType uriRewriterInitialize() {
        return OPDSGetConfigurationType.super.uriRewriter();
    }

    private Function<URI, Optional<OPDSAuthenticationType>> authenticationSupplierInitialize() {
        return OPDSGetConfigurationType.super.authenticationSupplier();
    }

    private Set<OPDSGetKind> fetchedKindsInitialize() {
        return OPDSGetConfigurationType.super.fetchedKinds();
    }

    private UUID outputManifestIDInitialize() {
        return OPDSGetConfigurationType.super.outputManifestID();
    }

    private String outputManifestTitleInitialize() {
        return OPDSGetConfigurationType.super.outputManifestTitle();
    }

    @Override
    public Path output() {
        return this.output;
    }

    @Override
    public Optional<Path> outputArchive() {
        return Optional.ofNullable(this.outputArchive);
    }

    @Override
    public URI remoteURI() {
        return this.remoteURI;
    }

    @Override
    public OPDSURIRewriterType uriRewriter() {
        InitShim shim = this.initShim;
        return shim != null ? shim.uriRewriter() : this.uriRewriter;
    }

    @Override
    public Function<URI, Optional<OPDSAuthenticationType>> authenticationSupplier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.authenticationSupplier() : this.authenticationSupplier;
    }

    @Override
    public Set<OPDSGetKind> fetchedKinds() {
        InitShim shim = this.initShim;
        return shim != null ? shim.fetchedKinds() : this.fetchedKinds;
    }

    @Override
    public Optional<OPDSSquashConfiguration> squash() {
        return Optional.ofNullable(this.squash);
    }

    @Override
    public OptionalDouble scaleImages() {
        return this.scaleImages != null ? OptionalDouble.of(this.scaleImages) : OptionalDouble.empty();
    }

    @Override
    public Optional<URI> outputManifestBaseURI() {
        return Optional.ofNullable(this.outputManifestBaseURI);
    }

    @Override
    public UUID outputManifestID() {
        InitShim shim = this.initShim;
        return shim != null ? shim.outputManifestID() : this.outputManifestID;
    }

    @Override
    public String outputManifestTitle() {
        InitShim shim = this.initShim;
        return shim != null ? shim.outputManifestTitle() : this.outputManifestTitle;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof OPDSGetConfiguration && this.equalTo((OPDSGetConfiguration)another);
    }

    private boolean equalTo(OPDSGetConfiguration another) {
        return this.output.equals(another.output) && Objects.equals(this.outputArchive, another.outputArchive) && this.remoteURI.equals(another.remoteURI) && this.uriRewriter.equals(another.uriRewriter) && this.authenticationSupplier.equals(another.authenticationSupplier) && this.fetchedKinds.equals(another.fetchedKinds) && Objects.equals(this.squash, another.squash) && Objects.equals(this.scaleImages, another.scaleImages) && Objects.equals(this.outputManifestBaseURI, another.outputManifestBaseURI) && this.outputManifestID.equals(another.outputManifestID) && this.outputManifestTitle.equals(another.outputManifestTitle);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.output.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.outputArchive);
        h2 += (h2 << 5) + this.remoteURI.hashCode();
        h2 += (h2 << 5) + this.uriRewriter.hashCode();
        h2 += (h2 << 5) + this.authenticationSupplier.hashCode();
        h2 += (h2 << 5) + this.fetchedKinds.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.squash);
        h2 += (h2 << 5) + Objects.hashCode(this.scaleImages);
        h2 += (h2 << 5) + Objects.hashCode(this.outputManifestBaseURI);
        h2 += (h2 << 5) + this.outputManifestID.hashCode();
        h2 += (h2 << 5) + this.outputManifestTitle.hashCode();
        return h2;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("OPDSGetConfiguration{");
        builder.append("output=").append(this.output);
        if (this.outputArchive != null) {
            builder.append(", ");
            builder.append("outputArchive=").append(this.outputArchive);
        }
        builder.append(", ");
        builder.append("remoteURI=").append(this.remoteURI);
        builder.append(", ");
        builder.append("uriRewriter=").append(this.uriRewriter);
        builder.append(", ");
        builder.append("authenticationSupplier=").append(this.authenticationSupplier);
        builder.append(", ");
        builder.append("fetchedKinds=").append(this.fetchedKinds);
        if (this.squash != null) {
            builder.append(", ");
            builder.append("squash=").append(this.squash);
        }
        if (this.scaleImages != null) {
            builder.append(", ");
            builder.append("scaleImages=").append(this.scaleImages);
        }
        if (this.outputManifestBaseURI != null) {
            builder.append(", ");
            builder.append("outputManifestBaseURI=").append(this.outputManifestBaseURI);
        }
        builder.append(", ");
        builder.append("outputManifestID=").append(this.outputManifestID);
        builder.append(", ");
        builder.append("outputManifestTitle=").append(this.outputManifestTitle);
        return builder.append("}").toString();
    }

    public static OPDSGetConfiguration of(Path output, Optional<Path> outputArchive, URI remoteURI, OPDSURIRewriterType uriRewriter, Function<URI, Optional<OPDSAuthenticationType>> authenticationSupplier, Set<OPDSGetKind> fetchedKinds, Optional<OPDSSquashConfiguration> squash) {
        return OPDSGetConfiguration.of(output, outputArchive, remoteURI, uriRewriter, authenticationSupplier, fetchedKinds, squash);
    }

    public static OPDSGetConfiguration of(Path output, Optional<? extends Path> outputArchive, URI remoteURI, OPDSURIRewriterType uriRewriter, Function<URI, Optional<OPDSAuthenticationType>> authenticationSupplier, Iterable<OPDSGetKind> fetchedKinds, Optional<? extends OPDSSquashConfiguration> squash) {
        return OPDSGetConfiguration.validate(new OPDSGetConfiguration(output, outputArchive, remoteURI, uriRewriter, authenticationSupplier, fetchedKinds, squash));
    }

    private static OPDSGetConfiguration validate(OPDSGetConfiguration instance) {
        instance.checkPreconditions();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T extends Enum<T>> Set<T> createUnmodifiableEnumSet(Iterable<T> iterable) {
        if (iterable instanceof EnumSet) {
            return Collections.unmodifiableSet(EnumSet.copyOf((EnumSet)iterable));
        }
        List<T> list = OPDSGetConfiguration.createSafeList(iterable, true, false);
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton((Enum)list.get(0));
            }
        }
        return Collections.unmodifiableSet(EnumSet.copyOf(list));
    }

    @Generated(from="OPDSGetConfigurationType", generator="Immutables")
    private final class InitShim {
        private byte uriRewriterBuildStage = 0;
        private OPDSURIRewriterType uriRewriter;
        private byte authenticationSupplierBuildStage = 0;
        private Function<URI, Optional<OPDSAuthenticationType>> authenticationSupplier;
        private byte fetchedKindsBuildStage = 0;
        private Set<OPDSGetKind> fetchedKinds;
        private byte outputManifestIDBuildStage = 0;
        private UUID outputManifestID;
        private byte outputManifestTitleBuildStage = 0;
        private String outputManifestTitle;

        private InitShim() {
        }

        OPDSURIRewriterType uriRewriter() {
            if (this.uriRewriterBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.uriRewriterBuildStage == 0) {
                this.uriRewriterBuildStage = (byte)-1;
                this.uriRewriter = Objects.requireNonNull(OPDSGetConfiguration.this.uriRewriterInitialize(), "uriRewriter");
                this.uriRewriterBuildStage = 1;
            }
            return this.uriRewriter;
        }

        void setUriRewriter(OPDSURIRewriterType uriRewriter) {
            this.uriRewriter = uriRewriter;
            this.uriRewriterBuildStage = 1;
        }

        Function<URI, Optional<OPDSAuthenticationType>> authenticationSupplier() {
            if (this.authenticationSupplierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.authenticationSupplierBuildStage == 0) {
                this.authenticationSupplierBuildStage = (byte)-1;
                this.authenticationSupplier = Objects.requireNonNull(OPDSGetConfiguration.this.authenticationSupplierInitialize(), "authenticationSupplier");
                this.authenticationSupplierBuildStage = 1;
            }
            return this.authenticationSupplier;
        }

        void setAuthenticationSupplier(Function<URI, Optional<OPDSAuthenticationType>> authenticationSupplier) {
            this.authenticationSupplier = authenticationSupplier;
            this.authenticationSupplierBuildStage = 1;
        }

        Set<OPDSGetKind> fetchedKinds() {
            if (this.fetchedKindsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fetchedKindsBuildStage == 0) {
                this.fetchedKindsBuildStage = (byte)-1;
                this.fetchedKinds = OPDSGetConfiguration.createUnmodifiableEnumSet(OPDSGetConfiguration.this.fetchedKindsInitialize());
                this.fetchedKindsBuildStage = 1;
            }
            return this.fetchedKinds;
        }

        void setFetchedKinds(Set<OPDSGetKind> fetchedKinds) {
            this.fetchedKinds = fetchedKinds;
            this.fetchedKindsBuildStage = 1;
        }

        UUID outputManifestID() {
            if (this.outputManifestIDBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.outputManifestIDBuildStage == 0) {
                this.outputManifestIDBuildStage = (byte)-1;
                this.outputManifestID = Objects.requireNonNull(OPDSGetConfiguration.this.outputManifestIDInitialize(), "outputManifestID");
                this.outputManifestIDBuildStage = 1;
            }
            return this.outputManifestID;
        }

        void setOutputManifestID(UUID outputManifestID) {
            this.outputManifestID = outputManifestID;
            this.outputManifestIDBuildStage = 1;
        }

        String outputManifestTitle() {
            if (this.outputManifestTitleBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.outputManifestTitleBuildStage == 0) {
                this.outputManifestTitleBuildStage = (byte)-1;
                this.outputManifestTitle = Objects.requireNonNull(OPDSGetConfiguration.this.outputManifestTitleInitialize(), "outputManifestTitle");
                this.outputManifestTitleBuildStage = 1;
            }
            return this.outputManifestTitle;
        }

        void setOutputManifestTitle(String outputManifestTitle) {
            this.outputManifestTitle = outputManifestTitle;
            this.outputManifestTitleBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.uriRewriterBuildStage == -1) {
                attributes.add("uriRewriter");
            }
            if (this.authenticationSupplierBuildStage == -1) {
                attributes.add("authenticationSupplier");
            }
            if (this.fetchedKindsBuildStage == -1) {
                attributes.add("fetchedKinds");
            }
            if (this.outputManifestIDBuildStage == -1) {
                attributes.add("outputManifestID");
            }
            if (this.outputManifestTitleBuildStage == -1) {
                attributes.add("outputManifestTitle");
            }
            return "Cannot build OPDSGetConfiguration, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="OPDSGetConfigurationType", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_OUTPUT = 1L;
        private static final long INIT_BIT_REMOTE_U_R_I = 2L;
        private static final long OPT_BIT_FETCHED_KINDS = 1L;
        private long initBits = 3L;
        private long optBits;
        private Path output;
        private Path outputArchive;
        private URI remoteURI;
        private OPDSURIRewriterType uriRewriter;
        private Function<URI, Optional<OPDSAuthenticationType>> authenticationSupplier;
        private EnumSet<OPDSGetKind> fetchedKinds = EnumSet.noneOf(OPDSGetKind.class);
        private OPDSSquashConfiguration squash;
        private Double scaleImages;
        private URI outputManifestBaseURI;
        private UUID outputManifestID;
        private String outputManifestTitle;

        private Builder() {
        }

        public final Builder from(OPDSGetConfigurationType instance) {
            Optional<URI> outputManifestBaseURIOptional;
            OptionalDouble scaleImagesOptional;
            Objects.requireNonNull(instance, "instance");
            this.setOutput(instance.output());
            Optional<Path> outputArchiveOptional = instance.outputArchive();
            if (outputArchiveOptional.isPresent()) {
                this.setOutputArchive(outputArchiveOptional);
            }
            this.setRemoteURI(instance.remoteURI());
            this.setUriRewriter(instance.uriRewriter());
            this.setAuthenticationSupplier(instance.authenticationSupplier());
            this.addAllFetchedKinds(instance.fetchedKinds());
            Optional<OPDSSquashConfiguration> squashOptional = instance.squash();
            if (squashOptional.isPresent()) {
                this.setSquash(squashOptional);
            }
            if ((scaleImagesOptional = instance.scaleImages()).isPresent()) {
                this.setScaleImages(scaleImagesOptional);
            }
            if ((outputManifestBaseURIOptional = instance.outputManifestBaseURI()).isPresent()) {
                this.setOutputManifestBaseURI(outputManifestBaseURIOptional);
            }
            this.setOutputManifestID(instance.outputManifestID());
            this.setOutputManifestTitle(instance.outputManifestTitle());
            return this;
        }

        public final Builder setOutput(Path output) {
            this.output = Objects.requireNonNull(output, "output");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setOutputArchive(Path outputArchive) {
            this.outputArchive = Objects.requireNonNull(outputArchive, "outputArchive");
            return this;
        }

        public final Builder setOutputArchive(Optional<? extends Path> outputArchive) {
            this.outputArchive = outputArchive.orElse(null);
            return this;
        }

        public final Builder setRemoteURI(URI remoteURI) {
            this.remoteURI = Objects.requireNonNull(remoteURI, "remoteURI");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setUriRewriter(OPDSURIRewriterType uriRewriter) {
            this.uriRewriter = Objects.requireNonNull(uriRewriter, "uriRewriter");
            return this;
        }

        public final Builder setAuthenticationSupplier(Function<URI, Optional<OPDSAuthenticationType>> authenticationSupplier) {
            this.authenticationSupplier = Objects.requireNonNull(authenticationSupplier, "authenticationSupplier");
            return this;
        }

        public final Builder addFetchedKinds(OPDSGetKind element) {
            this.fetchedKinds.add(Objects.requireNonNull(element, "fetchedKinds element"));
            this.optBits |= 1L;
            return this;
        }

        public final Builder addFetchedKinds(OPDSGetKind ... elements) {
            for (OPDSGetKind element : elements) {
                this.fetchedKinds.add(Objects.requireNonNull(element, "fetchedKinds element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder setFetchedKinds(Iterable<OPDSGetKind> elements) {
            this.fetchedKinds.clear();
            return this.addAllFetchedKinds(elements);
        }

        public final Builder addAllFetchedKinds(Iterable<OPDSGetKind> elements) {
            for (OPDSGetKind element : elements) {
                this.fetchedKinds.add(Objects.requireNonNull(element, "fetchedKinds element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder setSquash(OPDSSquashConfiguration squash) {
            this.squash = Objects.requireNonNull(squash, "squash");
            return this;
        }

        public final Builder setSquash(Optional<? extends OPDSSquashConfiguration> squash) {
            this.squash = squash.orElse(null);
            return this;
        }

        public final Builder setScaleImages(double scaleImages) {
            this.scaleImages = scaleImages;
            return this;
        }

        public final Builder setScaleImages(OptionalDouble scaleImages) {
            this.scaleImages = scaleImages.isPresent() ? Double.valueOf(scaleImages.getAsDouble()) : null;
            return this;
        }

        public final Builder setOutputManifestBaseURI(URI outputManifestBaseURI) {
            this.outputManifestBaseURI = Objects.requireNonNull(outputManifestBaseURI, "outputManifestBaseURI");
            return this;
        }

        public final Builder setOutputManifestBaseURI(Optional<? extends URI> outputManifestBaseURI) {
            this.outputManifestBaseURI = outputManifestBaseURI.orElse(null);
            return this;
        }

        public final Builder setOutputManifestID(UUID outputManifestID) {
            this.outputManifestID = Objects.requireNonNull(outputManifestID, "outputManifestID");
            return this;
        }

        public final Builder setOutputManifestTitle(String outputManifestTitle) {
            this.outputManifestTitle = Objects.requireNonNull(outputManifestTitle, "outputManifestTitle");
            return this;
        }

        public OPDSGetConfiguration build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return OPDSGetConfiguration.validate(new OPDSGetConfiguration(this));
        }

        private boolean fetchedKindsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("output");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("remoteURI");
            }
            return "Cannot build OPDSGetConfiguration, some of required attributes are not set " + attributes;
        }
    }
}

