/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.blackthorne.api;

import com.io7m.blackthorne.api.BTContentHandlerBuilderType;
import com.io7m.blackthorne.api.BTElementHandlerConstructorType;
import com.io7m.blackthorne.api.BTParseError;
import com.io7m.blackthorne.api.BTParseErrorType;
import com.io7m.blackthorne.api.BTQualifiedName;
import com.io7m.blackthorne.api.BTStackHandler;
import com.io7m.jlexing.core.LexicalPosition;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.ext.Locator2;

public final class BTContentHandler<T>
extends DefaultHandler2 {
    private static final Logger LOG = LoggerFactory.getLogger(BTContentHandler.class);
    private final URI fileURI;
    private final Consumer<BTParseError> errorReceiver;
    private Locator2 locator;
    private Map<BTQualifiedName, BTElementHandlerConstructorType<?, T>> rootHandlers;
    private BTStackHandler<T> stackHandler;
    private boolean failed;

    public BTContentHandler(URI inFileURI, Consumer<BTParseError> inErrorReceiver, Map<BTQualifiedName, BTElementHandlerConstructorType<?, T>> inRootHandlers) {
        this.fileURI = Objects.requireNonNull(inFileURI, "fileURI");
        this.errorReceiver = Objects.requireNonNull(inErrorReceiver, "errorReceiver");
        this.rootHandlers = Map.copyOf(Objects.requireNonNull(inRootHandlers, "handlers"));
    }

    public static <U> BTContentHandlerBuilderType<U> builder() {
        return new Builder();
    }

    public static <U> BTContentHandlerBuilderType<U> builder(Class<U> clazz) {
        return new Builder();
    }

    private static String messageOrException(Exception e) {
        String messageOrNull = e.getMessage();
        if (messageOrNull == null) {
            return String.format("No error message provided for exception %s", e.getClass().getName());
        }
        return messageOrNull;
    }

    @Override
    public void setDocumentLocator(Locator in_locator) {
        this.locator = (Locator2)Objects.requireNonNull(in_locator, "locator");
        this.stackHandler = new BTStackHandler<T>(this.locator, this.rootHandlers);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) {
        try {
            this.stackHandler.onElementStarted(namespaceURI, localName, attributes);
        }
        catch (SAXParseException e) {
            this.error(e);
        }
        catch (Exception e) {
            this.error(this.saxParseExceptionOf(e));
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qualifiedName) {
        try {
            this.stackHandler.onElementFinished(namespaceURI, localName);
        }
        catch (SAXParseException e) {
            this.error(e);
        }
        catch (Exception e) {
            this.error(this.saxParseExceptionOf(e));
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        try {
            this.stackHandler.onCharacters(ch, start, length);
        }
        catch (SAXParseException e) {
            this.error(e);
        }
        catch (Exception e) {
            this.error(this.saxParseExceptionOf(e));
        }
    }

    @Override
    public void warning(SAXParseException e) {
        LOG.warn("parse exception: ", e);
        this.errorReceiver.accept(BTParseError.builder().setException(e).setSeverity(BTParseErrorType.Severity.WARNING).setMessage(BTContentHandler.messageOrException(e)).setLexical(this.currentLexical()).build());
    }

    @Override
    public void error(SAXParseException e) {
        LOG.error("parse exception: ", e);
        this.failed = true;
        this.errorReceiver.accept(BTParseError.builder().setException(e).setSeverity(BTParseErrorType.Severity.ERROR).setMessage(BTContentHandler.messageOrException(e)).setLexical(this.currentLexical()).build());
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        LOG.error("fatal parse exception: ", e);
        this.failed = true;
        this.errorReceiver.accept(BTParseError.builder().setException(e).setSeverity(BTParseErrorType.Severity.ERROR).setMessage(BTContentHandler.messageOrException(e)).setLexical(this.currentLexical()).build());
        throw e;
    }

    private LexicalPosition<URI> currentLexical() {
        Locator2 locateNow = this.locator;
        LexicalPosition<URI> lexicalPosition = locateNow != null ? LexicalPosition.builder().setColumn(locateNow.getColumnNumber()).setLine(locateNow.getLineNumber()).setFile(this.fileURI).build() : LexicalPosition.builder().setColumn(0).setLine(0).setFile(this.fileURI).build();
        return lexicalPosition;
    }

    private SAXParseException saxParseExceptionOf(Exception e) {
        return new SAXParseException(e.getLocalizedMessage(), this.locator, e);
    }

    public Optional<? extends T> result() {
        return this.stackHandler.result();
    }

    public boolean failed() {
        return this.failed;
    }

    private static final class Builder<U>
    implements BTContentHandlerBuilderType<U> {
        private final HashMap<BTQualifiedName, BTElementHandlerConstructorType<?, U>> handlers = new HashMap(16);

        private Builder() {
        }

        @Override
        public BTContentHandlerBuilderType<U> addHandler(BTQualifiedName name, BTElementHandlerConstructorType<?, U> constructor) {
            this.handlers.put(Objects.requireNonNull(name, "name"), Objects.requireNonNull(constructor, "constructor"));
            return this;
        }

        @Override
        public BTContentHandler<U> build(URI fileURI, Consumer<BTParseError> errorConsumer) {
            return new BTContentHandler(Objects.requireNonNull(fileURI, "fileURI"), Objects.requireNonNull(errorConsumer, "errorConsumer"), Map.copyOf(this.handlers));
        }
    }
}

