/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.blackthorne.api;

import com.io7m.blackthorne.api.BTElementHandlerConstructorType;
import com.io7m.blackthorne.api.BTElementHandlerType;
import com.io7m.blackthorne.api.BTElementParsingContextType;
import com.io7m.blackthorne.api.BTIgnoreUnrecognizedElements;
import com.io7m.blackthorne.api.BTQualifiedName;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class BTListMonoHandler<S>
implements BTElementHandlerType<S, List<S>> {
    private final List<S> childElements;
    private final BTQualifiedName elementName;
    private final BTQualifiedName childElementName;
    private final BTElementHandlerConstructorType<?, ? extends S> itemHandler;
    private final BTIgnoreUnrecognizedElements ignoreUnrecognized;

    public BTListMonoHandler(BTQualifiedName inElementName, BTQualifiedName inChildElementName, BTElementHandlerConstructorType<?, ? extends S> inItemHandler, BTIgnoreUnrecognizedElements inIgnoreUnrecognized) {
        this.elementName = Objects.requireNonNull(inElementName, "elementName");
        this.childElementName = Objects.requireNonNull(inChildElementName, "childElementName");
        this.itemHandler = Objects.requireNonNull(inItemHandler, "itemHandler");
        this.ignoreUnrecognized = Objects.requireNonNull(inIgnoreUnrecognized, "inIgnoreUnrecognized");
        this.childElements = new ArrayList<S>();
    }

    @Override
    public String name() {
        return this.elementName.localName();
    }

    @Override
    public Map<BTQualifiedName, BTElementHandlerConstructorType<?, ? extends S>> onChildHandlersRequested(BTElementParsingContextType context) {
        return Map.ofEntries(Map.entry(this.childElementName, this.itemHandler));
    }

    @Override
    public BTIgnoreUnrecognizedElements onShouldIgnoreUnrecognizedElements(BTElementParsingContextType context) {
        return this.ignoreUnrecognized;
    }

    @Override
    public void onChildValueProduced(BTElementParsingContextType context, S result) {
        this.childElements.add(result);
    }

    @Override
    public List<S> onElementFinished(BTElementParsingContextType context) {
        return List.copyOf(this.childElements);
    }
}

