/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.blackthorne.api;

import com.io7m.blackthorne.api.BTElementHandlerConstructorType;
import com.io7m.blackthorne.api.BTElementHandlerType;
import com.io7m.blackthorne.api.BTElementParsingContextType;
import com.io7m.blackthorne.api.BTIgnoreUnrecognizedElements;
import com.io7m.blackthorne.api.BTQualifiedName;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class BTListPolyHandler<S>
implements BTElementHandlerType<S, List<S>> {
    private final List<S> childElements;
    private final BTQualifiedName elementName;
    private final Map<BTQualifiedName, BTElementHandlerConstructorType<?, ? extends S>> itemHandlers;
    private final BTIgnoreUnrecognizedElements ignoreUnrecognized;

    public BTListPolyHandler(BTQualifiedName inElementName, Map<BTQualifiedName, BTElementHandlerConstructorType<?, ? extends S>> inItemHandlers, BTIgnoreUnrecognizedElements inIgnoreUnrecognized) {
        this.elementName = Objects.requireNonNull(inElementName, "elementName");
        this.itemHandlers = Objects.requireNonNull(inItemHandlers, "itemHandler");
        this.ignoreUnrecognized = Objects.requireNonNull(inIgnoreUnrecognized, "inIgnoreUnrecognized");
        this.childElements = new ArrayList<S>();
    }

    @Override
    public String name() {
        return this.elementName.localName();
    }

    @Override
    public BTIgnoreUnrecognizedElements onShouldIgnoreUnrecognizedElements(BTElementParsingContextType context) {
        return this.ignoreUnrecognized;
    }

    @Override
    public Map<BTQualifiedName, BTElementHandlerConstructorType<?, ? extends S>> onChildHandlersRequested(BTElementParsingContextType context) {
        return this.itemHandlers;
    }

    @Override
    public void onChildValueProduced(BTElementParsingContextType context, S result) {
        this.childElements.add(result);
    }

    @Override
    public List<S> onElementFinished(BTElementParsingContextType context) {
        return List.copyOf(this.childElements);
    }
}

