/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.blackthorne.api;

import com.io7m.blackthorne.api.BTQualifiedNameType;
import java.util.ArrayList;
import java.util.Objects;

public final class BTQualifiedName
implements BTQualifiedNameType {
    private final String namespaceURI;
    private final String localName;

    private BTQualifiedName(String namespaceURI, String localName) {
        this.namespaceURI = Objects.requireNonNull(namespaceURI, "namespaceURI");
        this.localName = Objects.requireNonNull(localName, "localName");
    }

    private BTQualifiedName(BTQualifiedName original, String namespaceURI, String localName) {
        this.namespaceURI = namespaceURI;
        this.localName = localName;
    }

    @Override
    public String namespaceURI() {
        return this.namespaceURI;
    }

    @Override
    public String localName() {
        return this.localName;
    }

    public final BTQualifiedName withNamespaceURI(String value) {
        String newValue = Objects.requireNonNull(value, "namespaceURI");
        if (this.namespaceURI.equals(newValue)) {
            return this;
        }
        return new BTQualifiedName(this, newValue, this.localName);
    }

    public final BTQualifiedName withLocalName(String value) {
        String newValue = Objects.requireNonNull(value, "localName");
        if (this.localName.equals(newValue)) {
            return this;
        }
        return new BTQualifiedName(this, this.namespaceURI, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BTQualifiedName && this.equalTo((BTQualifiedName)another);
    }

    private boolean equalTo(BTQualifiedName another) {
        return this.namespaceURI.equals(another.namespaceURI) && this.localName.equals(another.localName);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.namespaceURI.hashCode();
        h2 += (h2 << 5) + this.localName.hashCode();
        return h2;
    }

    public String toString() {
        return "BTQualifiedName{namespaceURI=" + this.namespaceURI + ", localName=" + this.localName + "}";
    }

    public static BTQualifiedName of(String namespaceURI, String localName) {
        return new BTQualifiedName(namespaceURI, localName);
    }

    public static BTQualifiedName copyOf(BTQualifiedNameType instance) {
        if (instance instanceof BTQualifiedName) {
            return (BTQualifiedName)instance;
        }
        return BTQualifiedName.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAMESPACE_U_R_I = 1L;
        private static final long INIT_BIT_LOCAL_NAME = 2L;
        private long initBits = 3L;
        private String namespaceURI;
        private String localName;

        private Builder() {
        }

        public final Builder from(BTQualifiedNameType instance) {
            Objects.requireNonNull(instance, "instance");
            this.setNamespaceURI(instance.namespaceURI());
            this.setLocalName(instance.localName());
            return this;
        }

        public final Builder setNamespaceURI(String namespaceURI) {
            this.namespaceURI = Objects.requireNonNull(namespaceURI, "namespaceURI");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setLocalName(String localName) {
            this.localName = Objects.requireNonNull(localName, "localName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public BTQualifiedName build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new BTQualifiedName(null, this.namespaceURI, this.localName);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("namespaceURI");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("localName");
            }
            return "Cannot build BTQualifiedName, some of required attributes are not set " + attributes;
        }
    }
}

