/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.blackthorne.api;

import com.io7m.blackthorne.api.BTElementHandlerConstructorType;
import com.io7m.blackthorne.api.BTElementHandlerType;
import com.io7m.blackthorne.api.BTElementParsingContextType;
import com.io7m.blackthorne.api.BTMessages;
import com.io7m.blackthorne.api.BTQualifiedName;
import com.io7m.jaffirm.core.Preconditions;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.Locator2;

public final class BTStackHandler<T> {
    private static final Logger LOG = LoggerFactory.getLogger(BTStackHandler.class);
    private final LinkedList<StackElement> stack = new LinkedList();
    private final Context context;
    private final Map<BTQualifiedName, BTElementHandlerConstructorType<?, T>> rootHandlers;
    private boolean failed;
    private T result;

    public BTStackHandler(Locator2 locator2, Map<BTQualifiedName, BTElementHandlerConstructorType<?, T>> inRootHandlers) {
        this.rootHandlers = Objects.requireNonNull(inRootHandlers, "rootHandlers");
        this.context = new Context(locator2);
    }

    private static String handlerNames(Map<BTQualifiedName, ?> childHandlers) {
        return childHandlers.keySet().stream().map(BTQualifiedName::localName).collect(Collectors.joining("|"));
    }

    public Optional<? extends T> result() {
        return Optional.ofNullable(this.result);
    }

    private void trace(String format, Object ... args) {
        if (LOG.isTraceEnabled()) {
            StackElement stackElement = this.stack.peek();
            String name = null;
            if (stackElement != null) {
                name = stackElement.element.localName();
            }
            LOG.trace("[{}][{}]: {}", name, this.stack.size(), String.format(format, args));
        }
    }

    public void onElementStarted(String namespaceURI, String localName, Attributes attributes) throws Exception {
        try {
            Objects.requireNonNull(namespaceURI, "namespaceURI");
            Objects.requireNonNull(localName, "localName");
            Objects.requireNonNull(attributes, "attributes");
            if (this.failed) {
                return;
            }
            BTQualifiedName qualifiedName = BTQualifiedName.of(namespaceURI, localName);
            if (this.stack.isEmpty()) {
                this.trace("creating root handler for %s:%s", qualifiedName.namespaceURI(), qualifiedName.localName());
                BTElementHandlerConstructorType<?, T> rootHandlerConstructor = this.rootHandlers.get(qualifiedName);
                if (rootHandlerConstructor == null) {
                    throw new SAXParseException(BTMessages.format("errorRootElementNotAllowed", localName, namespaceURI), this.context.documentLocator());
                }
                BTElementHandlerType<?, T> handler = rootHandlerConstructor.create(this.context);
                this.trace("pushing root handler %s", handler.name());
                this.stack.push(new StackElement(qualifiedName, handler));
                handler.onElementStart(this.context, attributes);
                return;
            }
            StackElement topMost = this.stack.peek();
            BTElementHandlerType<?, ?> topMostHandler = topMost.handler;
            if (topMostHandler == null) {
                this.trace("pushing ignored element %s", qualifiedName.localName());
                this.stack.push(new StackElement(qualifiedName, null));
                return;
            }
            Map<BTQualifiedName, BTElementHandlerConstructorType<?, ?>> childHandlers = topMostHandler.onChildHandlersRequested(this.context);
            BTElementHandlerConstructorType<?, ?> childHandlerConstructor = childHandlers.get(qualifiedName);
            if (childHandlerConstructor == null) {
                switch (topMostHandler.onShouldIgnoreUnrecognizedElements(this.context)) {
                    case IGNORE_UNRECOGNIZED_ELEMENTS: {
                        this.trace("pushing ignored element %s", qualifiedName.localName());
                        this.stack.push(new StackElement(qualifiedName, null));
                        return;
                    }
                    case DO_NOT_IGNORE_UNRECOGNIZED_ELEMENTS: {
                        throw new SAXParseException(BTMessages.format("errorHandlerUnrecognizedElement", topMostHandler.getClass().getCanonicalName(), namespaceURI, localName, BTStackHandler.handlerNames(childHandlers)), this.context.documentLocator());
                    }
                }
            }
            BTElementHandlerType<?, ?> newHandler = Objects.requireNonNull(childHandlerConstructor, "childHandlerConstructor").create(this.context);
            Objects.requireNonNull(newHandler, "newHandler");
            this.trace("pushing handler %s", newHandler.name());
            this.stack.push(new StackElement(qualifiedName, newHandler));
            newHandler.onElementStart(this.context, attributes);
        }
        catch (Exception e) {
            this.failed = true;
            throw e;
        }
    }

    public void onCharacters(char[] data, int offset, int length) throws Exception {
        try {
            Objects.requireNonNull(data, "data");
            if (this.failed) {
                return;
            }
            Preconditions.checkPrecondition(!this.stack.isEmpty(), "Handler stack cannot be empty");
            StackElement topMost = this.stack.peek();
            BTElementHandlerType<?, ?> topMostHandler = topMost.handler;
            if (topMostHandler == null) {
                return;
            }
            topMostHandler.onCharacters(this.context, data, offset, length);
        }
        catch (Exception e) {
            this.failed = true;
            throw e;
        }
    }

    public void onElementFinished(String namespaceURI, String localName) throws Exception {
        try {
            Objects.requireNonNull(namespaceURI, "namespaceURI");
            Objects.requireNonNull(localName, "localName");
            if (this.failed) {
                return;
            }
            Preconditions.checkPrecondition(!this.stack.isEmpty(), "Handler stack cannot be empty");
            StackElement topMost = this.stack.peek();
            BTElementHandlerType<?, ?> topMostHandler = topMost.handler;
            if (topMostHandler == null) {
                this.trace("popping ignored element %s", topMost.element.localName());
                this.stack.pop();
                return;
            }
            Object childResult = topMostHandler.onElementFinished(this.context);
            this.trace("popping element with handler %s", topMostHandler.name());
            this.stack.pop();
            StackElement parentElement = this.stack.peek();
            if (parentElement == null) {
                Object castResult = childResult;
                this.result = castResult;
                return;
            }
            BTElementHandlerType<?, ?> parentHandler = parentElement.handler;
            if (parentHandler != null) {
                parentHandler.onChildValueProduced(this.context, childResult);
                return;
            }
        }
        catch (Exception e) {
            this.failed = true;
            throw e;
        }
    }

    private static final class Context
    implements BTElementParsingContextType {
        private final Locator2 locator2;

        private Context(Locator2 inLocator) {
            this.locator2 = Objects.requireNonNull(inLocator, "locator2");
        }

        @Override
        public Locator2 documentLocator() {
            return this.locator2;
        }

        @Override
        public SAXParseException parseException(Exception e) {
            return new SAXParseException(e.getLocalizedMessage(), this.locator2, e);
        }
    }

    private static final class StackElement {
        private final BTQualifiedName element;
        private final BTElementHandlerType<?, ?> handler;

        StackElement(BTQualifiedName inElement, BTElementHandlerType<?, ?> inHandler) {
            this.element = Objects.requireNonNull(inElement, "element");
            this.handler = inHandler;
        }
    }
}

