/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jaffirm.core;

import com.io7m.jaffirm.core.ContractDoubleConditionType;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;

public final class ContractDoubleCondition
implements ContractDoubleConditionType {
    private final DoublePredicate predicate;
    private final DoubleFunction<String> describer;

    private ContractDoubleCondition(DoublePredicate predicate, DoubleFunction<String> describer) {
        this.predicate = Objects.requireNonNull(predicate, "predicate");
        this.describer = Objects.requireNonNull(describer, "describer");
    }

    private ContractDoubleCondition(ContractDoubleCondition original, DoublePredicate predicate, DoubleFunction<String> describer) {
        this.predicate = predicate;
        this.describer = describer;
    }

    @Override
    public DoublePredicate predicate() {
        return this.predicate;
    }

    @Override
    public DoubleFunction<String> describer() {
        return this.describer;
    }

    public final ContractDoubleCondition withPredicate(DoublePredicate value) {
        if (this.predicate == value) {
            return this;
        }
        DoublePredicate newValue = Objects.requireNonNull(value, "predicate");
        return new ContractDoubleCondition(this, newValue, this.describer);
    }

    public final ContractDoubleCondition withDescriber(DoubleFunction<String> value) {
        if (this.describer == value) {
            return this;
        }
        DoubleFunction<String> newValue = Objects.requireNonNull(value, "describer");
        return new ContractDoubleCondition(this, this.predicate, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ContractDoubleCondition && this.equalTo((ContractDoubleCondition)another);
    }

    private boolean equalTo(ContractDoubleCondition another) {
        return this.predicate.equals(another.predicate) && this.describer.equals(another.describer);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.predicate.hashCode();
        h2 += (h2 << 5) + this.describer.hashCode();
        return h2;
    }

    public String toString() {
        return "ContractDoubleCondition{predicate=" + this.predicate + ", describer=" + this.describer + "}";
    }

    public static ContractDoubleCondition of(DoublePredicate predicate, DoubleFunction<String> describer) {
        return new ContractDoubleCondition(predicate, describer);
    }

    public static ContractDoubleCondition copyOf(ContractDoubleConditionType instance) {
        if (instance instanceof ContractDoubleCondition) {
            return (ContractDoubleCondition)instance;
        }
        return ContractDoubleCondition.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PREDICATE = 1L;
        private static final long INIT_BIT_DESCRIBER = 2L;
        private long initBits = 3L;
        private DoublePredicate predicate;
        private DoubleFunction<String> describer;

        private Builder() {
        }

        public final Builder from(ContractDoubleConditionType instance) {
            Objects.requireNonNull(instance, "instance");
            this.setPredicate(instance.predicate());
            this.setDescriber(instance.describer());
            return this;
        }

        public final Builder setPredicate(DoublePredicate predicate) {
            this.predicate = Objects.requireNonNull(predicate, "predicate");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setDescriber(DoubleFunction<String> describer) {
            this.describer = Objects.requireNonNull(describer, "describer");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ContractDoubleCondition build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ContractDoubleCondition(null, this.predicate, this.describer);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("predicate");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("describer");
            }
            return "Cannot build ContractDoubleCondition, some of required attributes are not set " + attributes;
        }
    }
}

