/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jaffirm.core;

import com.io7m.jaffirm.core.ContractIntConditionType;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;

public final class ContractIntCondition
implements ContractIntConditionType {
    private final IntPredicate predicate;
    private final IntFunction<String> describer;

    private ContractIntCondition(IntPredicate predicate, IntFunction<String> describer) {
        this.predicate = Objects.requireNonNull(predicate, "predicate");
        this.describer = Objects.requireNonNull(describer, "describer");
    }

    private ContractIntCondition(ContractIntCondition original, IntPredicate predicate, IntFunction<String> describer) {
        this.predicate = predicate;
        this.describer = describer;
    }

    @Override
    public IntPredicate predicate() {
        return this.predicate;
    }

    @Override
    public IntFunction<String> describer() {
        return this.describer;
    }

    public final ContractIntCondition withPredicate(IntPredicate value) {
        if (this.predicate == value) {
            return this;
        }
        IntPredicate newValue = Objects.requireNonNull(value, "predicate");
        return new ContractIntCondition(this, newValue, this.describer);
    }

    public final ContractIntCondition withDescriber(IntFunction<String> value) {
        if (this.describer == value) {
            return this;
        }
        IntFunction<String> newValue = Objects.requireNonNull(value, "describer");
        return new ContractIntCondition(this, this.predicate, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ContractIntCondition && this.equalTo((ContractIntCondition)another);
    }

    private boolean equalTo(ContractIntCondition another) {
        return this.predicate.equals(another.predicate) && this.describer.equals(another.describer);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.predicate.hashCode();
        h2 += (h2 << 5) + this.describer.hashCode();
        return h2;
    }

    public String toString() {
        return "ContractIntCondition{predicate=" + this.predicate + ", describer=" + this.describer + "}";
    }

    public static ContractIntCondition of(IntPredicate predicate, IntFunction<String> describer) {
        return new ContractIntCondition(predicate, describer);
    }

    public static ContractIntCondition copyOf(ContractIntConditionType instance) {
        if (instance instanceof ContractIntCondition) {
            return (ContractIntCondition)instance;
        }
        return ContractIntCondition.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PREDICATE = 1L;
        private static final long INIT_BIT_DESCRIBER = 2L;
        private long initBits = 3L;
        private IntPredicate predicate;
        private IntFunction<String> describer;

        private Builder() {
        }

        public final Builder from(ContractIntConditionType instance) {
            Objects.requireNonNull(instance, "instance");
            this.setPredicate(instance.predicate());
            this.setDescriber(instance.describer());
            return this;
        }

        public final Builder setPredicate(IntPredicate predicate) {
            this.predicate = Objects.requireNonNull(predicate, "predicate");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setDescriber(IntFunction<String> describer) {
            this.describer = Objects.requireNonNull(describer, "describer");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ContractIntCondition build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ContractIntCondition(null, this.predicate, this.describer);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("predicate");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("describer");
            }
            return "Cannot build ContractIntCondition, some of required attributes are not set " + attributes;
        }
    }
}

