/*
 * Decompiled with CFR 0.152.
 */
package com.io7m.jaffirm.core;

import com.io7m.junreachable.UnreachableCodeException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.function.DoubleFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.LongFunction;
import java.util.function.Supplier;

final class SafeApplication {
    private SafeApplication() {
        throw new UnreachableCodeException();
    }

    static String applySupplierChecked(Supplier<String> message) {
        try {
            return message.get();
        }
        catch (Throwable e) {
            return SafeApplication.failedDescriber(e);
        }
    }

    static <T> String applyDescriberChecked(T value, Function<T, String> describer) {
        try {
            return describer.apply(value);
        }
        catch (Throwable e) {
            return SafeApplication.failedDescriber(e);
        }
    }

    static String applyDescriberIChecked(int value, IntFunction<String> describer) {
        try {
            return describer.apply(value);
        }
        catch (Throwable e) {
            return SafeApplication.failedDescriber(e);
        }
    }

    static String applyDescriberLChecked(long value, LongFunction<String> describer) {
        try {
            return describer.apply(value);
        }
        catch (Throwable e) {
            return SafeApplication.failedDescriber(e);
        }
    }

    static String applyDescriberDChecked(double value, DoubleFunction<String> describer) {
        try {
            return describer.apply(value);
        }
        catch (Throwable e) {
            return SafeApplication.failedDescriber(e);
        }
    }

    private static String failedDescriber(Throwable exception) {
        return SafeApplication.failedApply(exception, "Exception raised whilst evaluating describer: ");
    }

    private static String failedApply(Throwable exception, String prefix) {
        if (exception instanceof Error) {
            throw (Error)exception;
        }
        String line_separator = System.lineSeparator();
        StringBuilder sb = new StringBuilder(128);
        sb.append(prefix);
        sb.append(exception.getClass());
        sb.append(": ");
        sb.append(exception.getMessage());
        sb.append(line_separator);
        sb.append(line_separator);
        SafeApplication.stackTraceToStringBuilder(exception, sb);
        return sb.toString();
    }

    private static void stackTraceToStringBuilder(Throwable exception, StringBuilder sb) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        exception.printStackTrace(pw);
        sb.append(sw);
    }

    static String failedPredicate(Throwable exception) {
        return SafeApplication.failedApply(exception, "Exception raised whilst evaluating predicate: ");
    }
}

